/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.questing.IQuest;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import bq_standard.ScoreboardBQ;
import bq_standard.client.gui.editors.tasks.GuiEditTaskScoreboard;
import bq_standard.client.gui.tasks.PanelTaskScoreboard;
import bq_standard.core.BQ_Standard;
import bq_standard.network.handlers.NetScoreSync;
import bq_standard.tasks.ITaskTickable;
import bq_standard.tasks.factory.FactoryTaskScoreboard;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.scoreboard.IScoreCriteria;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class TaskScoreboard
implements ITaskTickable {
    private final Set<UUID> completeUsers = new TreeSet<UUID>();
    public String scoreName = "Score";
    public String scoreDisp = "Score";
    public String type = "dummy";
    public int target = 1;
    public float conversion = 1.0f;
    public String suffix = "";
    public ScoreOperation operation = ScoreOperation.MORE_OR_EQUAL;

    public ResourceLocation getFactoryID() {
        return FactoryTaskScoreboard.INSTANCE.getRegistryName();
    }

    public String getUnlocalisedName() {
        return "bq_standard.task.scoreboard";
    }

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        this.completeUsers.add(uuid);
    }

    public void resetUser(@Nullable UUID uuid) {
        if (uuid == null) {
            this.completeUsers.clear();
        } else {
            this.completeUsers.remove(uuid);
        }
    }

    @Override
    public void tickTask(@Nonnull ParticipantInfo pInfo, DBEntry<IQuest> quest) {
        if (pInfo.PLAYER.field_70173_aa % 20 == 0) {
            this.detect(pInfo, quest);
        }
    }

    public void detect(@Nonnull ParticipantInfo pInfo, DBEntry<IQuest> quest) {
        int lastValue;
        int points;
        Scoreboard board = pInfo.PLAYER.func_96123_co();
        ScoreObjective scoreObj = board.func_96518_b(this.scoreName);
        if (scoreObj == null) {
            try {
                IScoreCriteria criteria = IScoreCriteria.field_96643_a.computeIfAbsent(this.type, t -> new ScoreCriteria(this.scoreName));
                scoreObj = board.func_96535_a(this.scoreName, criteria);
                scoreObj.func_96681_a(this.scoreDisp);
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to create score '" + this.scoreName + "' for task!", (Throwable)e);
                return;
            }
        }
        if ((points = board.func_96529_a(pInfo.PLAYER.func_70005_c_(), scoreObj).func_96652_c()) != (lastValue = ScoreboardBQ.INSTANCE.getScore(pInfo.UUID, this.scoreName))) {
            ScoreboardBQ.INSTANCE.setScore(pInfo.UUID, this.scoreName, points);
            if (pInfo.PLAYER instanceof EntityPlayerMP) {
                NetScoreSync.sendScore((EntityPlayerMP)pInfo.PLAYER);
            }
        }
        if (this.operation.checkValues(points, this.target)) {
            this.setComplete(pInfo.UUID);
            pInfo.markDirty(Collections.singletonList(quest.getID()));
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound json) {
        json.func_74778_a("scoreName", this.scoreName);
        json.func_74778_a("scoreDisp", this.scoreDisp);
        json.func_74778_a("type", this.type);
        json.func_74768_a("target", this.target);
        json.func_74776_a("unitConversion", this.conversion);
        json.func_74778_a("unitSuffix", this.suffix);
        json.func_74778_a("operation", this.operation.name());
        return json;
    }

    public void readFromNBT(NBTTagCompound json) {
        this.scoreName = json.func_74779_i("scoreName");
        this.scoreName = this.scoreName.replaceAll(" ", "_");
        this.scoreDisp = json.func_74779_i("scoreDisp");
        this.type = json.func_150297_b("type", 8) ? json.func_74779_i("type") : "dummy";
        this.target = json.func_74762_e("target");
        this.conversion = json.func_74760_g("unitConversion");
        this.suffix = json.func_74779_i("unitSuffix");
        try {
            this.operation = ScoreOperation.valueOf(json.func_150297_b("operation", 8) ? json.func_74779_i("operation") : "MORE_OR_EQUAL");
        }
        catch (Exception e) {
            this.operation = ScoreOperation.MORE_OR_EQUAL;
        }
    }

    public NBTTagCompound writeProgressToNBT(NBTTagCompound nbt, @Nullable List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        this.completeUsers.forEach(uuid -> {
            if (users == null || users.contains(uuid)) {
                jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
            }
        });
        nbt.func_74782_a("completeUsers", (NBTBase)jArray);
        return nbt;
    }

    public void readProgressFromNBT(NBTTagCompound nbt, boolean merge) {
        if (!merge) {
            this.completeUsers.clear();
        }
        NBTTagList cList = nbt.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(cList.func_150307_f(i)));
                continue;
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getTaskGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelTaskScoreboard(rect, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, DBEntry<IQuest> quest) {
        return new GuiEditTaskScoreboard(parent, quest, this);
    }

    public static enum ScoreOperation {
        EQUAL("="),
        LESS_THAN("<"),
        MORE_THAN(">"),
        LESS_OR_EQUAL("<="),
        MORE_OR_EQUAL(">="),
        NOT("=/=");

        private final String text;

        private ScoreOperation(String text) {
            this.text = text;
        }

        public String GetText() {
            return this.text;
        }

        public boolean checkValues(int n1, int n2) {
            switch (this) {
                case EQUAL: {
                    return n1 == n2;
                }
                case LESS_THAN: {
                    return n1 < n2;
                }
                case MORE_THAN: {
                    return n1 > n2;
                }
                case LESS_OR_EQUAL: {
                    return n1 <= n2;
                }
                case MORE_OR_EQUAL: {
                    return n1 >= n2;
                }
                case NOT: {
                    return n1 != n2;
                }
            }
            return false;
        }
    }
}

