/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.utils.ItemComparison;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.ParticipantInfo;
import bq_standard.client.gui.editors.tasks.GuiEditTaskTame;
import bq_standard.client.gui.tasks.PanelTaskTame;
import bq_standard.core.BQ_Standard;
import bq_standard.tasks.factory.FactoryTaskTame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class TaskTame
implements ITask {
    private final Set<UUID> completeUsers = new TreeSet<UUID>();
    public final HashMap<UUID, Integer> userProgress = new HashMap();
    public String idName = "minecraft:wolf";
    public int required = 1;
    public boolean ignoreNBT = true;
    public boolean subtypes = true;
    public NBTTagCompound targetTags = new NBTTagCompound();

    public String getUnlocalisedName() {
        return "bq_standard.task.tame";
    }

    public ResourceLocation getFactoryID() {
        return FactoryTaskTame.INSTANCE.getRegistryName();
    }

    public void detect(ParticipantInfo pInfo, DBEntry<IQuest> quest) {
        List<Tuple<UUID, Integer>> progress = this.getBulkProgress(pInfo.ALL_UUIDS);
        int prev = this.completeUsers.size();
        progress.forEach(value -> {
            if ((Integer)value.func_76340_b() >= this.required) {
                this.setComplete((UUID)value.func_76341_a());
            }
        });
        if (prev != this.completeUsers.size()) {
            pInfo.markDirtyParty(Collections.singletonList(quest.getID()));
        }
    }

    public void onAnimalTamed(ParticipantInfo pInfo, DBEntry<IQuest> quest, @Nonnull EntityLivingBase entity) {
        Class<?> subject = entity.getClass();
        ResourceLocation targetID = new ResourceLocation(this.idName);
        Class target = EntityList.getClass((ResourceLocation)targetID);
        ResourceLocation subjectID = EntityList.func_191306_a(subject);
        if (subjectID == null || target == null) {
            return;
        }
        if (this.subtypes && !target.isAssignableFrom(subject)) {
            return;
        }
        if (!this.subtypes && !subjectID.equals((Object)targetID)) {
            return;
        }
        NBTTagCompound subjectTags = new NBTTagCompound();
        entity.func_70039_c(subjectTags);
        if (!this.ignoreNBT && !ItemComparison.CompareNBTTag((NBTBase)this.targetTags, (NBTBase)subjectTags, (boolean)true)) {
            return;
        }
        List<Tuple<UUID, Integer>> progress = this.getBulkProgress(pInfo.ALL_UUIDS);
        progress.forEach(value -> {
            if (this.isComplete((UUID)value.func_76341_a())) {
                return;
            }
            int np = Math.min(this.required, (Integer)value.func_76340_b() + 1);
            this.setUserProgress((UUID)value.func_76341_a(), np);
            if (np >= this.required) {
                this.setComplete((UUID)value.func_76341_a());
            }
        });
        pInfo.markDirtyParty(Collections.singletonList(quest.getID()));
    }

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        this.completeUsers.add(uuid);
    }

    public void resetUser(@Nullable UUID uuid) {
        if (uuid == null) {
            this.completeUsers.clear();
            this.userProgress.clear();
        } else {
            this.completeUsers.remove(uuid);
            this.userProgress.remove(uuid);
        }
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getTaskGui(IGuiRect rect, DBEntry<IQuest> quest) {
        return new PanelTaskTame(rect, this);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen parent, DBEntry<IQuest> quest) {
        return new GuiEditTaskTame(parent, quest, this);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound json) {
        json.func_74778_a("target", this.idName);
        json.func_74768_a("required", this.required);
        json.func_74757_a("subtypes", this.subtypes);
        json.func_74757_a("ignoreNBT", this.ignoreNBT);
        json.func_74782_a("targetNBT", (NBTBase)this.targetTags);
        return json;
    }

    public void readFromNBT(NBTTagCompound json) {
        this.idName = json.func_74779_i("target");
        this.required = json.func_74762_e("required");
        this.subtypes = json.func_74767_n("subtypes");
        this.ignoreNBT = json.func_74767_n("ignoreNBT");
        this.targetTags = json.func_74775_l("targetNBT");
    }

    public void readProgressFromNBT(NBTTagCompound nbt, boolean merge) {
        if (!merge) {
            this.completeUsers.clear();
            this.userProgress.clear();
        }
        NBTTagList cList = nbt.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(cList.func_150307_f(i)));
                continue;
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
        NBTTagList pList = nbt.func_150295_c("userProgress", 10);
        for (int n = 0; n < pList.func_74745_c(); ++n) {
            try {
                NBTTagCompound pTag = pList.func_150305_b(n);
                UUID uuid = UUID.fromString(pTag.func_74779_i("uuid"));
                this.userProgress.put(uuid, pTag.func_74762_e("value"));
                continue;
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load user progress for task", (Throwable)e);
            }
        }
    }

    public NBTTagCompound writeProgressToNBT(NBTTagCompound nbt, @Nullable List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        NBTTagList progArray = new NBTTagList();
        if (users != null) {
            users.forEach(uuid -> {
                Integer data;
                if (this.completeUsers.contains(uuid)) {
                    jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
                }
                if ((data = this.userProgress.get(uuid)) != null) {
                    NBTTagCompound pJson = new NBTTagCompound();
                    pJson.func_74778_a("uuid", uuid.toString());
                    pJson.func_74768_a("value", data.intValue());
                    progArray.func_74742_a((NBTBase)pJson);
                }
            });
        } else {
            this.completeUsers.forEach(uuid -> jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString())));
            this.userProgress.forEach((uuid, data) -> {
                NBTTagCompound pJson = new NBTTagCompound();
                pJson.func_74778_a("uuid", uuid.toString());
                pJson.func_74768_a("value", data.intValue());
                progArray.func_74742_a((NBTBase)pJson);
            });
        }
        nbt.func_74782_a("completeUsers", (NBTBase)jArray);
        nbt.func_74782_a("userProgress", (NBTBase)progArray);
        return nbt;
    }

    private void setUserProgress(UUID uuid, int progress) {
        this.userProgress.put(uuid, progress);
    }

    public int getUsersProgress(UUID uuid) {
        Integer n = this.userProgress.get(uuid);
        return n == null ? 0 : n;
    }

    private List<Tuple<UUID, Integer>> getBulkProgress(@Nonnull List<UUID> uuids) {
        if (uuids.size() <= 0) {
            return Collections.emptyList();
        }
        ArrayList<Tuple<UUID, Integer>> list = new ArrayList<Tuple<UUID, Integer>>();
        uuids.forEach(key -> list.add(new Tuple(key, (Object)this.getUsersProgress((UUID)key))));
        return list;
    }
}

