/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.crafting.feature;

import net.minecraft.block.SoundType;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import svenhjol.charm.crafting.block.BlockLantern;
import svenhjol.charm.crafting.compat.FutureMcSounds;
import svenhjol.charm.world.compat.FutureMcBlocks;
import svenhjol.meson.Feature;
import svenhjol.meson.handler.RecipeHandler;
import svenhjol.meson.helper.ForgeHelper;
import svenhjol.meson.registry.ProxyRegistry;

public class Lantern
extends Feature {
    public static BlockLantern ironLantern;
    public static BlockLantern goldLantern;
    public static float hardness;
    public static float resistance;
    public static float lightLevel;
    public static int numberOfLanterns;
    public static boolean falling;
    public static boolean playSound;
    public static boolean useCharmLanterns;

    @Override
    public String getDescription() {
        return "An elegant lighting solution.  Comes in iron and gold.";
    }

    @Override
    public void configure() {
        super.configure();
        falling = this.propBoolean("Lanterns obey gravity", "Lantern will fall when the block under it is broken, or when the block above a hanging lantern is broken.", true);
        useCharmLanterns = this.propBoolean("Use Charm lanterns", "Charm's lanterns will be enabled even if lanterns from other mods are present.", false);
        numberOfLanterns = this.propInt("Number of lanterns crafted", "Number of lanterns output when crafting a lantern.", 1);
        hardness = 3.5f;
        resistance = 4.0f;
        lightLevel = 1.0f;
        playSound = true;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        if (useCharmLanterns || !ForgeHelper.areModsLoaded("futuremc")) {
            ironLantern = new BlockLantern("iron");
            if (!ForgeHelper.areModsLoaded("futuremc")) {
                RecipeHandler.addShapedRecipe(ProxyRegistry.newStack(ironLantern, numberOfLanterns), "III", "ITI", "III", Character.valueOf('I'), Items.field_191525_da, Character.valueOf('T'), Blocks.field_150478_aa);
            }
        }
        goldLantern = new BlockLantern("gold");
        RecipeHandler.addShapedRecipe(ProxyRegistry.newStack(goldLantern, numberOfLanterns), "GGG", "GTG", "GGG", Character.valueOf('G'), Items.field_151074_bl, Character.valueOf('T'), Blocks.field_150478_aa);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRegister(RegistryEvent.Register<IRecipe> event) {
        if (FutureMcBlocks.lantern == null) {
            RecipeHandler.addShapedRecipe(ProxyRegistry.newStack(ironLantern, numberOfLanterns), "III", "ITI", "III", Character.valueOf('I'), Items.field_191525_da, Character.valueOf('T'), Blocks.field_150478_aa);
        } else {
            RecipeHandler.addShapelessRecipe(ProxyRegistry.newStack(ironLantern), new ItemStack(FutureMcBlocks.lantern));
            RecipeHandler.addShapelessRecipe(new ItemStack(FutureMcBlocks.lantern), ProxyRegistry.newStack(ironLantern));
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return ForgeHelper.areModsLoaded("futuremc") && useCharmLanterns;
    }

    @Override
    public void init(FMLInitializationEvent event) {
        SoundType lanternSoundType = FutureMcSounds.getLanternSoundType();
        if (lanternSoundType != null) {
            if (ironLantern != null) {
                ironLantern.func_149672_a(lanternSoundType);
            }
            goldLantern.func_149672_a(lanternSoundType);
        }
    }

    public static BlockLantern getDefaultLantern() {
        return ironLantern == null ? goldLantern : ironLantern;
    }
}

