/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.feature;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityIllusionIllager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import svenhjol.charm.Charm;
import svenhjol.charm.world.feature.TotemOfReturning;
import svenhjol.charm.world.feature.TotemOfShielding;
import svenhjol.meson.Feature;

public class IllusionersInRoofedForest
extends Feature {
    public static int weight;
    public static double dropChance;

    @Override
    public String getDescription() {
        return "Illusioners are spell-casting illagers equipped with bows that create fake copies of themselves while fighting.\nThis feature lets illusioners spawn in Roofed Forest biomes.  An illusioner has a chance of dropping a totem.";
    }

    @Override
    public void configure() {
        super.configure();
        weight = this.propInt("Spawn weight", "The higher this value, the more illusioners will spawn.", 30);
        dropChance = this.propDouble("Drop chance", "Chance (out of 1.0) of an illusioner dropping items when killed.", 1.0);
    }

    @Override
    public void init(FMLInitializationEvent event) {
        Biome.SpawnListEntry illusionerEntry = new Biome.SpawnListEntry(EntityIllusionIllager.class, weight, 1, 1);
        Biome roofedForest = Biomes.field_150585_R;
        roofedForest.func_76747_a(EnumCreatureType.MONSTER).add(illusionerEntry);
    }

    @SubscribeEvent
    public void onSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (!event.isSpawner() && event.getEntityLiving() instanceof EntityIllusionIllager && event.getResult() != Event.Result.DENY && event.getEntityLiving().field_70170_p instanceof WorldServer && event.getEntityLiving().func_180425_c().func_177956_o() < event.getEntityLiving().field_70170_p.func_181545_F()) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onDrops(LivingDropsEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof EntityIllusionIllager && event.getSource().func_76346_g() instanceof EntityPlayer && (double)event.getEntityLiving().field_70170_p.field_73012_v.nextFloat() <= dropChance) {
            Entity entity = event.getEntity();
            ItemStack emeralds = new ItemStack(Items.field_151166_bC, entity.field_70170_p.field_73012_v.nextInt(3) + 2);
            ItemStack totem = null;
            List drops = event.getDrops();
            drops.add(new EntityItem(entity.func_130014_f_(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, emeralds));
            if (Charm.hasFeature(TotemOfReturning.class) && TotemOfReturning.addToIllusioner) {
                totem = new ItemStack(TotemOfReturning.totem);
            }
            if (Charm.hasFeature(TotemOfShielding.class) && TotemOfShielding.addToIllusioner && (totem == null || event.getEntityLiving().field_70170_p.field_73012_v.nextFloat() < 0.5f)) {
                totem = new ItemStack(TotemOfShielding.totem);
            }
            if (totem != null) {
                drops.add(new EntityItem(entity.func_130014_f_(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, totem));
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

