/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import svenhjol.meson.Feature;
import svenhjol.meson.helper.ItemNBTHelper;
import svenhjol.meson.helper.WorldHelper;
import svenhjol.meson.registry.VillagerRegistry;

public class StructureMaps
extends Feature {
    public static int tradeLevel;
    public static int biomeMinCost;
    public static int biomeMaxCost;
    public static int generalMinCost;
    public static int generalMaxCost;
    public static List<String> biomeStructures;
    public static List<String> generalStructures;
    public static List<Structure> structures;

    @Override
    public String getDescription() {
        return "Cartographers sell Structure Maps that can be used to find overworld structures.";
    }

    @Override
    public void configure() {
        super.configure();
        biomeStructures = Arrays.asList(this.propStringList("Biome-specific structures", "List of biome-specific structures that are available as map locations.", new String[]{WorldHelper.StructureType.DESERT_PYRAMID.func_176610_l(), WorldHelper.StructureType.IGLOO.func_176610_l(), WorldHelper.StructureType.JUNGLE_PYRAMID.func_176610_l(), WorldHelper.StructureType.SWAMP_HUT.func_176610_l()}));
        generalStructures = Arrays.asList(this.propStringList("General structures", "List of general structures that are available as map locations.", new String[]{WorldHelper.StructureType.MINESHAFT.func_176610_l(), WorldHelper.StructureType.VILLAGE.func_176610_l()}));
        tradeLevel = this.propInt("Trade level", "The level at which a cartographer will be unlocked for trading structure maps.", 3);
        generalMinCost = this.propInt("General structures minimum cost", "Minimum emerald cost of a general structure map.", 4);
        generalMaxCost = this.propInt("General structures maximum cost", "Maximum emerald cost of a general structure map.", 7);
        biomeMinCost = this.propInt("Biome-specific minimum cost", "Minimum emerald cost of a biome-specific structure map.", 16);
        biomeMaxCost = this.propInt("Biome-specific maximum cost", "Maximum emerald cost of a biome-specific structure map.", 22);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        if (generalStructures.contains(WorldHelper.StructureType.MINESHAFT.func_176610_l())) {
            structures.add(new Structure(WorldHelper.StructureType.MINESHAFT, 0x774400));
        }
        if (generalStructures.contains(WorldHelper.StructureType.VILLAGE.func_176610_l())) {
            structures.add(new Structure(WorldHelper.StructureType.VILLAGE, 0xCC2000));
        }
        if (biomeStructures.contains(WorldHelper.StructureType.IGLOO.func_176610_l())) {
            structures.add(new Structure(WorldHelper.StructureType.IGLOO, 10535167));
        }
        if (biomeStructures.contains(WorldHelper.StructureType.DESERT_PYRAMID.func_176610_l())) {
            structures.add(new Structure(WorldHelper.StructureType.DESERT_PYRAMID, 0x866600));
        }
        if (biomeStructures.contains(WorldHelper.StructureType.JUNGLE_PYRAMID.func_176610_l())) {
            structures.add(new Structure(WorldHelper.StructureType.JUNGLE_PYRAMID, 0x20B020));
        }
        if (biomeStructures.contains(WorldHelper.StructureType.SWAMP_HUT.func_176610_l())) {
            structures.add(new Structure(WorldHelper.StructureType.SWAMP_HUT, 0x107000));
        }
        if (biomeStructures.contains(WorldHelper.StructureType.STRONGHOLD.func_176610_l())) {
            structures.add(new Structure(WorldHelper.StructureType.STRONGHOLD, 0x505050));
        }
        if (biomeStructures.contains(WorldHelper.StructureType.MANSION.func_176610_l())) {
            structures.add(new Structure(WorldHelper.StructureType.MANSION, 0x774400));
        }
    }

    @SubscribeEvent
    public void onRegisterVillagers(RegistryEvent.Register<VillagerRegistry.VillagerProfession> event) {
        VillagerRegistry.VillagerCareer cartographer = VillagerRegistry.cartographer;
        cartographer.addTrade(tradeLevel, new EntityVillager.ITradeList[]{new StructureMapTrade()});
    }

    public static ItemStack createMap(World world, BlockPos pos, Structure structure) {
        BlockPos offset = pos.func_177967_a(EnumFacing.func_176741_a((Random)world.field_73012_v), 250);
        BlockPos structurePos = WorldHelper.getNearestStructure(world, offset, structure.type);
        if (structurePos == null) {
            return new ItemStack((Item)Items.field_151148_bJ, 2);
        }
        int id = world.func_72841_b("map");
        ItemStack stack = new ItemStack((Item)Items.field_151098_aY, 1, id);
        stack.func_190924_f("charm.map." + structure.type.func_176610_l());
        NBTTagCompound tag = ItemNBTHelper.getCompound(stack, "display");
        tag.func_74768_a("MapColor", structure.color);
        ItemNBTHelper.setCompound(stack, "display", tag);
        String mapId = "map_" + id;
        MapData mapData = new MapData(mapId);
        world.func_72823_a(mapId, (WorldSavedData)mapData);
        mapData.field_76197_d = (byte)2;
        mapData.field_76201_a = structurePos.func_177958_n() + (int)((Math.random() - 0.5) * 200.0);
        mapData.field_76199_b = structurePos.func_177952_p() + (int)((Math.random() - 0.5) * 200.0);
        mapData.field_76200_c = structure.dimension;
        mapData.field_186210_e = true;
        mapData.field_191096_f = true;
        ItemMap.func_190905_a((World)world, (ItemStack)stack);
        MapData.func_191094_a((ItemStack)stack, (BlockPos)structurePos, (String)"+", (MapDecoration.Type)MapDecoration.Type.TARGET_X);
        return stack;
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }

    static {
        biomeStructures = new ArrayList<String>();
        generalStructures = new ArrayList<String>();
        structures = new ArrayList<Structure>();
    }

    public class StructureMapTrade
    implements EntityVillager.ITradeList {
        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            if (structures.isEmpty()) {
                return;
            }
            Structure structure = structures.get(random.nextInt(structures.size()));
            ItemStack map = StructureMaps.createMap(merchant.func_190670_t_(), merchant.func_190671_u_(), structure);
            int emeraldCount = generalStructures.contains(structure.type.func_176610_l()) ? random.nextInt(generalMaxCost - generalMinCost) + generalMinCost : random.nextInt(biomeMaxCost - biomeMinCost) + biomeMinCost;
            recipeList.add((Object)new MerchantRecipe(new ItemStack(Items.field_151166_bC, emeraldCount), new ItemStack(Items.field_151111_aL), map, 0, 1));
        }
    }

    public class Structure {
        public WorldHelper.StructureType type;
        public int dimension = 0;
        public int color = 0;

        public Structure(WorldHelper.StructureType type) {
            this.type = type;
        }

        public Structure(WorldHelper.StructureType type, int color) {
            this.type = type;
            this.color = color;
        }

        public Structure(WorldHelper.StructureType type, int color, int dimension) {
            this.type = type;
            this.dimension = dimension;
            this.color = color;
        }
    }
}

