/*
 * Decompiled with CFR 0.152.
 */
package rustic.client.gui;

import java.util.ArrayList;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import rustic.client.util.FluidClientUtil;
import rustic.common.blocks.fluids.FluidBooze;
import rustic.common.tileentity.ContainerBrewingBarrel;
import rustic.common.tileentity.TileEntityBrewingBarrel;

public class GuiBrewingBarrel
extends GuiContainer {
    public static final int WIDTH = 176;
    public static final int HEIGHT = 166;
    private static final ResourceLocation background = new ResourceLocation("rustic", "textures/gui/brewing_barrel.png");
    private TileEntityBrewingBarrel te;

    public GuiBrewingBarrel(ContainerBrewingBarrel container, IInventory playerInv) {
        super((Container)container);
        this.te = container.getTile();
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        if (this.func_146978_c(62, 27, 16, 32, mouseX, mouseY)) {
            this.drawFluidTooltip(this.te.getInputFluid(), this.te.getInputCapacity(), mouseX, mouseY);
        }
        if (this.func_146978_c(116, 27, 16, 32, mouseX, mouseY)) {
            this.drawFluidTooltip(this.te.getOutputFluid(), this.te.getOutputCapacity(), mouseX, mouseY);
        }
        if (this.func_146978_c(26, 35, 16, 16, mouseX, mouseY)) {
            this.drawFluidTooltip(this.te.getAuxiliaryFluid(), this.te.getAuxiliaryCapacity(), mouseX, mouseY);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(background);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.te.getInputAmount() > 0) {
            FluidClientUtil.drawGuiLiquid(new FluidStack(this.te.getInputFluid(), this.te.getInputAmount()), this.te.getInputCapacity(), this.field_147003_i + 62, this.field_147009_r + 27, 16, 32, background);
        }
        if (this.te.getOutputAmount() > 0) {
            FluidClientUtil.drawGuiLiquid(new FluidStack(this.te.getOutputFluid(), this.te.getOutputAmount()), this.te.getOutputCapacity(), this.field_147003_i + 116, this.field_147009_r + 27, 16, 32, background);
        }
        if (this.te.getAuxiliaryAmount() > 0) {
            FluidClientUtil.drawGuiLiquid(new FluidStack(this.te.getAuxiliaryFluid(), this.te.getAuxiliaryAmount()), this.te.getAuxiliaryCapacity(), this.field_147003_i + 26, this.field_147009_r + 35, 16, 16, background);
        }
        if (this.te.slot0Empty()) {
            this.func_73729_b(this.field_147003_i + 62, this.field_147009_r + 7, 176, 54, 16, 16);
        }
        if (this.te.slot1Empty()) {
            this.func_73729_b(this.field_147003_i + 116, this.field_147009_r + 7, 176, 70, 16, 16);
        }
        if (this.te.slot2Empty()) {
            this.func_73729_b(this.field_147003_i + 26, this.field_147009_r + 15, 176, 70, 16, 16);
        }
        if (this.te.isBrewing()) {
            int k = this.getBubbles();
            this.func_73729_b(this.field_147003_i + 139, this.field_147009_r + 29 + 28 - k, 176, 28 - k, 11, k);
        }
        int l = this.getBrewProgressScaled(24);
        this.func_73729_b(this.field_147003_i + 85, this.field_147009_r + 35, 176, 28, l, 16);
        int m = this.getBrewProgressScaled(10);
        this.func_73729_b(this.field_147003_i + 45, this.field_147009_r + 38, 176, 44, m, 10);
    }

    private int getBrewProgressScaled(int pixels) {
        int i = this.te.getBrewTime();
        int j = this.te.getMaxBrewTime();
        return j != 0 && i != 0 ? i * pixels / j + 1 : 0;
    }

    private int getBubbles() {
        int i = this.te.getBrewTime();
        int j = this.te.getMaxBrewTime();
        return j != 0 && i != 0 ? (int)((float)i / (float)j * 5600.0f) % 28 : 0;
    }

    protected void drawFluidTooltip(FluidStack fluid, int capacity, int x, int y) {
        ArrayList<String> lines = new ArrayList<String>();
        if (fluid == null || fluid.getFluid() == null || fluid.amount <= 0) {
            lines.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltip.rustic.empty", (Object[])new Object[0]));
            lines.add(TextFormatting.GRAY + "" + 0 + "/" + capacity);
        } else {
            lines.add(fluid.getFluid().getRarity((FluidStack)fluid).field_77937_e + fluid.getLocalizedName());
            lines.add(TextFormatting.GRAY + "" + fluid.amount + "/" + capacity);
            if (fluid.getFluid() instanceof FluidBooze && fluid.tag != null && fluid.tag.func_150297_b("Quality", 5)) {
                float quality = fluid.tag.func_74760_g("Quality");
                lines.add(TextFormatting.GOLD + "" + I18n.func_135052_a((String)"tooltip.rustic.quality", (Object[])new Object[0]) + quality);
            }
        }
        this.func_146283_a(lines, x - this.field_147003_i, y - this.field_147009_r);
    }
}

