/*
 * Decompiled with CFR 0.152.
 */
package rustic.client.models;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import rustic.common.blocks.BlockLattice;
import rustic.core.Rustic;

public class LatticeModel
implements IModel {
    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IBakedModel base = null;
        IBakedModel[] bars = new IBakedModel[6];
        IBakedModel leaves = null;
        IBakedModel[] leaf_bars = new IBakedModel[6];
        ModelRotation[] rotations = new ModelRotation[]{ModelRotation.X90_Y0, ModelRotation.X270_Y0, ModelRotation.X0_Y0, ModelRotation.X0_Y180, ModelRotation.X0_Y270, ModelRotation.X0_Y90};
        try {
            IModel baseModel = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("rustic", "block/lattice_iron_base"));
            IModel barModel = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("rustic", "block/lattice_iron_bar"));
            IModel leavesModel = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("rustic", "block/lattice_leaves_base"));
            IModel leaf_barModel = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("rustic", "block/lattice_leaves_bar"));
            for (int i = 0; i < 6; ++i) {
                base = baseModel.bake((IModelState)new TRSRTransformation(rotations[i]), DefaultVertexFormats.field_176600_a, ModelLoader.defaultTextureGetter());
                bars[i] = barModel.bake((IModelState)new TRSRTransformation(rotations[i]), DefaultVertexFormats.field_176600_a, ModelLoader.defaultTextureGetter());
                leaves = leavesModel.bake((IModelState)new TRSRTransformation(rotations[i]), DefaultVertexFormats.field_176600_a, ModelLoader.defaultTextureGetter());
                leaf_bars[i] = leaf_barModel.bake((IModelState)new TRSRTransformation(rotations[i]), DefaultVertexFormats.field_176600_a, ModelLoader.defaultTextureGetter());
            }
        }
        catch (Exception e) {
            Rustic.logger.warn(e.getMessage());
        }
        if (base == null) {
            return ModelLoaderRegistry.getMissingModel().bake(state, format, bakedTextureGetter);
        }
        return new BakedLatticeModel(base, bars, leaves, leaf_bars);
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of((Object)new ResourceLocation("rustic", "block/lattice_iron_base"), (Object)new ResourceLocation("rustic", "block/lattice_iron_bar"), (Object)new ResourceLocation("rustic", "block/lattice_leaves_base"), (Object)new ResourceLocation("rustic", "block/lattice_leaves_bar"));
    }

    public static class BakedLatticeModel
    implements IBakedModel {
        private IBakedModel base;
        private IBakedModel[] bars;
        private IBakedModel leaves;
        private IBakedModel[] leaf_bars;

        public BakedLatticeModel(IBakedModel base, IBakedModel[] bars, IBakedModel leaves, IBakedModel[] leaf_bars) {
            this.base = base;
            this.bars = bars;
            this.leaves = leaves;
            this.leaf_bars = leaf_bars;
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            if (state instanceof IExtendedBlockState) {
                List<IBakedModel> subModels = this.getSubModels((IExtendedBlockState)state);
                ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
                for (IBakedModel model : subModels) {
                    quads.addAll(model.func_188616_a(state, side, rand));
                }
                return quads;
            }
            return Collections.EMPTY_LIST;
        }

        private List<IBakedModel> getSubModels(IExtendedBlockState state) {
            ArrayList<IBakedModel> subModels = new ArrayList<IBakedModel>();
            subModels.add(this.base);
            boolean foliage = (Boolean)state.func_177229_b((IProperty)BlockLattice.LEAVES);
            if (foliage) {
                subModels.add(this.leaves);
            }
            try {
                for (int i = 0; i < 6; ++i) {
                    if (!((Boolean)state.getValue((IUnlistedProperty)BlockLattice.CONNECTIONS[i])).booleanValue()) continue;
                    subModels.add(this.bars[i]);
                    if (!foliage) continue;
                    subModels.add(this.leaf_bars[i]);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return subModels;
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return true;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.base.func_177554_e();
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }
    }

    public static class LatticeModelLoader
    implements ICustomModelLoader {
        private static LatticeModel model;

        public void func_110549_a(IResourceManager resourceManager) {
            model = new LatticeModel();
        }

        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.func_110624_b().equals("rustic") && modelLocation.func_110623_a().equals("iron_lattice");
        }

        public IModel loadModel(ResourceLocation modelLocation) throws Exception {
            if (model == null) {
                model = new LatticeModel();
            }
            return model;
        }
    }
}

