/*
 * Decompiled with CFR 0.152.
 */
package rustic.client.models;

import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.Fluid;
import org.apache.commons.lang3.tuple.Pair;
import rustic.client.util.FluidClientUtil;

public class LiquidBarrelFilledItemModel
implements IBakedModel {
    private int amount;
    private int capacity;
    private Fluid fluid;
    private IBakedModel parentModel;

    public LiquidBarrelFilledItemModel(IBakedModel parentModel, int amount, int capacity, Fluid fluid) {
        this.parentModel = parentModel;
        this.amount = amount;
        this.capacity = capacity;
        this.fluid = fluid;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        ArrayList<BakedQuad> combinedQuadsList = new ArrayList<BakedQuad>(this.parentModel.func_188616_a(state, side, rand));
        combinedQuadsList.addAll(this.getLiquidQuads(this.amount, this.capacity, this.fluid));
        return combinedQuadsList;
    }

    public boolean func_177555_b() {
        return this.parentModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.parentModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.parentModel.func_188618_c();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.parentModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.parentModel.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        throw new UnsupportedOperationException("The finalized model does not have an override list.");
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        if (this.parentModel instanceof IBakedModel) {
            Matrix4f matrix4f = (Matrix4f)this.parentModel.handlePerspective(cameraTransformType).getRight();
            return Pair.of((Object)this, (Object)matrix4f);
        }
        ItemCameraTransforms itemCameraTransforms = this.parentModel.func_177552_f();
        ItemTransformVec3f itemTransformVec3f = itemCameraTransforms.func_181688_b(cameraTransformType);
        TRSRTransformation tr = new TRSRTransformation(itemTransformVec3f);
        Matrix4f mat = null;
        if (tr != null) {
            mat = tr.getMatrix();
        }
        return Pair.of((Object)this, (Object)mat);
    }

    private int[] vertexToInts(float x, float y, float z, int color, TextureAtlasSprite texture, float u, float v) {
        return new int[]{Float.floatToRawIntBits(x), Float.floatToRawIntBits(y), Float.floatToRawIntBits(z), color, Float.floatToRawIntBits(texture.func_94214_a((double)u)), Float.floatToRawIntBits(texture.func_94207_b((double)v)), 0};
    }

    private List<BakedQuad> getLiquidQuads(int amount, int capacity, Fluid fluid) {
        ArrayList<BakedQuad> returnList = new ArrayList<BakedQuad>();
        if (fluid != null) {
            float y4;
            TextureAtlasSprite fluidTexture = FluidClientUtil.stillTextures.get(fluid);
            if (fluidTexture == null) {
                return returnList;
            }
            float x2 = 0.8125f;
            float x1 = 0.8125f;
            float x4 = 0.1875f;
            float x3 = 0.1875f;
            float z4 = 0.8125f;
            float z1 = 0.8125f;
            float z3 = 0.1875f;
            float z2 = 0.1875f;
            float y3 = y4 = 0.125f + 0.8125f * ((float)amount / (float)capacity);
            float y2 = y4;
            float y1 = y4;
            int c = -16777216;
            if (fluid != null) {
                c = fluid.getColor();
            }
            int blue = c & 0xFF;
            int green = c >> 8 & 0xFF;
            int red = c >> 16 & 0xFF;
            int alpha = c >> 24 & 0xFF;
            int color = (red & 0xFF) << 24 | (green & 0xFF) << 16 | (blue & 0xFF) << 8 | alpha & 0xFF;
            int[] vertexData = Ints.concat((int[][])new int[][]{this.vertexToInts(x1, y1, z1, color, fluidTexture, 16.0f, 16.0f), this.vertexToInts(x2, y2, z2, color, fluidTexture, 16.0f, 0.0f), this.vertexToInts(x3, y3, z3, color, fluidTexture, 0.0f, 0.0f), this.vertexToInts(x4, y4, z4, color, fluidTexture, 0.0f, 16.0f)});
            returnList.add(new BakedQuad(vertexData, 0, EnumFacing.UP, fluidTexture, true, DefaultVertexFormats.field_176600_a));
        }
        return returnList;
    }
}

