/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.blocks;

import com.google.common.base.Predicate;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rustic.common.blocks.BlockCandle;

public class BlockCandleLever
extends BlockCandle {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)new Predicate<EnumFacing>(){

        public boolean apply(@Nullable EnumFacing p_apply_1_) {
            return p_apply_1_ != EnumFacing.DOWN;
        }
    });

    public BlockCandleLever() {
        this("candle_lever");
    }

    public BlockCandleLever(String name) {
        this(Material.field_151594_q, name, true);
    }

    public BlockCandleLever(Material mat, String name, boolean register) {
        super(mat, name, register);
        this.func_149711_c(1.0f);
        this.func_149715_a(1.0f);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP).func_177226_a((IProperty)BlockButton.field_176584_b, (Comparable)Boolean.valueOf(false)));
        this.func_149672_a(SoundType.field_185852_e);
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (this.canPlaceAt(worldIn, pos, facing)) {
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!worldIn.isSideSolid(pos.func_177972_a(enumfacing.func_176734_d()), enumfacing, true)) continue;
            return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        }
        return this.func_176223_P();
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta & 7).func_177226_a((IProperty)BlockButton.field_176584_b, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int i = super.func_176201_c(state);
        if (((Boolean)state.func_177229_b((IProperty)BlockButton.field_176584_b)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, BlockButton.field_176584_b});
    }

    public int func_149738_a(World worldIn) {
        return 80;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (((Boolean)state.func_177229_b((IProperty)BlockButton.field_176584_b)).booleanValue()) {
            return true;
        }
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)BlockButton.field_176584_b, (Comparable)Boolean.valueOf(true)), 3);
        worldIn.func_175704_b(pos, pos);
        this.playClickSound(playerIn, worldIn, pos);
        this.notifyNeighbors(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)FACING));
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
        return true;
    }

    private void notifyNeighbors(World worldIn, BlockPos pos, EnumFacing facing) {
        worldIn.func_175685_c(pos, (Block)this, false);
        worldIn.func_175685_c(pos.func_177972_a(facing.func_176734_d()), (Block)this, false);
    }

    protected void playClickSound(@Nullable EntityPlayer player, World worldIn, BlockPos pos) {
        worldIn.func_184133_a(player, pos, SoundEvents.field_187839_fV, SoundCategory.BLOCKS, 0.3f, 0.6f);
    }

    protected void playReleaseSound(World worldIn, BlockPos pos) {
        worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187837_fU, SoundCategory.BLOCKS, 0.3f, 0.5f);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)BlockButton.field_176584_b)).booleanValue()) {
            this.notifyNeighbors(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)FACING));
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)BlockButton.field_176584_b) != false ? 15 : 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!((Boolean)blockState.func_177229_b((IProperty)BlockButton.field_176584_b)).booleanValue()) {
            return 0;
        }
        return blockState.func_177229_b((IProperty)FACING) == side ? 15 : 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        EnumFacing enumfacing = (EnumFacing)stateIn.func_177229_b((IProperty)FACING);
        boolean pulled = (Boolean)stateIn.func_177229_b((IProperty)BlockButton.field_176584_b);
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + 0.7;
        double z = (double)pos.func_177952_p() + 0.5;
        if (enumfacing.func_176740_k().func_176722_c()) {
            EnumFacing enumfacing1 = enumfacing.func_176734_d();
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + 0.27 * (double)enumfacing1.func_82601_c() * (pulled ? 0.0 : 1.0), y + 0.25 + (pulled ? -0.125 : 0.0), z + 0.27 * (double)enumfacing1.func_82599_e() * (pulled ? 0.0 : 1.0), 0.0, 0.0, 0.0, new int[0]);
            worldIn.func_175688_a(EnumParticleTypes.FLAME, x + 0.27 * (double)enumfacing1.func_82601_c() * (pulled ? 0.0 : 1.0), y + 0.25 + (pulled ? -0.125 : 0.0), z + 0.27 * (double)enumfacing1.func_82599_e() * (pulled ? 0.0 : 1.0), 0.0, 0.0, 0.0, new int[0]);
        } else {
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y + 0.33 + (pulled ? -0.125 : 0.0), z + (pulled ? -0.35 : 0.0), 0.0, 0.0, 0.0, new int[0]);
            worldIn.func_175688_a(EnumParticleTypes.FLAME, x, y + 0.33 + (pulled ? -0.125 : 0.0), z + (pulled ? -0.35 : 0.0), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K && ((Boolean)state.func_177229_b((IProperty)BlockButton.field_176584_b)).booleanValue()) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)BlockButton.field_176584_b, (Comparable)Boolean.valueOf(false)));
            this.notifyNeighbors(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)FACING));
            this.playReleaseSound(worldIn, pos);
            worldIn.func_175704_b(pos, pos);
        }
    }
}

