/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.blocks;

import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rustic.common.blocks.BlockLattice;
import rustic.common.blocks.BlockRopeBase;
import rustic.core.Rustic;

public class BlockChain
extends BlockRopeBase {
    public BlockChain() {
        this("chain");
    }

    public BlockChain(String name) {
        this(Material.field_151573_f, name, true);
    }

    public BlockChain(Material mat, String name, boolean register) {
        super(mat, name, register);
        this.func_149711_c(1.0f);
        this.func_149647_a(Rustic.decorTab);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AXIS, (Comparable)EnumFacing.Axis.Y));
    }

    @Override
    public boolean isSideSupported(World world, BlockPos pos, IBlockState state, EnumFacing facing) {
        if (facing == EnumFacing.DOWN) {
            return false;
        }
        IBlockState otherState = world.func_180495_p(pos.func_177972_a(facing));
        if (otherState.func_177230_c() == state.func_177230_c() && (state.func_177229_b((IProperty)AXIS) == EnumFacing.Axis.Y && facing.func_176740_k() == EnumFacing.Axis.Y || otherState.func_177229_b((IProperty)AXIS) == state.func_177229_b((IProperty)AXIS))) {
            return true;
        }
        if (otherState.func_177230_c() instanceof BlockLattice) {
            return true;
        }
        BlockFaceShape faceShape = otherState.func_193401_d((IBlockAccess)world, pos.func_177972_a(facing), facing.func_176734_d());
        return faceShape == BlockFaceShape.SOLID || faceShape == BlockFaceShape.CENTER || faceShape == BlockFaceShape.CENTER_BIG || faceShape == BlockFaceShape.CENTER_SMALL;
    }

    @Override
    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        BlockPos otherPos = pos.func_177972_a(side.func_176734_d());
        IBlockState otherState = world.func_180495_p(otherPos);
        if (side == EnumFacing.UP) {
            return this.func_176198_a(world, pos, EnumFacing.DOWN);
        }
        if (otherState.func_177230_c() == this && otherState.func_177229_b((IProperty)AXIS) == side.func_176740_k()) {
            return true;
        }
        if (otherState.func_177230_c() instanceof BlockLattice) {
            return true;
        }
        BlockFaceShape faceShape = otherState.func_193401_d((IBlockAccess)world, otherPos, side);
        return faceShape == BlockFaceShape.SOLID || faceShape == BlockFaceShape.CENTER || faceShape == BlockFaceShape.CENTER_BIG || faceShape == BlockFaceShape.CENTER_SMALL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        if (state.func_177229_b((IProperty)AXIS) == side.func_176740_k()) {
            return BlockFaceShape.CENTER_SMALL;
        }
        return BlockFaceShape.UNDEFINED;
    }
}

