/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rustic.common.blocks.BlockBase;
import rustic.common.blocks.BlockRopeBase;
import rustic.common.blocks.IColoredBlock;
import rustic.common.blocks.crops.BlockGrapeLeaves;
import rustic.common.blocks.properties.UnlistedPropertyBool;
import rustic.core.ClientProxy;

public class BlockLattice
extends BlockBase
implements IColoredBlock {
    public static final AxisAlignedBB BASE_AABB = new AxisAlignedBB(0.375, 0.375, 0.375, 0.625, 0.625, 0.625);
    public static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.4375, 0.4375, 0.4375, 0.5625, 0.5625, 0.0);
    public static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.5625, 0.4375, 0.4375, 1.0, 0.5625, 0.5625);
    public static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.4375, 0.4375, 1.0, 0.5625, 0.5625, 0.5625);
    public static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.4375, 0.4375, 0.4375, 0.5625, 0.5625);
    public static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.4375, 0.5625, 0.4375, 0.5625, 1.0, 0.5625);
    public static final AxisAlignedBB DOWN_AABB = new AxisAlignedBB(0.4375, 0.0, 0.4375, 0.5625, 0.4375, 0.5625);
    public static final UnlistedPropertyBool[] CONNECTIONS = new UnlistedPropertyBool[]{new UnlistedPropertyBool("down"), new UnlistedPropertyBool("up"), new UnlistedPropertyBool("north"), new UnlistedPropertyBool("south"), new UnlistedPropertyBool("west"), new UnlistedPropertyBool("east")};
    public static final PropertyBool LEAVES = PropertyBool.func_177716_a((String)"leaves");

    public BlockLattice(Material mat, String name) {
        this(mat, name, true);
    }

    public BlockLattice(Material mat, String name, boolean register) {
        super(mat, name, register);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        IExtendedBlockState extendedState = (IExtendedBlockState)this.getExtendedState(state, (IBlockAccess)worldIn, pos);
        BlockLattice.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BASE_AABB);
        if (((Boolean)extendedState.getValue((IUnlistedProperty)CONNECTIONS[0])).booleanValue()) {
            BlockLattice.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)DOWN_AABB);
        }
        if (((Boolean)extendedState.getValue((IUnlistedProperty)CONNECTIONS[1])).booleanValue()) {
            BlockLattice.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)UP_AABB);
        }
        if (((Boolean)extendedState.getValue((IUnlistedProperty)CONNECTIONS[2])).booleanValue()) {
            BlockLattice.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_AABB);
        }
        if (((Boolean)extendedState.getValue((IUnlistedProperty)CONNECTIONS[3])).booleanValue()) {
            BlockLattice.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_AABB);
        }
        if (((Boolean)extendedState.getValue((IUnlistedProperty)CONNECTIONS[4])).booleanValue()) {
            BlockLattice.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_AABB);
        }
        if (((Boolean)extendedState.getValue((IUnlistedProperty)CONNECTIONS[5])).booleanValue()) {
            BlockLattice.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_AABB);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        double x1 = 0.375;
        double y1 = 0.375;
        double z1 = 0.375;
        double x2 = 0.625;
        double y2 = 0.625;
        double z2 = 0.625;
        IExtendedBlockState extendedState = (IExtendedBlockState)this.getExtendedState(state, source, pos);
        if (((Boolean)extendedState.getValue((IUnlistedProperty)CONNECTIONS[0])).booleanValue()) {
            y1 = 0.0;
        }
        if (((Boolean)extendedState.getValue((IUnlistedProperty)CONNECTIONS[1])).booleanValue()) {
            y2 = 1.0;
        }
        if (((Boolean)extendedState.getValue((IUnlistedProperty)CONNECTIONS[2])).booleanValue()) {
            z1 = 0.0;
        }
        if (((Boolean)extendedState.getValue((IUnlistedProperty)CONNECTIONS[3])).booleanValue()) {
            z2 = 1.0;
        }
        if (((Boolean)extendedState.getValue((IUnlistedProperty)CONNECTIONS[4])).booleanValue()) {
            x1 = 0.0;
        }
        if (((Boolean)extendedState.getValue((IUnlistedProperty)CONNECTIONS[5])).booleanValue()) {
            x2 = 1.0;
        }
        return new AxisAlignedBB(x1, y1, z1, x2, y2, z2);
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedState = (IExtendedBlockState)state;
        for (int i = 0; i < CONNECTIONS.length; ++i) {
            boolean connected = this.canConnectTo(world, pos, EnumFacing.func_82600_a((int)i));
            extendedState = extendedState.withProperty((IUnlistedProperty)CONNECTIONS[i], (Object)connected);
        }
        return extendedState;
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return this.canConnectTo(world, pos.func_177972_a(facing), facing.func_176734_d());
    }

    private boolean canConnectTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        BlockPos deltaPos = pos.func_177972_a(facing);
        IBlockState state = world.func_180495_p(deltaPos);
        Block block = state.func_177230_c();
        BlockFaceShape blockfaceshape = state.func_193401_d(world, deltaPos, facing.func_176734_d());
        if (block instanceof BlockLattice) {
            return true;
        }
        if (block instanceof BlockGrapeLeaves) {
            return state.func_177229_b(BlockGrapeLeaves.AXIS) == facing.func_176740_k();
        }
        if (block instanceof BlockRopeBase) {
            return state.func_177229_b(BlockRopeBase.AXIS) == facing.func_176740_k();
        }
        return blockfaceshape != BlockFaceShape.BOWL && blockfaceshape != BlockFaceShape.UNDEFINED && blockfaceshape != BlockFaceShape.MIDDLE_POLE && blockfaceshape != BlockFaceShape.MIDDLE_POLE_THIN && blockfaceshape != BlockFaceShape.MIDDLE_POLE_THICK && !Block.func_193382_c((Block)block);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (Block.func_149634_a((Item)heldItem.func_77973_b()) != null && Block.func_149634_a((Item)heldItem.func_77973_b()) instanceof BlockLeaves) {
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)LEAVES, (Comparable)Boolean.valueOf(true)), 3);
            playerIn.func_184586_b(hand).func_190918_g(1);
            return true;
        }
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LEAVES) != false ? 1 : 0;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P();
        iblockstate = meta == 0 ? iblockstate.func_177226_a((IProperty)LEAVES, (Comparable)Boolean.valueOf(false)) : iblockstate.func_177226_a((IProperty)LEAVES, (Comparable)Boolean.valueOf(true));
        return iblockstate;
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{LEAVES}, new IUnlistedProperty[]{CONNECTIONS[0], CONNECTIONS[1], CONNECTIONS[2], CONNECTIONS[3], CONNECTIONS[4], CONNECTIONS[5]});
    }

    @Override
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName().toString() + "_item", "inventory"));
        ClientProxy.addColoredBlock(this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
                if (worldIn != null && pos != null && tintIndex == 1) {
                    return BiomeColorHelper.func_180287_b((IBlockAccess)worldIn, (BlockPos)pos);
                }
                return ColorizerFoliage.func_77468_c();
            }
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                if (!(stack.func_77973_b() instanceof ItemBlock)) {
                    return 0xFFFFFF;
                }
                IBlockState state = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
                IBlockColor blockColor = ((IColoredBlock)state.func_177230_c()).getBlockColor();
                return blockColor == null ? 0xFFFFFF : blockColor.func_186720_a(state, null, null, tintIndex);
            }
        };
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return BlockFaceShape.CENTER_SMALL;
    }
}

