/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.crafting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import rustic.common.Config;
import rustic.common.blocks.BlockLogRustic;
import rustic.common.blocks.BlockPlanksRustic;
import rustic.common.blocks.BlockSaplingRustic;
import rustic.common.blocks.ModBlocks;
import rustic.common.blocks.crops.Herbs;
import rustic.common.blocks.fluids.ModFluids;
import rustic.common.crafting.AdvancedCondenserRecipe;
import rustic.common.crafting.BasicCondenserRecipe;
import rustic.common.crafting.BrewingBarrelRecipe;
import rustic.common.crafting.CrushingTubRecipe;
import rustic.common.crafting.EvaporatingBasinRecipe;
import rustic.common.crafting.IBrewingBarrelRecipe;
import rustic.common.crafting.ICondenserRecipe;
import rustic.common.crafting.ICrushingTubRecipe;
import rustic.common.crafting.IEvaporatingBasinRecipe;
import rustic.common.crafting.RecipeCabinet;
import rustic.common.crafting.RecipeNonIngredientReturn;
import rustic.common.crafting.RecipeOliveOil;
import rustic.common.items.ModItems;
import rustic.common.potions.PotionsRustic;
import rustic.compat.dynamictrees.DynamicTreesCompat;

public class Recipes {
    public static List<ICrushingTubRecipe> crushingTubRecipes = new ArrayList<ICrushingTubRecipe>();
    public static List<IEvaporatingBasinRecipe> evaporatingRecipes = new ArrayList<IEvaporatingBasinRecipe>();
    public static HashMap<Fluid, IEvaporatingBasinRecipe> evaporatingRecipesMap = new HashMap();
    public static List<ICondenserRecipe> condenserRecipes = new ArrayList<ICondenserRecipe>();
    public static List<IBrewingBarrelRecipe> brewingRecipes = new ArrayList<IBrewingBarrelRecipe>();

    public static void initOres() {
        Recipes.addOreDictEntries();
    }

    public static void init() {
        Recipes.addCraftingRecipes();
        Recipes.addSmeltingRecipes();
        Recipes.addFuels();
        Recipes.addCrushingTubRecipes();
        Recipes.addEvaporatingRecipes();
        Recipes.addCondenserRecipes();
        Recipes.addBrewingRecipes();
    }

    public static void injectEvaporatingRecipes() {
        for (IEvaporatingBasinRecipe recipe : evaporatingRecipes) {
            evaporatingRecipesMap.putIfAbsent(recipe.getFluid(), recipe);
        }
    }

    public static void add(ICrushingTubRecipe recipe) {
        crushingTubRecipes.add(recipe);
    }

    public static void add(IEvaporatingBasinRecipe recipe) {
        evaporatingRecipesMap.put(recipe.getFluid(), recipe);
    }

    public static void add(ICondenserRecipe recipe) {
        condenserRecipes.add(recipe);
    }

    public static void add(IBrewingBarrelRecipe recipe) {
        brewingRecipes.add(recipe);
    }

    public static Collection<ICrushingTubRecipe> getCrushingRecipes() {
        return Collections.unmodifiableList(crushingTubRecipes);
    }

    public static Collection<IEvaporatingBasinRecipe> getEvaporatingRecipes() {
        return Collections.unmodifiableCollection(evaporatingRecipesMap.values());
    }

    public static Collection<ICondenserRecipe> getCondenserRecipe() {
        return Collections.unmodifiableList(condenserRecipes);
    }

    public static Collection<IBrewingBarrelRecipe> getBrewingRecipes() {
        return Collections.unmodifiableList(brewingRecipes);
    }

    public static int removeCrushingRecipe(ItemStack input) {
        int removed = 0;
        Iterator<ICrushingTubRecipe> it = crushingTubRecipes.iterator();
        while (it.hasNext()) {
            ICrushingTubRecipe r = it.next();
            if (r == null || !r.getInput().func_77969_a(input)) continue;
            it.remove();
            ++removed;
        }
        return removed;
    }

    public static int removeCrushingRecipe(FluidStack output, ItemStack input) {
        int removed = 0;
        Iterator<ICrushingTubRecipe> it = crushingTubRecipes.iterator();
        while (it.hasNext()) {
            ICrushingTubRecipe r = it.next();
            if (r == null || r.getResult() == null || !r.getResult().isFluidEqual(output) || input != null && !r.getInput().func_77969_a(input)) continue;
            it.remove();
            ++removed;
        }
        return removed;
    }

    public static int removeEvaporatingRecipe(ItemStack output) {
        int removed = 0;
        Iterator<Map.Entry<Fluid, IEvaporatingBasinRecipe>> it = evaporatingRecipesMap.entrySet().iterator();
        while (it.hasNext()) {
            IEvaporatingBasinRecipe r = it.next().getValue();
            if (!output.func_77969_a(r.getOutput())) continue;
            ++removed;
            it.remove();
        }
        return removed;
    }

    public static boolean removeEvaporatingRecipe(FluidStack input) {
        return evaporatingRecipesMap.remove(input.getFluid()) != null;
    }

    public static int removeCondenserRecipe(ItemStack output) {
        int removed = 0;
        Iterator<ICondenserRecipe> it = condenserRecipes.iterator();
        while (it.hasNext()) {
            ICondenserRecipe r = it.next();
            if (r == null || r.getResult() == null || !ItemStack.func_77989_b((ItemStack)r.getResult(), (ItemStack)output)) continue;
            it.remove();
            ++removed;
        }
        return removed;
    }

    public static void postInit() {
        Recipes.addSilverCraftingRecipes();
    }

    private static void addSmeltingRecipes() {
        GameRegistry.addSmelting((ItemStack)new ItemStack((Item)ModItems.HONEYCOMB), (ItemStack)new ItemStack((Item)ModItems.BEESWAX), (float)0.3f);
        for (int i = 0; i < BlockPlanksRustic.EnumType.values().length; ++i) {
            IBlockState state = ModBlocks.LOG.func_176223_P().func_177226_a(BlockLogRustic.VARIANT, (Comparable)((Object)BlockPlanksRustic.EnumType.byMetadata(i)));
            int meta = ModBlocks.LOG.func_176201_c(state);
            GameRegistry.addSmelting((ItemStack)new ItemStack((Block)ModBlocks.LOG, 1, meta), (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.15f);
        }
        GameRegistry.addSmelting((ItemStack)new ItemStack((Item)ModItems.IRON_DUST_TINY), (ItemStack)new ItemStack(Items.field_191525_da), (float)0.15f);
        if (Config.FLESH_SMELTING) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(Items.field_151078_bh), (ItemStack)new ItemStack((Item)ModItems.TALLOW), (float)0.3f);
        }
    }

    private static void addFuels() {
        IFuelHandler rusticFuels = new IFuelHandler(){

            public int getBurnTime(ItemStack fuel) {
                Item item = fuel.func_77973_b();
                if (item == Item.func_150898_a((Block)ModBlocks.SAPLING) || item == Item.func_150898_a((Block)ModBlocks.APPLE_SAPLING)) {
                    return 100;
                }
                if (item == Item.func_150898_a((Block)ModBlocks.WILDBERRY_BUSH)) {
                    return 150;
                }
                return 0;
            }
        };
        GameRegistry.registerFuelHandler((IFuelHandler)rusticFuels);
    }

    private static void addOreDictEntries() {
        int i;
        OreDictionary.registerOre((String)"cropOlive", (ItemStack)new ItemStack((Item)ModItems.OLIVES));
        OreDictionary.registerOre((String)"cropIronberry", (ItemStack)new ItemStack((Item)ModItems.IRONBERRIES));
        OreDictionary.registerOre((String)"listAllfruit", (ItemStack)new ItemStack((Item)ModItems.OLIVES));
        OreDictionary.registerOre((String)"listAllfruit", (ItemStack)new ItemStack((Item)ModItems.IRONBERRIES));
        OreDictionary.registerOre((String)"listAllfruit", (ItemStack)new ItemStack((Item)ModItems.GRAPES));
        OreDictionary.registerOre((String)"listAllberry", (ItemStack)new ItemStack((Item)ModItems.GRAPES));
        OreDictionary.registerOre((String)"listAllberry", (ItemStack)new ItemStack((Item)ModItems.IRONBERRIES));
        OreDictionary.registerOre((String)"listAllberry", (ItemStack)new ItemStack((Item)ModItems.WILDBERRIES));
        OreDictionary.registerOre((String)"listAllfruit", (ItemStack)new ItemStack((Item)ModItems.WILDBERRIES));
        OreDictionary.registerOre((String)"cropWildberry", (ItemStack)new ItemStack((Item)ModItems.WILDBERRIES));
        OreDictionary.registerOre((String)"cropGrape", (ItemStack)new ItemStack((Item)ModItems.GRAPES));
        OreDictionary.registerOre((String)"cropChilipepper", (ItemStack)new ItemStack((Item)ModItems.CHILI_PEPPER));
        OreDictionary.registerOre((String)"listAllpepper", (ItemStack)new ItemStack((Item)ModItems.CHILI_PEPPER));
        OreDictionary.registerOre((String)"cropTomato", (ItemStack)new ItemStack((Item)ModItems.TOMATO));
        OreDictionary.registerOre((String)"listAllveggie", (ItemStack)new ItemStack((Item)ModItems.TOMATO));
        for (i = 0; i < BlockPlanksRustic.EnumType.values().length; ++i) {
            IBlockState state = ModBlocks.LOG.func_176223_P().func_177226_a(BlockLogRustic.VARIANT, (Comparable)((Object)BlockPlanksRustic.EnumType.byMetadata(i)));
            int meta = ModBlocks.LOG.func_176201_c(state);
            OreDictionary.registerOre((String)"treeWood", (ItemStack)new ItemStack((Block)ModBlocks.LOG, 1, meta));
            OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack((Block)ModBlocks.LOG, 1, meta));
            state = ModBlocks.SAPLING.func_176223_P().func_177226_a(BlockSaplingRustic.VARIANT, (Comparable)((Object)BlockPlanksRustic.EnumType.byMetadata(i)));
            meta = ModBlocks.SAPLING.func_176201_c(state);
            OreDictionary.registerOre((String)"treeSapling", (ItemStack)new ItemStack((Block)ModBlocks.SAPLING, 1, meta));
            state = ModBlocks.PLANKS.func_176223_P().func_177226_a(BlockPlanksRustic.VARIANT, (Comparable)((Object)BlockPlanksRustic.EnumType.byMetadata(i)));
            meta = ModBlocks.PLANKS.func_176201_c(state);
            OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack((Block)ModBlocks.PLANKS, 1, meta));
        }
        if (Config.ENABLE_PAINTED_WOOD) {
            OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack((Block)ModBlocks.PAINTED_WOOD_BLACK));
            OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack((Block)ModBlocks.PAINTED_WOOD_BLUE));
            OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack((Block)ModBlocks.PAINTED_WOOD_BROWN));
            OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack((Block)ModBlocks.PAINTED_WOOD_CYAN));
            OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack((Block)ModBlocks.PAINTED_WOOD_GRAY));
            OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack((Block)ModBlocks.PAINTED_WOOD_GREEN));
            OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack((Block)ModBlocks.PAINTED_WOOD_LIGHT_BLUE));
            OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack((Block)ModBlocks.PAINTED_WOOD_LIME));
            OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack((Block)ModBlocks.PAINTED_WOOD_MAGENTA));
            OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack((Block)ModBlocks.PAINTED_WOOD_ORANGE));
            OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack((Block)ModBlocks.PAINTED_WOOD_PINK));
            OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack((Block)ModBlocks.PAINTED_WOOD_PURPLE));
            OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack((Block)ModBlocks.PAINTED_WOOD_RED));
            OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack((Block)ModBlocks.PAINTED_WOOD_SILVER));
            OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack((Block)ModBlocks.PAINTED_WOOD_WHITE));
            OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack((Block)ModBlocks.PAINTED_WOOD_YELLOW));
        }
        OreDictionary.registerOre((String)"slabWood", (ItemStack)new ItemStack((Item)ModBlocks.OLIVE_SLAB_ITEM));
        OreDictionary.registerOre((String)"slabWood", (ItemStack)new ItemStack((Item)ModBlocks.IRONWOOD_SLAB_ITEM));
        OreDictionary.registerOre((String)"stairWood", (ItemStack)new ItemStack((Block)ModBlocks.OLIVE_STAIRS));
        OreDictionary.registerOre((String)"stairWood", (ItemStack)new ItemStack((Block)ModBlocks.IRONWOOD_STAIRS));
        OreDictionary.registerOre((String)"treeSapling", (ItemStack)new ItemStack((Block)ModBlocks.APPLE_SAPLING));
        OreDictionary.registerOre((String)"treeLeaves", (ItemStack)new ItemStack((Block)ModBlocks.APPLE_LEAVES, 1, 0));
        for (i = 0; i < 2; ++i) {
            OreDictionary.registerOre((String)"treeLeaves", (ItemStack)new ItemStack((Block)ModBlocks.LEAVES, 1, i));
        }
        if (Config.ENABLE_SLATE) {
            OreDictionary.registerOre((String)"stoneSlate", (ItemStack)new ItemStack((Block)ModBlocks.SLATE));
            OreDictionary.registerOre((String)"slate", (ItemStack)new ItemStack((Block)ModBlocks.SLATE));
            OreDictionary.registerOre((String)"slate", (ItemStack)new ItemStack((Block)ModBlocks.SLATE_BRICK));
            OreDictionary.registerOre((String)"slate", (ItemStack)new ItemStack((Block)ModBlocks.SLATE_TILE));
            if (Config.ENABLE_PILLARS) {
                OreDictionary.registerOre((String)"slate", (ItemStack)new ItemStack((Block)ModBlocks.SLATE_PILLAR));
            }
            OreDictionary.registerOre((String)"slate", (ItemStack)new ItemStack((Block)ModBlocks.SLATE_ROOF));
            OreDictionary.registerOre((String)"slate", (ItemStack)new ItemStack((Block)ModBlocks.SLATE_CHISELED));
        }
        OreDictionary.registerOre((String)"wax", (ItemStack)new ItemStack((Item)ModItems.BEESWAX));
        OreDictionary.registerOre((String)"wax", (ItemStack)new ItemStack((Item)ModItems.TALLOW));
        OreDictionary.registerOre((String)"tallow", (ItemStack)new ItemStack((Item)ModItems.BEESWAX));
        OreDictionary.registerOre((String)"tallow", (ItemStack)new ItemStack((Item)ModItems.TALLOW));
        OreDictionary.registerOre((String)"materialWaxcomb", (ItemStack)new ItemStack((Item)ModItems.HONEYCOMB));
        OreDictionary.registerOre((String)"materialHoneycomb", (ItemStack)new ItemStack((Item)ModItems.HONEYCOMB));
        OreDictionary.registerOre((String)"dustTinyIron", (ItemStack)new ItemStack((Item)ModItems.IRON_DUST_TINY));
        OreDictionary.registerOre((String)"dyeRed", (ItemStack)new ItemStack((Item)ModItems.WILDBERRIES));
        OreDictionary.registerOre((String)"dyePurple", (ItemStack)new ItemStack((Item)ModItems.GRAPES));
        OreDictionary.registerOre((String)"dyeLightGray", (ItemStack)new ItemStack((Item)ModItems.IRONBERRIES));
    }

    private static void addCraftingRecipes() {
        if (Config.ENABLE_PILLARS) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "pillar_stone"), null, (ItemStack)new ItemStack((Block)ModBlocks.STONE_PILLAR, 6), (Object[])new Object[]{"SS ", "SS ", "SS ", Character.valueOf('S'), new ItemStack(Blocks.field_150348_b, 1, 0)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "pillar_andesite"), null, (ItemStack)new ItemStack((Block)ModBlocks.ANDESITE_PILLAR, 6), (Object[])new Object[]{"SS ", "SS ", "SS ", Character.valueOf('S'), new ItemStack(Blocks.field_150348_b, 1, 5)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "pillar_diorite"), null, (ItemStack)new ItemStack((Block)ModBlocks.DIORITE_PILLAR, 6), (Object[])new Object[]{"SS ", "SS ", "SS ", Character.valueOf('S'), new ItemStack(Blocks.field_150348_b, 1, 3)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "pillar_granite"), null, (ItemStack)new ItemStack((Block)ModBlocks.GRANITE_PILLAR, 6), (Object[])new Object[]{"SS ", "SS ", "SS ", Character.valueOf('S'), new ItemStack(Blocks.field_150348_b, 1, 1)});
            if (Config.ENABLE_SLATE) {
                GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "pillar_slate"), null, (ItemStack)new ItemStack((Block)ModBlocks.SLATE_PILLAR, 6), (Object[])new Object[]{"SS", "SS", "SS", Character.valueOf('S'), new ItemStack((Block)ModBlocks.SLATE)});
            }
        }
        if (Config.ENABLE_SLATE) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "slate_roof"), null, (ItemStack)new ItemStack((Block)ModBlocks.SLATE_ROOF, 4), (Object[])new Object[]{"SS", "SS", Character.valueOf('S'), new ItemStack((Block)ModBlocks.SLATE)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "slate_roof_stairs"), null, (ItemStack)new ItemStack((Block)ModBlocks.SLATE_ROOF_STAIRS, 4), (Object[])new Object[]{"S  ", "SS ", "SSS", Character.valueOf('S'), new ItemStack((Block)ModBlocks.SLATE_ROOF)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "slate_roof_slab"), null, (ItemStack)new ItemStack((Item)ModBlocks.SLATE_ROOF_SLAB_ITEM, 6), (Object[])new Object[]{"SSS", Character.valueOf('S'), new ItemStack((Block)ModBlocks.SLATE_ROOF)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "slate_brick_stairs"), null, (ItemStack)new ItemStack((Block)ModBlocks.SLATE_BRICK_STAIRS, 4), (Object[])new Object[]{"S  ", "SS ", "SSS", Character.valueOf('S'), new ItemStack((Block)ModBlocks.SLATE_BRICK)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "slate_brick_slab"), null, (ItemStack)new ItemStack((Item)ModBlocks.SLATE_BRICK_SLAB_ITEM, 6), (Object[])new Object[]{"SSS", Character.valueOf('S'), new ItemStack((Block)ModBlocks.SLATE_BRICK)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "slate_tile"), null, (ItemStack)new ItemStack((Block)ModBlocks.SLATE_TILE), (Object[])new Object[]{"S", Character.valueOf('S'), new ItemStack((Block)ModBlocks.SLATE)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "slate_tile_1"), null, (ItemStack)new ItemStack((Block)ModBlocks.SLATE_TILE), (Object[])new Object[]{"S", Character.valueOf('S'), new ItemStack((Block)ModBlocks.SLATE_BRICK)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "slate_brick"), null, (ItemStack)new ItemStack((Block)ModBlocks.SLATE_BRICK, 4), (Object[])new Object[]{"SS", "SS", Character.valueOf('S'), new ItemStack((Block)ModBlocks.SLATE_TILE)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "slate_chiseled"), null, (ItemStack)new ItemStack((Block)ModBlocks.SLATE_CHISELED, 4), (Object[])new Object[]{"SS", "SS", Character.valueOf('S'), new ItemStack((Block)ModBlocks.SLATE_BRICK)});
        }
        if (Config.ENABLE_CLAY_WALLS) {
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.CLAY_WALL, 8), new Object[]{" P ", "PCP", " P ", Character.valueOf('P'), "plankWood", Character.valueOf('C'), Blocks.field_150435_aG}).setRegistryName(new ResourceLocation("rustic", "clay_wall")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.CLAY_WALL_CROSS), new Object[]{"P P", " C ", "P P", Character.valueOf('P'), "plankWood", Character.valueOf('C'), ModBlocks.CLAY_WALL}).setRegistryName(new ResourceLocation("rustic", "clay_wall_cross")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.CLAY_WALL_DIAG), new Object[]{"P  ", " C ", "  P", Character.valueOf('P'), "plankWood", Character.valueOf('C'), ModBlocks.CLAY_WALL}).setRegistryName(new ResourceLocation("rustic", "clay_wall_diag")));
        }
        if (Config.ENABLE_CHAIRS) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "acacia_chair"), (ResourceLocation)new ResourceLocation("rustic", "chair"), (ItemStack)new ItemStack((Block)ModBlocks.CHAIR_ACACIA, 4), (Object[])new Object[]{"P  ", "PPP", "S S", Character.valueOf('P'), new ItemStack(Blocks.field_150344_f, 1, 4), Character.valueOf('S'), new ItemStack(Items.field_151055_y)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "big_oak_chair"), (ResourceLocation)new ResourceLocation("rustic", "chair"), (ItemStack)new ItemStack((Block)ModBlocks.CHAIR_BIG_OAK, 4), (Object[])new Object[]{"P  ", "PPP", "S S", Character.valueOf('P'), new ItemStack(Blocks.field_150344_f, 1, 5), Character.valueOf('S'), new ItemStack(Items.field_151055_y)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "birch_chair"), (ResourceLocation)new ResourceLocation("rustic", "chair"), (ItemStack)new ItemStack((Block)ModBlocks.CHAIR_BIRCH, 4), (Object[])new Object[]{"P  ", "PPP", "S S", Character.valueOf('P'), new ItemStack(Blocks.field_150344_f, 1, 2), Character.valueOf('S'), new ItemStack(Items.field_151055_y)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "jungle_chair"), (ResourceLocation)new ResourceLocation("rustic", "chair"), (ItemStack)new ItemStack((Block)ModBlocks.CHAIR_JUNGLE, 4), (Object[])new Object[]{"P  ", "PPP", "S S", Character.valueOf('P'), new ItemStack(Blocks.field_150344_f, 1, 3), Character.valueOf('S'), new ItemStack(Items.field_151055_y)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "oak_chair"), (ResourceLocation)new ResourceLocation("rustic", "chair"), (ItemStack)new ItemStack((Block)ModBlocks.CHAIR_OAK, 4), (Object[])new Object[]{"P  ", "PPP", "S S", Character.valueOf('P'), new ItemStack(Blocks.field_150344_f, 1, 0), Character.valueOf('S'), new ItemStack(Items.field_151055_y)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "spruce_chair"), (ResourceLocation)new ResourceLocation("rustic", "chair"), (ItemStack)new ItemStack((Block)ModBlocks.CHAIR_SPRUCE, 4), (Object[])new Object[]{"P  ", "PPP", "S S", Character.valueOf('P'), new ItemStack(Blocks.field_150344_f, 1, 1), Character.valueOf('S'), new ItemStack(Items.field_151055_y)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "olive_chair"), (ResourceLocation)new ResourceLocation("rustic", "chair"), (ItemStack)new ItemStack((Block)ModBlocks.CHAIR_OLIVE, 4), (Object[])new Object[]{"p  ", "ppp", "s s", Character.valueOf('p'), new ItemStack((Block)ModBlocks.PLANKS, 1, BlockPlanksRustic.EnumType.OLIVE.getMetadata()), Character.valueOf('s'), new ItemStack(Items.field_151055_y)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "ironwood_chair"), (ResourceLocation)new ResourceLocation("rustic", "chair"), (ItemStack)new ItemStack((Block)ModBlocks.CHAIR_IRONWOOD, 4), (Object[])new Object[]{"p  ", "ppp", "s s", Character.valueOf('p'), new ItemStack((Block)ModBlocks.PLANKS, 1, BlockPlanksRustic.EnumType.IRONWOOD.getMetadata()), Character.valueOf('s'), new ItemStack(Items.field_151055_y)});
        }
        if (Config.ENABLE_TABLES) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "acacia_table"), (ResourceLocation)new ResourceLocation("rustic", "table"), (ItemStack)new ItemStack((Block)ModBlocks.TABLE_ACACIA, 2), (Object[])new Object[]{"PPP", "S S", Character.valueOf('P'), new ItemStack(Blocks.field_150344_f, 1, 4), Character.valueOf('S'), new ItemStack(Items.field_151055_y)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "big_oak_table"), (ResourceLocation)new ResourceLocation("rustic", "table"), (ItemStack)new ItemStack((Block)ModBlocks.TABLE_BIG_OAK, 2), (Object[])new Object[]{"PPP", "S S", Character.valueOf('P'), new ItemStack(Blocks.field_150344_f, 1, 5), Character.valueOf('S'), new ItemStack(Items.field_151055_y)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "birch_table"), (ResourceLocation)new ResourceLocation("rustic", "table"), (ItemStack)new ItemStack((Block)ModBlocks.TABLE_BIRCH, 2), (Object[])new Object[]{"PPP", "S S", Character.valueOf('P'), new ItemStack(Blocks.field_150344_f, 1, 2), Character.valueOf('S'), new ItemStack(Items.field_151055_y)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "jungle_table"), (ResourceLocation)new ResourceLocation("rustic", "table"), (ItemStack)new ItemStack((Block)ModBlocks.TABLE_JUNGLE, 2), (Object[])new Object[]{"PPP", "S S", Character.valueOf('P'), new ItemStack(Blocks.field_150344_f, 1, 3), Character.valueOf('S'), new ItemStack(Items.field_151055_y)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "oak_table"), (ResourceLocation)new ResourceLocation("rustic", "table"), (ItemStack)new ItemStack((Block)ModBlocks.TABLE_OAK, 2), (Object[])new Object[]{"PPP", "S S", Character.valueOf('P'), new ItemStack(Blocks.field_150344_f, 1, 0), Character.valueOf('S'), new ItemStack(Items.field_151055_y)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "spruce_table"), (ResourceLocation)new ResourceLocation("rustic", "table"), (ItemStack)new ItemStack((Block)ModBlocks.TABLE_SPRUCE, 2), (Object[])new Object[]{"PPP", "S S", Character.valueOf('P'), new ItemStack(Blocks.field_150344_f, 1, 1), Character.valueOf('S'), new ItemStack(Items.field_151055_y)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "olive_table"), (ResourceLocation)new ResourceLocation("rustic", "table"), (ItemStack)new ItemStack((Block)ModBlocks.TABLE_OLIVE, 2), (Object[])new Object[]{"ppp", "s s", Character.valueOf('p'), new ItemStack((Block)ModBlocks.PLANKS, 1, BlockPlanksRustic.EnumType.OLIVE.getMetadata()), Character.valueOf('s'), new ItemStack(Items.field_151055_y)});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "ironwood_table"), (ResourceLocation)new ResourceLocation("rustic", "table"), (ItemStack)new ItemStack((Block)ModBlocks.TABLE_IRONWOOD, 2), (Object[])new Object[]{"ppp", "s s", Character.valueOf('p'), new ItemStack((Block)ModBlocks.PLANKS, 1, BlockPlanksRustic.EnumType.IRONWOOD.getMetadata()), Character.valueOf('s'), new ItemStack(Items.field_151055_y)});
        }
        if (Config.ENABLE_LATTICE) {
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("rustic", "iron_lattice"), null, (ItemStack)new ItemStack((Block)ModBlocks.IRON_LATTICE, 16), (Object[])new Object[]{" I ", "III", " I ", Character.valueOf('I'), new ItemStack(Items.field_151042_j)});
        }
        if (Config.ENABLE_PAINTED_WOOD) {
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_WHITE, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyeWhite"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_white")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_ORANGE, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyeOrange"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_orange")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_MAGENTA, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyeMagenta"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_magenta")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_LIGHT_BLUE, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyeLightBlue"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_light_blue")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_YELLOW, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyeYellow"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_yellow")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_LIME, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyeLime"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_lime")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_PINK, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyePink"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_pink")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_GRAY, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyeGray"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_gray")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_SILVER, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyeLightGray"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_silver")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_CYAN, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyeCyan"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_cyan")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_PURPLE, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyePurple"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_purple")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_BLUE, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyeBlue"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_blue")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_BROWN, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyeBrown"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_brown")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_GREEN, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyeGreen"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_green")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_RED, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyeRed"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_red")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.PAINTED_WOOD_BLACK, 8), new Object[]{"PPP", "PDP", "PPP", Character.valueOf('P'), "plankWood", Character.valueOf('D'), "dyeBlack"}).setRegistryName(new ResourceLocation("rustic", "painted_wood_black")));
        }
        RecipeSorter.register((String)"rustic:shapeless_nonreturn", RecipeNonIngredientReturn.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        ItemStack aleWortBucket = FluidUtil.getFilledBucket((FluidStack)new FluidStack(ModFluids.ALE_WORT, 1000));
        GameRegistry.findRegistry(IRecipe.class).register(new RecipeNonIngredientReturn(null, aleWortBucket, new ItemStack(Items.field_151025_P), new ItemStack(Items.field_151102_aT), new ItemStack(Items.field_151131_as)).setRegistryName(new ResourceLocation("rustic", "ale_wort")));
        RecipeSorter.register((String)"rustic:cabinet_recipe", RecipeCabinet.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shapeless");
        GameRegistry.findRegistry(IRecipe.class).register(new RecipeCabinet().setRegistryName(new ResourceLocation("rustic", "cabinet")));
        if (Config.ENABLE_BOTTLE_EMPTYING) {
            GameRegistry.findRegistry(IRecipe.class).register(new RecipeNonIngredientReturn(null, new ItemStack(Items.field_151069_bo), new ItemStack((Item)ModItems.FLUID_BOTTLE)).setRegistryName(new ResourceLocation("rustic", "bottle_emptying")));
        }
        GameRegistry.findRegistry(IRecipe.class).register(new RecipeNonIngredientReturn(null, new ItemStack((Block)ModBlocks.LIQUID_BARREL), new ItemStack((Block)ModBlocks.LIQUID_BARREL)).setRegistryName(new ResourceLocation("rustic", "barrel_emptying")));
        if (Config.ENABLE_OLIVE_OILING) {
            RecipeSorter.register((String)"rustic:olive_oil", RecipeOliveOil.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
            GameRegistry.findRegistry(IRecipe.class).register(new RecipeOliveOil().setRegistryName(new ResourceLocation("rustic", "olive_oiling")));
        }
        if (Loader.isModLoaded((String)"dynamictrees")) {
            GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation("rustic", "oliveseed"), null, (ItemStack)new ItemStack(DynamicTreesCompat.getOliveSeed()), (Ingredient[])new Ingredient[]{Ingredient.func_193367_a((Item)ModItems.OLIVES)});
            GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation("rustic", "ironwoodseed"), null, (ItemStack)new ItemStack(DynamicTreesCompat.getIronwoodSeed()), (Ingredient[])new Ingredient[]{Ingredient.func_193367_a((Item)ModItems.IRONBERRIES)});
            DynamicTreesCompat.addRecipes();
        }
    }

    private static void addSilverCraftingRecipes() {
        if (Config.ENABLE_SILVER_DECOR && OreDictionary.doesOreNameExist((String)"ingotSilver")) {
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.CANDLE_SILVER, 4), new Object[]{"S", "W", "I", Character.valueOf('S'), new ItemStack(Items.field_151007_F), Character.valueOf('W'), "wax", Character.valueOf('I'), "ingotSilver"}).setRegistryName(new ResourceLocation("rustic", "candle_silver")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.CANDLE_LEVER_SILVER, 1), new Object[]{"C", "R", Character.valueOf('C'), new ItemStack((Block)ModBlocks.CANDLE_SILVER), Character.valueOf('R'), "dustRedstone"}).setRegistryName(new ResourceLocation("rustic", "candle_lever_silver")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.CHAIN_SILVER, 12), new Object[]{"I", "I", "I", Character.valueOf('I'), "ingotSilver"}).setRegistryName(new ResourceLocation("rustic", "chain_silver")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.CHANDELIER_SILVER, 2), new Object[]{" I ", "C C", "III", Character.valueOf('I'), "ingotSilver", Character.valueOf('C'), ModBlocks.CHAIN_SILVER}).setRegistryName(new ResourceLocation("rustic", "chandelier_silver")));
            GameRegistry.findRegistry(IRecipe.class).register(new ShapedOreRecipe(null, new ItemStack((Block)ModBlocks.SILVER_LANTERN, 4), new Object[]{"I", "C", "I", Character.valueOf('I'), "ingotSilver", Character.valueOf('C'), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151044_h, 1, 0), new ItemStack(Items.field_151044_h, 1, 1)})}).setRegistryName(new ResourceLocation("rustic", "silver_lantern")));
        }
    }

    private static void addCrushingTubRecipes() {
        crushingTubRecipes.add(new CrushingTubRecipe(new FluidStack(ModFluids.OLIVE_OIL, 250), new ItemStack((Item)ModItems.OLIVES)));
        crushingTubRecipes.add(new CrushingTubRecipe(new FluidStack(ModFluids.IRONBERRY_JUICE, 250), new ItemStack((Item)ModItems.IRONBERRIES)));
        crushingTubRecipes.add(new CrushingTubRecipe(new FluidStack(FluidRegistry.WATER, 250), new ItemStack(Items.field_151120_aE), new ItemStack(Items.field_151102_aT, 2)));
        crushingTubRecipes.add(new CrushingTubRecipe(new FluidStack(ModFluids.WILDBERRY_JUICE, 250), new ItemStack((Item)ModItems.WILDBERRIES)));
        crushingTubRecipes.add(new CrushingTubRecipe(new FluidStack(ModFluids.GRAPE_JUICE, 250), new ItemStack((Item)ModItems.GRAPES)));
        if (!Loader.isModLoaded((String)"dynamictrees")) {
            crushingTubRecipes.add(new CrushingTubRecipe(new FluidStack(ModFluids.APPLE_JUICE, 250), new ItemStack(Items.field_151034_e), new ItemStack((Block)ModBlocks.APPLE_SEEDS)));
        } else {
            crushingTubRecipes.add(new CrushingTubRecipe(new FluidStack(ModFluids.APPLE_JUICE, 250), new ItemStack(Items.field_151034_e), new ItemStack(DynamicTreesCompat.getAppleSeed())));
        }
        crushingTubRecipes.add(new CrushingTubRecipe(new FluidStack(ModFluids.HONEY, 250), new ItemStack((Item)ModItems.HONEYCOMB)));
    }

    private static void addEvaporatingRecipes() {
        evaporatingRecipesMap.put(ModFluids.IRONBERRY_JUICE, new EvaporatingBasinRecipe(new ItemStack((Item)ModItems.IRON_DUST_TINY, 1), new FluidStack(ModFluids.IRONBERRY_JUICE, 500)));
    }

    private static void addCondenserRecipes() {
        condenserRecipes.add(new BasicCondenserRecipe(new PotionEffect(MobEffects.field_76432_h, 1), new ItemStack((Block)Herbs.CHAMOMILE), new ItemStack(Items.field_151082_bd)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_76432_h, 1, 1), new ItemStack((Item)Herbs.MARSH_MALLOW), new ItemStack((Block)Herbs.CHAMOMILE), new ItemStack(Items.field_151082_bd)));
        condenserRecipes.add(new BasicCondenserRecipe(new PotionEffect(MobEffects.field_76428_l, 900), new ItemStack((Block)Herbs.COHOSH), new ItemStack((Item)ModItems.HONEYCOMB)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_76428_l, 1800), new ItemStack((Block)Herbs.HORSETAIL), new ItemStack((Block)Herbs.COHOSH), new ItemStack((Item)ModItems.HONEYCOMB)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_76428_l, 450, 1), new ItemStack((Item)Herbs.MARSH_MALLOW), new ItemStack((Block)Herbs.COHOSH), new ItemStack((Item)ModItems.HONEYCOMB)));
        condenserRecipes.add(new BasicCondenserRecipe(new PotionEffect(MobEffects.field_82731_v, 900), new ItemStack((Block)Herbs.DEATHSTALK), new ItemStack(Blocks.field_150425_aM)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_82731_v, 1800), new ItemStack((Block)Herbs.HORSETAIL), new ItemStack((Block)Herbs.DEATHSTALK), new ItemStack(Blocks.field_150425_aM)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_82731_v, 450, 1), new ItemStack((Item)Herbs.MARSH_MALLOW), new ItemStack((Block)Herbs.DEATHSTALK), new ItemStack(Blocks.field_150425_aM)));
        condenserRecipes.add(new BasicCondenserRecipe(new PotionEffect(MobEffects.field_76439_r, 3600), new ItemStack((Block)Herbs.MOONCAP), new ItemStack(Items.field_151070_bp)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_76439_r, 9600), new ItemStack((Block)Herbs.HORSETAIL), new ItemStack((Block)Herbs.MOONCAP), new ItemStack(Items.field_151070_bp)));
        condenserRecipes.add(new BasicCondenserRecipe(new PotionEffect(MobEffects.field_76424_c, 3600), new ItemStack((Block)Herbs.WIND_THISTLE), new ItemStack(Items.field_151102_aT)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_76424_c, 9600), new ItemStack((Block)Herbs.HORSETAIL), new ItemStack((Block)Herbs.WIND_THISTLE), new ItemStack(Items.field_151102_aT)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_76424_c, 1800, 1), new ItemStack((Item)Herbs.MARSH_MALLOW), new ItemStack((Block)Herbs.WIND_THISTLE), new ItemStack(Items.field_151102_aT)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_76426_n, 3600), ItemStack.field_190927_a, new ItemStack((Block)Herbs.ALOE_VERA), new ItemStack(Items.field_151118_aC), new ItemStack(Items.field_151044_h)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_76426_n, 9600), new ItemStack((Block)Herbs.HORSETAIL), new ItemStack((Block)Herbs.ALOE_VERA), new ItemStack(Items.field_151118_aC), new ItemStack(Items.field_151044_h)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_180152_w, 3600), ItemStack.field_190927_a, new ItemStack((Block)Herbs.BLOOD_ORCHID), new ItemStack(Items.field_151078_bh), new ItemStack(Items.field_151137_ax)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_180152_w, 9600), new ItemStack((Block)Herbs.HORSETAIL), new ItemStack((Block)Herbs.BLOOD_ORCHID), new ItemStack(Items.field_151078_bh), new ItemStack(Items.field_151137_ax)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_180152_w, 1800, 1), new ItemStack((Item)Herbs.MARSH_MALLOW), new ItemStack((Block)Herbs.BLOOD_ORCHID), new ItemStack(Items.field_151078_bh), new ItemStack(Items.field_151137_ax)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_76422_e, 3600), ItemStack.field_190927_a, new ItemStack((Item)Herbs.CORE_ROOT), new ItemStack(Items.field_191525_da), new ItemStack(Items.field_151137_ax)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_76422_e, 9600), new ItemStack((Block)Herbs.HORSETAIL), new ItemStack((Item)Herbs.CORE_ROOT), new ItemStack(Items.field_191525_da), new ItemStack(Items.field_151137_ax)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_76422_e, 1800, 1), new ItemStack((Item)Herbs.MARSH_MALLOW), new ItemStack((Item)Herbs.CORE_ROOT), new ItemStack(Items.field_191525_da), new ItemStack(Items.field_151137_ax)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_76420_g, 3600), ItemStack.field_190927_a, new ItemStack((Item)Herbs.GINSENG), new ItemStack(Items.field_151103_aS), new ItemStack(Items.field_151016_H)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_76420_g, 9600), new ItemStack((Block)Herbs.HORSETAIL), new ItemStack((Item)Herbs.GINSENG), new ItemStack(Items.field_151103_aS), new ItemStack(Items.field_151016_H)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(MobEffects.field_76420_g, 1800, 1), new ItemStack((Item)Herbs.MARSH_MALLOW), new ItemStack((Item)Herbs.GINSENG), new ItemStack(Items.field_151103_aS), new ItemStack(Items.field_151016_H)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(PotionsRustic.IRON_SKIN_POTION, 3600), ItemStack.field_190927_a, new ItemStack((Item)ModItems.IRONBERRIES), new ItemStack(Items.field_151116_aA), new ItemStack(Items.field_151119_aD)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(PotionsRustic.IRON_SKIN_POTION, 9600), new ItemStack((Block)Herbs.HORSETAIL), new ItemStack((Item)ModItems.IRONBERRIES), new ItemStack(Items.field_151116_aA), new ItemStack(Items.field_151119_aD)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(PotionsRustic.IRON_SKIN_POTION, 1800, 1), new ItemStack((Item)Herbs.MARSH_MALLOW), new ItemStack((Item)ModItems.IRONBERRIES), new ItemStack(Items.field_151116_aA), new ItemStack(Items.field_151119_aD)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(PotionsRustic.FEATHER_POTION, 3600), ItemStack.field_190927_a, new ItemStack((Item)Herbs.CLOUDSBLUFF), new ItemStack(Items.field_151008_G), new ItemStack(Items.field_151121_aF)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(PotionsRustic.FEATHER_POTION, 9600), new ItemStack((Block)Herbs.HORSETAIL), new ItemStack((Item)Herbs.CLOUDSBLUFF), new ItemStack(Items.field_151008_G), new ItemStack(Items.field_151121_aF)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(PotionsRustic.BLAZING_TRAIL_POTION, 3600), ItemStack.field_190927_a, new ItemStack((Item)ModItems.CHILI_PEPPER), new ItemStack(Items.field_151065_br), new ItemStack(Blocks.field_150424_aL)));
        condenserRecipes.add(new AdvancedCondenserRecipe(new PotionEffect(PotionsRustic.BLAZING_TRAIL_POTION, 9600), new ItemStack((Block)Herbs.HORSETAIL), new ItemStack((Item)ModItems.CHILI_PEPPER), new ItemStack(Items.field_151065_br), new ItemStack(Blocks.field_150424_aL)));
    }

    private static void addBrewingRecipes() {
        brewingRecipes.add(new BrewingBarrelRecipe(new FluidStack(ModFluids.ALE, 1), new FluidStack(ModFluids.ALE_WORT, 1)));
        brewingRecipes.add(new BrewingBarrelRecipe(new FluidStack(ModFluids.CIDER, 1), new FluidStack(ModFluids.APPLE_JUICE, 1)));
        brewingRecipes.add(new BrewingBarrelRecipe(new FluidStack(ModFluids.IRON_WINE, 1), new FluidStack(ModFluids.IRONBERRY_JUICE, 1)));
        brewingRecipes.add(new BrewingBarrelRecipe(new FluidStack(ModFluids.MEAD, 1), new FluidStack(ModFluids.HONEY, 1)));
        if (FluidRegistry.isFluidRegistered((String)"for.honey")) {
            brewingRecipes.add(new BrewingBarrelRecipe(new FluidStack(ModFluids.MEAD, 1), new FluidStack(FluidRegistry.getFluid((String)"for.honey"), 1)));
        }
        brewingRecipes.add(new BrewingBarrelRecipe(new FluidStack(ModFluids.WILDBERRY_WINE, 1), new FluidStack(ModFluids.WILDBERRY_JUICE, 1)));
        brewingRecipes.add(new BrewingBarrelRecipe(new FluidStack(ModFluids.WINE, 1), new FluidStack(ModFluids.GRAPE_JUICE, 1)));
    }
}

