/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.items;

import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.mods.adhooks.init.HookType;
import net.minecraft.creativetab.CreativeTabs;

public class Hook
extends ForgeItem {
    public static final FloatBounds STRENGTH_BOUNDS = new FloatBounds(Float.valueOf(0.0f), Float.valueOf(20.0f));
    public static final FloatBounds DAMAGE_BOUNDS = new FloatBounds(Float.valueOf(0.0f), Float.valueOf(100.0f));
    public static final FloatBounds RESISTANCE_BOUNDS = new FloatBounds(Float.valueOf(0.0f), Float.valueOf(60.0f));
    public static final FloatBounds WEIGHT_BOUNDS = new FloatBounds(Float.valueOf(0.0f), Float.valueOf(65536.0f));
    public final HookType type;
    public final float resistance;
    public final boolean affectsNPCs;
    public final boolean affectsPlayers;
    public final boolean canHookAnyBlock;
    public final float maxEntityWeight;
    protected float strength;
    protected float damage;

    public Hook(ForgeMod mod, UnitConfig config, HookType type, float strength, float damage, float resistance) {
        super(mod, config, type.name(), CreativeTabs.field_78040_i);
        this.type = type;
        this.strength = ForgeConfig.getFloat((ForgeConfig)config, (String)this.getUnitCategory(), (String)"strength", (float)strength, (FloatBounds)STRENGTH_BOUNDS, (String)"Defines how heavy duty it can withstand.");
        this.damage = ForgeConfig.getFloat((ForgeConfig)config, (String)this.getUnitCategory(), (String)"damage", (float)damage, (FloatBounds)DAMAGE_BOUNDS, (String)"Defines how much damage it will deal to entity on hit.");
        this.resistance = ForgeConfig.getFloat((ForgeConfig)config, (String)this.getUnitCategory(), (String)"resistance", (float)resistance, (FloatBounds)RESISTANCE_BOUNDS, (String)"Defines how long it can be under fire influence (in seconds).");
        this.affectsNPCs = ForgeConfig.getBool((ForgeConfig)config, (String)this.getUnitCategory(), (String)"affectsNPCs", (boolean)true, (String)"Defines interation with non-playable characters.");
        this.maxEntityWeight = ForgeConfig.getFloat((ForgeConfig)config, (String)this.getUnitCategory(), (String)"maxEntityWeight", (float)Hook.WEIGHT_BOUNDS.max.floatValue(), (FloatBounds)WEIGHT_BOUNDS, (String)"Defines the maximum weight of an entity that can be grappled.\nWhere weight = entity.width * entity.height (ex: villagerWeight = 0.6 * 1.95 = 1.17, pigWeight = 0.9 * 0.9 = 0.81)");
        this.affectsPlayers = ForgeConfig.getBool((ForgeConfig)config, (String)this.getUnitCategory(), (String)"affectsPlayers", (boolean)true, (String)"Defines interation with players.");
        this.canHookAnyBlock = ForgeConfig.getBool((ForgeConfig)config, (String)this.getUnitCategory(), (String)"canHookAnyBlock", (boolean)false, (String)"If true, you can hook any block regardless of its material and hardness.");
    }

    public float getStrength() {
        return this.strength;
    }

    public float getDamage() {
        return this.damage;
    }
}

