/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.motion;

import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.mods.adhooks.motion.EntityTarget;
import com.endertech.minecraft.mods.adhooks.motion.SinglePlayerTarget;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class MotionController {
    protected static final double DAMPING = 0.5;
    protected static final Map<Entity, EntityTarget<?>> SERVER_TARGETS = new ConcurrentHashMap();
    protected static final Map<EntityPlayerSP, SinglePlayerTarget> CLIENT_TARGETS = new ConcurrentHashMap<EntityPlayerSP, SinglePlayerTarget>();

    public static Optional<EntityTarget<?>> getTarget(Entity entity) {
        if (ForgeEntity.isServerSide((Entity)entity) && !(entity instanceof EntityPlayer)) {
            EntityTarget<Object> target = SERVER_TARGETS.get(entity);
            if (target == null) {
                target = new EntityTarget<Entity>(entity, 0.5);
                SERVER_TARGETS.put(entity, target);
            }
            return Optional.of(target);
        }
        if (ForgeEntity.isClientSide((Entity)entity) && entity instanceof EntityPlayerSP) {
            EntityPlayerSP player = (EntityPlayerSP)entity;
            SinglePlayerTarget target = CLIENT_TARGETS.get(player);
            if (target == null) {
                target = new SinglePlayerTarget(player, 0.5);
                CLIENT_TARGETS.put(player, target);
            }
            return Optional.of(target);
        }
        return Optional.empty();
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            MotionController.applyTo(SERVER_TARGETS.values());
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            MotionController.applyTo(CLIENT_TARGETS.values());
        }
    }

    protected static <T extends EntityTarget<?>> void applyTo(Collection<T> targets) {
        Iterator<T> iterator = targets.iterator();
        while (iterator.hasNext()) {
            EntityTarget target = (EntityTarget)iterator.next();
            if (target.exists()) {
                target.applyMotions();
                continue;
            }
            iterator.remove();
        }
    }
}

