/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.config.json;

import com.google.common.base.Predicate;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import toughasnails.core.ToughAsNails;
import toughasnails.util.config.NBTUtilExt;

public class ItemPredicate
implements Predicate<ItemStack> {
    @SerializedName(value="name")
    private String itemRegistryName;
    private int metadata;
    private String nbt;

    public ItemPredicate(ResourceLocation itemRegistryLoc, int metadata, String nbt) {
        this.itemRegistryName = itemRegistryLoc.toString();
        this.metadata = metadata;
    }

    public ItemPredicate(ResourceLocation itemRegistryLoc, int metadata) {
        this(itemRegistryLoc, metadata, null);
    }

    public ItemPredicate(Item item, int metadata) {
        this(item.getRegistryName(), metadata);
    }

    public ItemPredicate(Item item) {
        this(item, 0);
    }

    public boolean apply(@Nullable ItemStack input) {
        ItemStack stack = this.getItemStack();
        boolean areItemsEqual = input.func_77969_a(stack);
        NBTTagCompound ourTag = stack.func_77978_p();
        NBTTagCompound theirTag = input.func_77978_p();
        boolean areTagsEqual = NBTUtilExt.areNBTsEqualOrNull(ourTag, theirTag);
        return areItemsEqual && areTagsEqual;
    }

    public ItemStack getItemStack() {
        Item item = Item.func_111206_d((String)this.itemRegistryName);
        if (item != null) {
            ItemStack stack = new ItemStack(item, 1, this.metadata);
            if (this.nbt != null) {
                try {
                    stack.func_77982_d(JsonToNBT.func_180713_a((String)this.nbt));
                }
                catch (NBTException e) {
                    ToughAsNails.logger.error("Failed to parse NBT tag for ItemPredicate: ignoring NBT.  This is likely an error. (Item Name: " + this.itemRegistryName + ")");
                }
            }
            return stack;
        }
        return null;
    }
}

