/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.init;

import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import toughasnails.api.TANPotions;
import toughasnails.api.item.TANItems;
import toughasnails.fluids.PurifiedWaterFluid;
import toughasnails.util.PotionBrewingRecipe;

public class ModCrafting {
    public static void preInit() {
        ModCrafting.addOreRegistration();
        ModCrafting.addCraftingRecipies();
    }

    public static void init() {
        ModCrafting.addSmeltingRecipes();
    }

    private static void addCraftingRecipies() {
        ModCrafting.addBrewingRecipe(PotionTypes.field_185233_e, new ItemStack(TANItems.magma_shard), TANPotions.heat_resistance_type);
        ModCrafting.addBrewingRecipe(PotionTypes.field_185233_e, new ItemStack(TANItems.ice_cube), TANPotions.cold_resistance_type);
        ModCrafting.addBrewingRecipe(TANPotions.heat_resistance_type, new ItemStack(Items.field_151137_ax), TANPotions.long_heat_resistance_type);
        ModCrafting.addBrewingRecipe(TANPotions.cold_resistance_type, new ItemStack(Items.field_151137_ax), TANPotions.long_cold_resistance_type);
        ModCrafting.addPotionTransforms(TANPotions.heat_resistance_type);
        ModCrafting.addPotionTransforms(TANPotions.cold_resistance_type);
        ModCrafting.addPotionTransforms(TANPotions.long_heat_resistance_type);
        ModCrafting.addPotionTransforms(TANPotions.long_cold_resistance_type);
    }

    public static void addSmeltingRecipes() {
        GameRegistry.addSmelting((Item)Items.field_151131_as, (ItemStack)UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)PurifiedWaterFluid.instance), (float)0.0f);
        GameRegistry.addSmelting((ItemStack)PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b), (ItemStack)new ItemStack(TANItems.purified_water_bottle, 1), (float)0.0f);
    }

    private static void addOreRegistration() {
        OreDictionary.registerOre((String)"sugar", (ItemStack)new ItemStack(Items.field_151102_aT));
    }

    private static void addBrewingRecipe(PotionType input, ItemStack ingredient, PotionType output) {
        ModCrafting.addBrewingRecipe(new ItemStack((Item)Items.field_151068_bn), input, ingredient, new ItemStack((Item)Items.field_151068_bn), output);
        ModCrafting.addBrewingRecipe(new ItemStack((Item)Items.field_185155_bH), input, ingredient, new ItemStack((Item)Items.field_185155_bH), output);
        ModCrafting.addBrewingRecipe(new ItemStack((Item)Items.field_185156_bI), input, ingredient, new ItemStack((Item)Items.field_185156_bI), output);
    }

    private static void addPotionTransforms(PotionType potion) {
        ModCrafting.addBrewingRecipe(new ItemStack((Item)Items.field_151068_bn), potion, new ItemStack(Items.field_151016_H), new ItemStack((Item)Items.field_185155_bH), potion);
        ModCrafting.addBrewingRecipe(new ItemStack((Item)Items.field_185156_bI), potion, new ItemStack(Items.field_151016_H), new ItemStack((Item)Items.field_185155_bH), potion);
        ModCrafting.addBrewingRecipe(new ItemStack((Item)Items.field_151068_bn), potion, new ItemStack(Items.field_185157_bK), new ItemStack((Item)Items.field_185156_bI), potion);
        ModCrafting.addBrewingRecipe(new ItemStack((Item)Items.field_185155_bH), potion, new ItemStack(Items.field_185157_bK), new ItemStack((Item)Items.field_185156_bI), potion);
    }

    private static void addBrewingRecipe(ItemStack inBottle, PotionType input, ItemStack ingredient, ItemStack outBottle, PotionType output) {
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new PotionBrewingRecipe(PotionUtils.func_185188_a((ItemStack)inBottle, (PotionType)input), ingredient, PotionUtils.func_185188_a((ItemStack)outBottle, (PotionType)output)));
    }
}

