/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature.modifier;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import toughasnails.api.temperature.IModifierMonitor;
import toughasnails.api.temperature.Temperature;
import toughasnails.init.ModConfig;
import toughasnails.temperature.modifier.TemperatureModifier;
import toughasnails.util.BiomeUtils;
import toughasnails.util.TerrainUtils;

public class BiomeModifier
extends TemperatureModifier {
    public BiomeModifier(String id) {
        super(id);
    }

    @Override
    public Temperature applyEnvironmentModifiers(World world, BlockPos pos, Temperature initialTemperature, IModifierMonitor monitor) {
        Biome biome = world.func_180494_b(pos);
        Biome biomeNorth = world.func_180494_b(pos.func_177982_a(0, 0, -10));
        Biome biomeSouth = world.func_180494_b(pos.func_177982_a(0, 0, 10));
        Biome biomeEast = world.func_180494_b(pos.func_177982_a(10, 0, 0));
        Biome biomeWest = world.func_180494_b(pos.func_177982_a(-10, 0, 0));
        float biomeTemp = (BiomeUtils.getBiomeTempNorm(biome) + BiomeUtils.getBiomeTempNorm(biomeNorth) + BiomeUtils.getBiomeTempNorm(biomeSouth) + BiomeUtils.getBiomeTempNorm(biomeEast) + BiomeUtils.getBiomeTempNorm(biomeWest)) / 5.0f;
        int newTemperatureLevel = initialTemperature.getRawValue();
        int temperatureModifier = Math.round((biomeTemp * 2.0f - 1.0f) * (float)ModConfig.temperature.maxBiomeTempOffset);
        if (world.field_73011_w.func_76569_d() && ModConfig.temperature.enableUndergroundEffect) {
            temperatureModifier = Math.round(TerrainUtils.getAverageUndergroundCoefficient(world, pos) * (float)temperatureModifier);
        }
        monitor.addEntry(new IModifierMonitor.Context(this.getId(), "Biome Temperature", initialTemperature, new Temperature(newTemperatureLevel += temperatureModifier)));
        return new Temperature(newTemperatureLevel);
    }

    @Override
    public boolean isPlayerSpecific() {
        return false;
    }
}

