/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.thirst;

import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import toughasnails.api.TANCapabilities;
import toughasnails.api.config.GameplayOption;
import toughasnails.api.config.SyncedConfig;
import toughasnails.api.stat.StatHandlerBase;
import toughasnails.api.stat.capability.IThirst;
import toughasnails.network.message.MessageUpdateStat;

public class ThirstHandler
extends StatHandlerBase
implements IThirst {
    private int thirstLevel = 20;
    private int prevThirstLevel;
    private float thirstHydrationLevel = 5.0f;
    private float thirstExhaustionLevel;
    private int thirstTimer;
    private Vector3d movementVec;

    @Override
    public void update(EntityPlayer player, World world, TickEvent.Phase phase) {
        if (!SyncedConfig.getBooleanValue(GameplayOption.ENABLE_THIRST) || player.func_184812_l_()) {
            return;
        }
        if (phase == TickEvent.Phase.START) {
            if (this.movementVec != null) {
                Vector3d movement = new Vector3d(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                movement.sub((Tuple3d)this.movementVec);
                movement.absolute();
                int distance = (int)Math.round(movement.length() * 100.0);
                if (distance > 0) {
                    this.applyMovementExhaustion(player, distance);
                }
            }
        } else if (phase == TickEvent.Phase.END) {
            this.movementVec = new Vector3d(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            EnumDifficulty enumdifficulty = world.func_175659_aa();
            if (this.thirstExhaustionLevel > 4.0f) {
                this.thirstExhaustionLevel -= 4.0f;
                if (this.thirstHydrationLevel > 0.0f) {
                    this.thirstHydrationLevel = Math.max(this.thirstHydrationLevel - 1.0f, 0.0f);
                } else if (enumdifficulty != EnumDifficulty.PEACEFUL || SyncedConfig.getBooleanValue(GameplayOption.ENABLE_PEACEFUL)) {
                    this.thirstLevel = Math.max(this.thirstLevel - 1, 0);
                }
            }
            if (this.thirstLevel <= 0) {
                ++this.thirstTimer;
                if (this.thirstTimer >= 80) {
                    if (enumdifficulty == EnumDifficulty.PEACEFUL && SyncedConfig.getBooleanValue(GameplayOption.ENABLE_PEACEFUL) && player.func_110143_aJ() > 10.0f || enumdifficulty == EnumDifficulty.EASY && player.func_110143_aJ() > 10.0f || enumdifficulty == EnumDifficulty.NORMAL && player.func_110143_aJ() > 1.0f || enumdifficulty == EnumDifficulty.HARD) {
                        player.func_70097_a(DamageSource.field_76366_f, 1.0f);
                    }
                    this.thirstTimer = 0;
                }
            } else {
                this.thirstTimer = 0;
            }
            if (player.func_70051_ag() && this.thirstLevel <= 6) {
                player.func_70031_b(false);
            }
        }
    }

    private void applyMovementExhaustion(EntityPlayer player, int distance) {
        if (player.func_70055_a(Material.field_151586_h)) {
            this.addExhaustion(0.015f * (float)distance * 0.01f);
        } else if (player.func_70090_H()) {
            this.addExhaustion(0.015f * (float)distance * 0.01f);
        } else if (player.field_70122_E) {
            if (player.func_70051_ag()) {
                this.addExhaustion(0.099999994f * (float)distance * 0.01f);
            } else {
                this.addExhaustion(0.01f * (float)distance * 0.01f);
            }
        }
    }

    @Override
    public boolean hasChanged() {
        return this.prevThirstLevel != this.thirstLevel;
    }

    @Override
    public void onSendClientUpdate() {
        this.prevThirstLevel = this.thirstLevel;
    }

    @Override
    public IMessage createUpdateMessage() {
        NBTTagCompound data = (NBTTagCompound)TANCapabilities.THIRST.getStorage().writeNBT(TANCapabilities.THIRST, (Object)this, null);
        return new MessageUpdateStat(TANCapabilities.THIRST, data);
    }

    @Override
    public void setThirst(int thirst) {
        this.thirstLevel = thirst;
    }

    @Override
    public void setHydration(float hydration) {
        this.thirstHydrationLevel = hydration;
    }

    @Override
    public void setExhaustion(float exhaustion) {
        this.thirstExhaustionLevel = exhaustion;
    }

    @Override
    public int getThirst() {
        return this.thirstLevel;
    }

    @Override
    public float getHydration() {
        return this.thirstHydrationLevel;
    }

    @Override
    public float getExhaustion() {
        return this.thirstExhaustionLevel;
    }

    @Override
    public void setChangeTime(int ticks) {
        this.thirstTimer = ticks;
    }

    @Override
    public int getChangeTime() {
        return this.thirstTimer;
    }

    @Override
    public void addStats(int thirst, float hydration) {
        if (SyncedConfig.getBooleanValue(GameplayOption.ENABLE_THIRST)) {
            this.thirstLevel = Math.min(thirst + this.thirstLevel, 20);
            this.thirstHydrationLevel = Math.min(this.thirstHydrationLevel + (float)thirst * hydration * 2.0f, (float)this.thirstLevel);
        }
    }

    public void addExhaustion(float amount) {
        if (SyncedConfig.getBooleanValue(GameplayOption.ENABLE_THIRST)) {
            this.thirstExhaustionLevel = Math.min(this.thirstExhaustionLevel + amount, 40.0f);
        }
    }

    public boolean isThirsty() {
        return this.thirstLevel < 20;
    }
}

