/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.armorunder.recipes;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.List;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jwaresoftware.mcmods.armorunder.ModItems;
import org.jwaresoftware.mcmods.armorunder.recipes.ArmorRecipes;
import org.jwaresoftware.mcmods.armorunder.recipes.AutoregLinedArmorRecipe;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.SharedGlue;

public final class BuffAutoregLiningRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private final IRecipe _impl;
    private final int _modifier;

    static final List<IRecipe> addSampleRecipes(List<IRecipe> recipes) {
        if (ArmorRecipes.ENABLED) {
            for (ItemStack ozzy_liner : OreDictionary.getOres((String)"itemAutoregLining", (boolean)false)) {
                BuffAutoregLiningRecipe.addRecipes(ozzy_liner, recipes);
            }
        }
        return recipes;
    }

    BuffAutoregLiningRecipe(int modifier, IRecipe template) {
        this._impl = template;
        this._modifier = modifier;
    }

    public boolean func_194133_a(int width, int height) {
        return this._impl.func_194133_a(width, height);
    }

    public ItemStack func_77571_b() {
        return ItemStacks.NULLSTACK();
    }

    public boolean func_77569_a(InventoryCrafting grid, World world) {
        return ArmorRecipes.ENABLED && this._impl.func_77569_a(grid, world);
    }

    private int getTargetModifier(ItemStack lining) {
        return AutoregLinedArmorRecipe.getTargetModifier(lining, 0);
    }

    public ItemStack func_77572_b(InventoryCrafting grid) {
        ItemStack out = ItemStacks.NULLSTACK();
        if (ArmorRecipes.ENABLED) {
            int cur_target;
            int target;
            ItemStack lining = null;
            for (int i = 0; i < grid.func_70302_i_(); ++i) {
                ItemStack next = grid.func_70301_a(i);
                if (ItemStacks.isEmpty((ItemStack)next) || !AutoregLinedArmorRecipe.isAutoregLining(next.func_77973_b())) continue;
                lining = next;
                break;
            }
            if (lining != null && (target = AutoregLinedArmorRecipe.normalizeOverride((cur_target = this.getTargetModifier(lining)) + this._modifier)) != cur_target) {
                out = ItemStacks.copyItemStackSingle((ItemStack)lining);
                AutoregLinedArmorRecipe.setTargetModifier(out, target);
            }
        }
        return out;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting grid) {
        return SharedGlue.emptyNonNullItemStackList((int)grid.func_70302_i_());
    }

    private static final void addRecipes(ItemStack plain_liner, List<IRecipe> recipes) {
        ItemStack buffed_liner = ItemStacks.copyItemStackSingle((ItemStack)plain_liner);
        AutoregLinedArmorRecipe.setTargetModifier(buffed_liner, 1);
        recipes.add((IRecipe)new ShapedOreRecipe(null, buffed_liner, new Object[]{"xxx", "xLx", "xxx", Character.valueOf('x'), ModItems.heating_goo, Character.valueOf('L'), plain_liner}));
        buffed_liner = ItemStacks.copyItemStackSingle((ItemStack)plain_liner);
        AutoregLinedArmorRecipe.setTargetModifier(buffed_liner, -1);
        recipes.add((IRecipe)new ShapedOreRecipe(null, buffed_liner, new Object[]{"xxx", "xLx", "xxx", Character.valueOf('x'), ModItems.cooling_goo, Character.valueOf('L'), plain_liner}));
    }

    public static final class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            int modifier = JsonUtils.func_151208_a((JsonObject)json, (String)"modifier", (int)0);
            if (modifier > 0) {
                modifier = 1;
            } else if (modifier < 0) {
                modifier = -1;
            } else {
                throw new JsonParseException("Lining modifier must by either -1 or +1");
            }
            ShapedOreRecipe impl = ShapedOreRecipe.factory((JsonContext)context, (JsonObject)json);
            return new BuffAutoregLiningRecipe(modifier, (IRecipe)impl);
        }
    }
}

