/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.armorunder.recipes;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jwaresoftware.mcmods.armorunder.ModItem;
import org.jwaresoftware.mcmods.armorunder.ModItems;
import org.jwaresoftware.mcmods.armorunder.recipes.ArmorRecipes;
import org.jwaresoftware.mcmods.lib.Armory;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.recipes.JR;

public final class StripArmorTLiningRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private final IRecipe _impl;

    StripArmorTLiningRecipe(IRecipe template) {
        this._impl = template;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height == 2;
    }

    public ItemStack func_77571_b() {
        return ItemStacks.NULLSTACK();
    }

    @Nullable
    private Armory.TLining newTLining(ItemStack armorpiece) {
        Armory.TLining cur_lining = Armory.getTLining((ItemStack)armorpiece);
        if (cur_lining == Armory.TLining.NONE) {
            return null;
        }
        int modifier = cur_lining.getDirection() > 0 ? -1 : 1;
        return cur_lining.adjust(modifier);
    }

    @Nullable
    private ItemStack oldTLining(ItemStack armorpiece) {
        Armory.TLining cur_lining = Armory.getTLining((ItemStack)armorpiece);
        if (cur_lining.isEmpty()) {
            return null;
        }
        boolean warming = cur_lining.getDirection() > 0;
        ModItem lining = null;
        if (RID.matches((ItemStack)armorpiece, (String)"itemChestplate")) {
            lining = warming ? ModItems.warm_chestplate_liner : ModItems.cool_chestplate_liner;
        } else if (RID.matches((ItemStack)armorpiece, (String)"itemLeggings")) {
            lining = warming ? ModItems.warm_leggings_liner : ModItems.cool_leggings_liner;
        } else if (RID.matches((ItemStack)armorpiece, (String)"itemHelmet")) {
            lining = warming ? ModItems.warm_helmet_liner : ModItems.cool_helmet_liner;
        } else if (RID.matches((ItemStack)armorpiece, (String)"itemBoots")) {
            lining = warming ? ModItems.warm_boots_liner : ModItems.cool_boots_liner;
        }
        return lining != null ? new ItemStack((Item)lining) : null;
    }

    public boolean func_77569_a(InventoryCrafting grid, World world) {
        return ArmorRecipes.ENABLED && this._impl.func_77569_a(grid, world);
    }

    public ItemStack func_77572_b(InventoryCrafting grid) {
        ItemStack out = ItemStacks.NULLSTACK();
        if (ArmorRecipes.ENABLED) {
            ItemStack armorpiece = null;
            for (int i = 0; i < grid.func_70302_i_(); ++i) {
                Item item;
                ItemStack next = grid.func_70301_a(i);
                if (ItemStacks.isEmpty((ItemStack)next) || !((item = next.func_77973_b()) instanceof ItemArmor)) continue;
                armorpiece = next;
                break;
            }
            if (armorpiece != null) {
                Armory.TLining new_lining = this.newTLining(armorpiece);
                if (new_lining != null) {
                    out = ItemStacks.copyItemStackSingle(armorpiece);
                    out = Armory.setTLining((ItemStack)out, (Armory.TLining)new_lining);
                } else if (Armory.hasXLining(armorpiece)) {
                    out = ItemStacks.copyItemStackSingle(armorpiece);
                    Armory.setXLining((ItemStack)out, (Armory.XLining.Def)Armory.XLining.NO_DEF);
                }
            }
        }
        return out;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting grid) {
        NonNullList out = SharedGlue.emptyNonNullItemStackList((int)grid.func_70302_i_());
        for (int i = 0; i < grid.func_70302_i_(); ++i) {
            ItemStack leftover;
            ItemStack next = grid.func_70301_a(i);
            if (ItemStacks.isEmpty((ItemStack)next)) continue;
            Item item = next.func_77973_b();
            if (item == ModItems.liner_snips) {
                out.set(i, (Object)item.getContainerItem(next));
                continue;
            }
            if (!(item instanceof ItemArmor) || (leftover = this.oldTLining(next)) == null) continue;
            out.set(i, (Object)leftover);
        }
        return out;
    }

    public static final class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            ShapelessOreRecipe impl = ShapelessOreRecipe.factory((JsonContext)context, (JsonObject)json);
            impl = new JR.LegacyShapelessOreRecipe(null, impl);
            return new StripArmorTLiningRecipe((IRecipe)impl);
        }
    }
}

