/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;
import snownee.snow.BlockSnowLayer;
import snownee.snow.EntityFallingSnow;
import snownee.snow.ItemSnowLayer;
import snownee.snow.ModConfig;
import snownee.snow.RenderFallingSnow;
import snownee.snow.TESRSnowLayer;
import snownee.snow.TileSnowLayer;

@Mod(modid="snowrealmagic", name="Snow! Real Magic!", version="0.3.3", acceptedMinecraftVersions="[1.12, 1.13)")
@Mod.EventBusSubscriber
public class SnowRealMagic {
    public static final String MODID = "snowrealmagic";
    public static final String NAME = "Snow! Real Magic!";
    private static Logger logger;
    public static Block BLOCK;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
    }

    @SubscribeEvent
    public static void onBlockRegister(RegistryEvent.Register<Block> event) {
        BLOCK = new BlockSnowLayer();
        event.getRegistry().register((IForgeRegistryEntry)BLOCK);
        if (ModConfig.placeSnowInBlock) {
            GameRegistry.registerTileEntity(TileSnowLayer.class, (ResourceLocation)new ResourceLocation(MODID, "snow"));
        }
    }

    @SubscribeEvent
    public static void onItemRegister(RegistryEvent.Register<Item> event) {
        event.getRegistry().register(new ItemSnowLayer(BLOCK).setRegistryName(BLOCK.getRegistryName()));
    }

    @SubscribeEvent
    public static void onEntityRegister(RegistryEvent.Register<EntityEntry> event) {
        event.getRegistry().register((IForgeRegistryEntry)EntityEntryBuilder.create().entity(EntityFallingSnow.class).id(new ResourceLocation(MODID, "snow"), 0).name("snowrealmagic.snow").tracker(160, 20, true).build());
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityFallingSnow.class, RenderFallingSnow::new);
        if (ModConfig.placeSnowInBlock) {
            ModelLoader.setCustomStateMapper((Block)BLOCK, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockSnowLayer.TILE}).func_178441_a());
            ClientRegistry.bindTileEntitySpecialRenderer(TileSnowLayer.class, (TileEntitySpecialRenderer)new TESRSnowLayer());
        }
    }

    static {
        BLOCK = Blocks.field_150431_aC;
    }
}

