/*
 * Decompiled with CFR 0.152.
 */
package c4.comforts.common;

import c4.comforts.common.util.ComfortsUtil;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="comforts")
public class ConfigHandler {
    @Config.Name(value="Auto Use Sleeping Bags")
    @Config.Comment(value={"Set to true to automatically use sleeping bags when placed"})
    @Config.RequiresMcRestart
    public static boolean autoUse = true;
    @Config.Name(value="Well-Rested")
    @Config.Comment(value={"Set to true to prevent sleeping depending on how long you previously slept"})
    @Config.RequiresMcRestart
    public static boolean wellRested = false;
    @Config.Name(value="Sleepy Factor")
    @Config.Comment(value={"If well rested is true, this value is used to determine how long you need before being able to sleep again (larger numbers = can sleep sooner)"})
    @Config.RangeDouble(min=1.0, max=20.0)
    public static float sleepyRatio = 2.0f;
    @Config.Name(value="Leisure Hammocks")
    @Config.Comment(value={"Set to true to enable relaxing in hammocks without sleeping"})
    public static boolean restHammocks = false;
    @Config.Name(value="Nighttime Hammocks")
    @Config.Comment(value={"Set to true to enable sleeping in hammocks at night"})
    public static boolean nightHammocks = false;
    @Config.Name(value="Sleeping Bag Debuffs")
    @Config.Comment(value={"List of debuffs to apply to players after using the sleeping bag", "Format: [effect] [duration(secs)] [power]"})
    public static String[] sleepingBagDebuffs = new String[0];
    @Config.Name(value="Sleeping Bag Break Chance")
    @Config.Comment(value={"The chance that a sleeping bag will break upon usage"})
    @Config.RangeDouble(min=0.0, max=1.0)
    public static double bagBreakPerc = 0.0;
    public static final ToughAsNails toughasnails = new ToughAsNails();

    @Mod.EventBusSubscriber(modid="comforts")
    private static class ConfigEventHandler {
        private ConfigEventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent evt) {
            if (evt.getModID().equals("comforts")) {
                ConfigManager.sync((String)"comforts", (Config.Type)Config.Type.INSTANCE);
                ComfortsUtil.parseDebuffs();
            }
        }
    }

    public static class ToughAsNails {
        @Config.Name(value="Insulated Sleeping Bags")
        @Config.Comment(value={"Set to true to have sleeping bags slightly warm your body if you're cold"})
        @Config.RequiresMcRestart
        public boolean warmBody = false;
    }
}

