/*
 * Decompiled with CFR 0.152.
 */
package c4.comforts.common.capability;

import c4.comforts.common.ConfigHandler;
import c4.comforts.common.blocks.BlockSleepingBag;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.ItemHandlerHelper;

public class CapabilitySleeping {
    @CapabilityInject(value=ISleeping.class)
    public static final Capability<ISleeping> SLEEP_CAP = null;
    public static final EnumFacing DEFAULT_FACING = null;
    public static final ResourceLocation ID = new ResourceLocation("comforts", "sleeping");
    private static final String SLEEP_TAG = "Sleeping";
    private static final String POS_TAG = "Pos";

    public static void register() {
        CapabilityManager.INSTANCE.register(ISleeping.class, (Capability.IStorage)new Capability.IStorage<ISleeping>(){

            public NBTBase writeNBT(Capability<ISleeping> capability, ISleeping instance, EnumFacing side) {
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74757_a(CapabilitySleeping.SLEEP_TAG, instance.isSleeping());
                compound.func_74782_a(CapabilitySleeping.POS_TAG, (NBTBase)NBTUtil.func_186859_a((BlockPos)instance.getPos()));
                return compound;
            }

            public void readNBT(Capability<ISleeping> capability, ISleeping instance, EnumFacing side, NBTBase nbt) {
                NBTTagCompound compound = (NBTTagCompound)nbt;
                instance.setSleeping(compound.func_74767_n(CapabilitySleeping.SLEEP_TAG));
                instance.setPos(NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l(CapabilitySleeping.POS_TAG)));
            }
        }, Sleeping::new);
        if (ConfigHandler.autoUse) {
            MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        }
    }

    @Nullable
    public static ISleeping getSleeping(EntityPlayer playerIn) {
        if (playerIn != null && playerIn.hasCapability(SLEEP_CAP, DEFAULT_FACING)) {
            return (ISleeping)playerIn.getCapability(SLEEP_CAP, DEFAULT_FACING);
        }
        return null;
    }

    public static ICapabilityProvider createProvider(ISleeping sleeping) {
        return new Provider(sleeping, SLEEP_CAP, DEFAULT_FACING);
    }

    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public void attachCapabilities(AttachCapabilitiesEvent<Entity> evt) {
            if (evt.getObject() instanceof EntityPlayer) {
                evt.addCapability(ID, CapabilitySleeping.createProvider(new Sleeping()));
            }
        }

        @SubscribeEvent
        public void onPostPlayerTick(TickEvent.PlayerTickEvent evt) {
            if (evt.phase == TickEvent.Phase.END && evt.side == Side.SERVER) {
                EntityPlayer player = evt.player;
                ISleeping sleeping = CapabilitySleeping.getSleeping(player);
                if (!player.func_70608_bn() && sleeping != null && sleeping.isSleeping()) {
                    World world = player.field_70170_p;
                    BlockPos blockpos = sleeping.getPos();
                    IBlockState state = world.func_180495_p(blockpos);
                    if (world.func_175667_e(blockpos) && state.func_177230_c() instanceof BlockSleepingBag) {
                        EntityPlayer.SleepResult sleepResult = ((BlockSleepingBag)state.func_177230_c()).doSleep(world, blockpos, state, player);
                        if (sleepResult != EntityPlayer.SleepResult.OK) {
                            sleeping.setSleeping(false);
                            sleeping.setPos(BlockPos.field_177992_a);
                        }
                    } else {
                        sleeping.setSleeping(false);
                        sleeping.setPos(BlockPos.field_177992_a);
                    }
                }
            }
        }

        @SubscribeEvent
        public void onPlayerWakeUp(PlayerWakeUpEvent evt) {
            ISleeping sleeping;
            BlockPos pos;
            IBlockState state;
            EntityPlayer player = evt.getEntityPlayer();
            World world = player.field_70170_p;
            if (!world.field_72995_K && player.field_71081_bT != null && (state = world.func_180495_p(pos = player.field_71081_bT)).func_177230_c() instanceof BlockSleepingBag && (sleeping = CapabilitySleeping.getSleeping(player)) != null && sleeping.isSleeping()) {
                sleeping.setSleeping(false);
                sleeping.setPos(BlockPos.field_177992_a);
                ItemStack stack = state.func_177230_c().getPickBlock(state, null, world, pos, player);
                BlockPos pos1 = pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)BlockSleepingBag.field_185512_D)).func_176734_d());
                world.func_175698_g(pos);
                world.func_175698_g(pos1);
                if (!player.field_71075_bZ.field_75098_d) {
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack, (int)player.field_71071_by.field_70461_c);
                }
            }
        }
    }

    public static class Provider
    implements ICapabilitySerializable<NBTBase> {
        final Capability<ISleeping> capability;
        final EnumFacing facing;
        final ISleeping instance;

        Provider(ISleeping instance, Capability<ISleeping> capability, @Nullable EnumFacing facing) {
            this.instance = instance;
            this.capability = capability;
            this.facing = facing;
        }

        public boolean hasCapability(@Nullable Capability<?> capability, EnumFacing facing) {
            return capability == this.getCapability();
        }

        public <T> T getCapability(@Nullable Capability<T> capability, EnumFacing facing) {
            return (T)(capability == this.getCapability() ? this.getCapability().cast((Object)this.instance) : null);
        }

        final Capability<ISleeping> getCapability() {
            return this.capability;
        }

        EnumFacing getFacing() {
            return this.facing;
        }

        final ISleeping getInstance() {
            return this.instance;
        }

        public NBTBase serializeNBT() {
            return this.getCapability().writeNBT((Object)this.getInstance(), this.getFacing());
        }

        public void deserializeNBT(NBTBase nbt) {
            this.getCapability().readNBT((Object)this.getInstance(), this.getFacing(), nbt);
        }
    }

    public static class Sleeping
    implements ISleeping {
        private boolean isSleeping = false;
        private BlockPos blockPos = BlockPos.field_177992_a;

        @Override
        public boolean isSleeping() {
            return this.isSleeping;
        }

        @Override
        public void setSleeping(boolean value) {
            this.isSleeping = value;
        }

        @Override
        public BlockPos getPos() {
            return this.blockPos;
        }

        @Override
        public void setPos(BlockPos pos) {
            this.blockPos = pos;
        }
    }

    public static interface ISleeping {
        public boolean isSleeping();

        public void setSleeping(boolean var1);

        public BlockPos getPos();

        public void setPos(BlockPos var1);
    }
}

