/*
 * Decompiled with CFR 0.152.
 */
package c4.comforts.common.capability;

import c4.comforts.common.ConfigHandler;
import c4.comforts.common.capability.CapabilitySleepTime;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CapabilityWellRested {
    @CapabilityInject(value=IWellRested.class)
    public static final Capability<IWellRested> RESTED_CAP = null;
    public static final EnumFacing DEFAULT_FACING = null;
    public static final ResourceLocation ID = new ResourceLocation("comforts", "wellRested");
    private static final String WAKE_TAG = "wakeTime";
    private static final String TIRED_TAG = "tiredTime";

    public static void register() {
        CapabilityManager.INSTANCE.register(IWellRested.class, (Capability.IStorage)new Capability.IStorage<IWellRested>(){

            public NBTBase writeNBT(Capability<IWellRested> capability, IWellRested instance, EnumFacing side) {
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74772_a(CapabilityWellRested.WAKE_TAG, instance.getWakeTime());
                compound.func_74772_a(CapabilityWellRested.TIRED_TAG, instance.getTiredTime());
                return compound;
            }

            public void readNBT(Capability<IWellRested> capability, IWellRested instance, EnumFacing side, NBTBase nbt) {
                NBTTagCompound compound = (NBTTagCompound)nbt;
                instance.setWakeTime(compound.func_74763_f(CapabilityWellRested.WAKE_TAG));
                instance.setTiredTime(compound.func_74763_f(CapabilityWellRested.TIRED_TAG));
            }
        }, WellRested::new);
        if (ConfigHandler.wellRested) {
            MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        }
    }

    @Nullable
    public static IWellRested getRested(EntityPlayer playerIn) {
        if (playerIn != null && playerIn.hasCapability(RESTED_CAP, DEFAULT_FACING)) {
            return (IWellRested)playerIn.getCapability(RESTED_CAP, DEFAULT_FACING);
        }
        return null;
    }

    public static ICapabilityProvider createProvider(IWellRested rested) {
        return new Provider(rested, RESTED_CAP, DEFAULT_FACING);
    }

    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public void attachCapabilities(AttachCapabilitiesEvent<Entity> evt) {
            if (evt.getObject() instanceof EntityPlayer) {
                evt.addCapability(ID, CapabilityWellRested.createProvider(new WellRested()));
            }
        }

        @SubscribeEvent
        public void onPlayerRespawn(PlayerEvent.Clone evt) {
            IWellRested newWellRested = CapabilityWellRested.getRested(evt.getEntityPlayer());
            IWellRested oldWellRested = CapabilityWellRested.getRested(evt.getOriginal());
            if (newWellRested != null && oldWellRested != null) {
                newWellRested.setWakeTime(oldWellRested.getWakeTime());
                newWellRested.setTiredTime(oldWellRested.getTiredTime());
            }
        }

        @SubscribeEvent
        public void onPlayerSleep(PlayerSleepInBedEvent evt) {
            EntityPlayer player = evt.getEntityPlayer();
            if (!player.field_70170_p.field_72995_K) {
                IWellRested wellRested = CapabilityWellRested.getRested(player);
                long worldTime = player.func_130014_f_().func_72820_D();
                if (wellRested != null) {
                    if (wellRested.getWakeTime() > worldTime) {
                        wellRested.setWakeTime(0L);
                        wellRested.setTiredTime(0L);
                    }
                    if (wellRested.getTiredTime() > worldTime) {
                        evt.getEntityPlayer().func_146105_b((ITextComponent)new TextComponentTranslation("capability.comforts.notSleepy", new Object[0]), true);
                        evt.setResult(EntityPlayer.SleepResult.OTHER_PROBLEM);
                    }
                }
            }
        }

        @SubscribeEvent
        public void onPlayerWakeUp(PlayerWakeUpEvent evt) {
            long wakeTime;
            long timeSlept;
            EntityPlayer player = evt.getEntityPlayer();
            CapabilitySleepTime.ISleepTime sleepTime = CapabilitySleepTime.getSleepTime(player);
            IWellRested wellRested = CapabilityWellRested.getRested(player);
            if (sleepTime != null && wellRested != null && (timeSlept = (wakeTime = player.field_70170_p.func_72820_D()) - sleepTime.getSleepTime()) > 500L) {
                wellRested.setWakeTime(wakeTime);
                wellRested.setTiredTime(wakeTime + (long)((float)timeSlept / ConfigHandler.sleepyRatio));
            }
        }
    }

    public static class Provider
    implements ICapabilitySerializable<NBTBase> {
        final Capability<IWellRested> capability;
        final EnumFacing facing;
        final IWellRested instance;

        Provider(IWellRested instance, Capability<IWellRested> capability, @Nullable EnumFacing facing) {
            this.instance = instance;
            this.capability = capability;
            this.facing = facing;
        }

        public boolean hasCapability(@Nullable Capability<?> capability, EnumFacing facing) {
            return capability == this.getCapability();
        }

        public <T> T getCapability(@Nullable Capability<T> capability, EnumFacing facing) {
            return (T)(capability == this.getCapability() ? this.getCapability().cast((Object)this.instance) : null);
        }

        final Capability<IWellRested> getCapability() {
            return this.capability;
        }

        EnumFacing getFacing() {
            return this.facing;
        }

        final IWellRested getInstance() {
            return this.instance;
        }

        public NBTBase serializeNBT() {
            return this.getCapability().writeNBT((Object)this.getInstance(), this.getFacing());
        }

        public void deserializeNBT(NBTBase nbt) {
            this.getCapability().readNBT((Object)this.getInstance(), this.getFacing(), nbt);
        }
    }

    public static class WellRested
    implements IWellRested {
        private long wakeTime = 0L;
        private long tiredTime = 0L;

        @Override
        public long getWakeTime() {
            return this.wakeTime;
        }

        @Override
        public void setWakeTime(long wakeTime) {
            this.wakeTime = wakeTime;
        }

        @Override
        public long getTiredTime() {
            return this.tiredTime;
        }

        @Override
        public void setTiredTime(long tiredTime) {
            this.tiredTime = tiredTime;
        }
    }

    public static interface IWellRested {
        public long getWakeTime();

        public void setWakeTime(long var1);

        public long getTiredTime();

        public void setTiredTime(long var1);
    }
}

