/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.potioncore.potion;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class PotionCorePotion
extends Potion {
    private ResourceLocation icon;
    private boolean enabled = true;

    public PotionCorePotion(String potionName, boolean bad, int color) {
        super(bad, color);
        if (!bad) {
            this.func_188413_j();
        }
        this.setRegistryName(potionName);
        this.func_76390_b("effect." + potionName);
        this.icon = new ResourceLocation("potioncore", "textures/gui/potion/" + potionName + ".png");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void registerPotionAttributeModifiers() {
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return true;
    }

    public void func_180793_a(Entity thrownPotion, Entity thrower, EntityLivingBase entity, int amplifier, double potency) {
        this.func_76394_a(entity, amplifier);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76400_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventoryEffect(int posX, int posZ, PotionEffect effect, Minecraft mc) {
        this.renderPotionIcon(posX + 6, posZ + 7, mc);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUDEffect(int x, int y, PotionEffect effect, Minecraft mc, float alpha) {
        this.renderPotionIcon(x + 3, y + 3, mc);
    }

    @SideOnly(value=Side.CLIENT)
    private void renderPotionIcon(int x, int y, Minecraft mc) {
        mc.func_110434_K().func_110577_a(this.icon);
        int width = 18;
        int height = 18;
        float widthRatio = 0.055555556f;
        float heightRatio = 0.055555556f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b((double)(x + 0), (double)(y + height), 0.0).func_187315_a(0.0, (double)((float)height * heightRatio)).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((float)width * widthRatio), (double)((float)height * heightRatio)).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + 0), 0.0).func_187315_a((double)((float)width * widthRatio), 0.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + 0), (double)(y + 0), 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }
}

