/*
 * Decompiled with CFR 0.152.
 */
package dev.satyrn.wolfarmor.common.network;

import dev.satyrn.wolfarmor.common.network.MessageBase;
import dev.satyrn.wolfarmor.common.network.packets.WolfDropChestMessage;
import dev.satyrn.wolfarmor.common.network.packets.WolfEatMessage;
import dev.satyrn.wolfarmor.common.network.packets.WolfHealMessage;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public abstract class PacketHandler {
    private static final SimpleNetworkWrapper CHANNEL = NetworkRegistry.INSTANCE.newSimpleChannel("wolfarmor");
    private static byte ID = 0;

    public static void initialize() {
        PacketHandler.registerMessage(WolfEatMessage.class);
        PacketHandler.registerMessage(WolfHealMessage.class);
        PacketHandler.registerMessage(WolfDropChestMessage.class);
    }

    private static <T extends MessageBase<T>> void registerMessage(Class<T> clazz) {
        if (MessageBase.ClientMessageBase.class.isAssignableFrom(clazz)) {
            byte by = ID;
            ID = (byte)(by + 1);
            CHANNEL.registerMessage(clazz, clazz, (int)by, Side.CLIENT);
            return;
        }
        if (MessageBase.ServerMessageBase.class.isAssignableFrom(clazz)) {
            byte by = ID;
            ID = (byte)(by + 1);
            CHANNEL.registerMessage(clazz, clazz, (int)by, Side.SERVER);
            return;
        }
        CHANNEL.registerMessage(clazz, clazz, (int)ID, Side.CLIENT);
        byte by = ID;
        ID = (byte)(by + 1);
        CHANNEL.registerMessage(clazz, clazz, (int)by, Side.SERVER);
    }

    public static SimpleNetworkWrapper getChannel() {
        return CHANNEL;
    }
}

