/*
 * Decompiled with CFR 0.152.
 */
package dev.satyrn.wolfarmor.mixin;

import com.google.common.collect.Multimap;
import dev.satyrn.wolfarmor.WolfArmorMod;
import dev.satyrn.wolfarmor.advancements.WolfArmorTrigger;
import dev.satyrn.wolfarmor.api.entity.passive.IArmoredWolf;
import dev.satyrn.wolfarmor.api.item.IItemWolfArmor;
import dev.satyrn.wolfarmor.api.util.Criteria;
import dev.satyrn.wolfarmor.api.util.DataHelper;
import dev.satyrn.wolfarmor.api.util.Items;
import dev.satyrn.wolfarmor.item.ItemWolfArmor;
import dev.satyrn.wolfarmor.mixin.MixinEntityTameable;
import dev.satyrn.wolfarmor.util.OreDictHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ContainerHorseChest;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import org.apache.logging.log4j.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityWolf.class})
public abstract class MixinEntityWolf
extends MixinEntityTameable
implements IArmoredWolf,
IInventoryChangedListener {
    private ContainerHorseChest inventory;

    @Override
    public int getMaxSizeInventory() {
        return 1 + WolfArmorMod.getConfiguration().getWolfChestSizeHorizontal() * WolfArmorMod.getConfiguration().getWolfChestSizeVertical();
    }

    public void func_76316_a(@Nonnull IInventory invBasic) {
        if (!this.func_130014_f_().field_72995_K) {
            ItemStack armorItemStack = this.inventory.func_70301_a(0);
            this.setArmorItemStack(armorItemStack);
            this.applyArmorModifiers(this.func_110148_a(SharedMonsterAttributes.field_188791_g), armorItemStack);
            this.applyArmorModifiers(this.func_110148_a(SharedMonsterAttributes.field_189429_h), armorItemStack);
        }
    }

    @Override
    public void setArmorItemStack(@Nonnull ItemStack armorItemStack) {
        if (armorItemStack != this.field_70180_af.func_187225_a(DataHelper.ARMOR_ITEM)) {
            this.field_70180_af.func_187227_b(DataHelper.ARMOR_ITEM, (Object)armorItemStack);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, armorItemStack);
            this.func_184642_a(EntityEquipmentSlot.MAINHAND, 0.0f);
            this.func_184201_a(EntityEquipmentSlot.HEAD, armorItemStack);
            this.func_184642_a(EntityEquipmentSlot.HEAD, 0.0f);
            this.func_184201_a(EntityEquipmentSlot.CHEST, armorItemStack);
            this.func_184642_a(EntityEquipmentSlot.CHEST, 0.0f);
            this.func_184201_a(EntityEquipmentSlot.LEGS, armorItemStack);
            this.func_184642_a(EntityEquipmentSlot.LEGS, 0.0f);
            this.func_184201_a(EntityEquipmentSlot.FEET, armorItemStack);
            this.func_184642_a(EntityEquipmentSlot.FEET, 0.0f);
        }
    }

    @Override
    @Nonnull
    public ItemStack getArmorItemStack() {
        return (ItemStack)this.field_70180_af.func_187225_a(DataHelper.ARMOR_ITEM);
    }

    @Override
    public boolean getHasArmor() {
        return !this.getArmorItemStack().func_190926_b();
    }

    @Override
    public boolean getHasChest() {
        return (Boolean)this.field_70180_af.func_187225_a(DataHelper.HAS_CHEST);
    }

    @Override
    public void setHasChest(boolean value) {
        this.field_70180_af.func_187227_b(DataHelper.HAS_CHEST, (Object)value);
        if (!value) {
            this.field_70180_af.func_187227_b(DataHelper.CHEST_TYPE, (Object)ItemStack.field_190927_a);
        }
    }

    @Override
    public void setChestType(@Nonnull ItemStack stack) {
        ItemStack chestType = stack.func_77946_l();
        if (!chestType.func_190926_b()) {
            chestType.func_190920_e(1);
        }
        this.field_70180_af.func_187227_b(DataHelper.CHEST_TYPE, (Object)chestType);
    }

    @Override
    public Item getChestType() {
        ItemStack chestType = (ItemStack)this.field_70180_af.func_187225_a(DataHelper.CHEST_TYPE);
        return chestType.func_190926_b() ? null : chestType.func_77973_b();
    }

    @Override
    @Nonnull
    public InventoryBasic getInventory() {
        return this.inventory;
    }

    @Override
    public void setInventoryItem(int index, @Nonnull ItemStack itemStack) {
        if (index >= 0 && index < this.inventory.func_70302_i_()) {
            this.inventory.func_70299_a(index, itemStack);
        } else {
            WolfArmorMod.getLogger().log(Level.ERROR, String.format("Invalid slot: %d", index));
        }
    }

    @Override
    public void equipArmor(@Nonnull ItemStack armorItemStack) {
        if (this.canEquipItem(armorItemStack)) {
            this.inventory.func_70299_a(0, armorItemStack);
        }
    }

    @Override
    public boolean canEquipItem(@Nonnull ItemStack armorItemStack) {
        return armorItemStack.func_190926_b() || !this.getHasArmor() && armorItemStack.func_77973_b() instanceof ItemWolfArmor;
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        super.func_70645_a(damageSource);
        this.dropEquipment();
    }

    @Override
    public void dropEquipment() {
        if (this.getHasArmor()) {
            ItemStack armorItemStack = this.getArmorItemStack();
            if (!this.func_130014_f_().field_72995_K) {
                this.func_70099_a(armorItemStack, 0.0f);
            }
            this.equipArmor(ItemStack.field_190927_a);
        }
        this.dropChest();
    }

    @Override
    public void dropInventoryContents() {
        for (int slotIndex = 1; slotIndex <= this.getMaxSizeInventory() - 1; ++slotIndex) {
            ItemStack stackInSlot = this.inventory.func_70301_a(slotIndex);
            if (stackInSlot.func_190926_b()) continue;
            if (!this.func_130014_f_().field_72995_K) {
                this.func_70099_a(stackInSlot, 0.0f);
            }
            this.setInventoryItem(slotIndex, ItemStack.field_190927_a);
        }
    }

    @Override
    protected void func_70675_k(float damage) {
        ItemStack stackInSlot;
        if (this.getHasArmor() && !(stackInSlot = this.inventory.func_70301_a(0)).func_190926_b()) {
            stackInSlot.func_77972_a((int)Math.ceil(damage), (EntityLivingBase)this);
            if (stackInSlot.func_190916_E() == 0) {
                ItemStack particleStack = stackInSlot.func_77946_l();
                particleStack.func_190920_e(1);
                this.equipArmor(ItemStack.field_190927_a);
                this.func_70669_a(particleStack);
            }
        }
    }

    @Override
    public void dropChest() {
        if (this.getHasChest()) {
            this.dropInventoryContents();
            if (!this.func_130014_f_().field_72995_K) {
                Item chestItem = this.getChestType();
                this.func_70099_a(new ItemStack(chestItem == null ? Item.func_150898_a((Block)Blocks.field_150486_ae) : chestItem, 1), 0.0f);
            }
            this.setHasChest(false);
        }
    }

    @Inject(method={"attackEntityAsMob"}, at={@At(value="HEAD")}, cancellable=true)
    private void onAttackEntityAsMob(Entity entityIn, CallbackInfoReturnable<Boolean> cir) {
        boolean atkFlag;
        float damage = (int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int knockback = 0;
        if (entityIn instanceof EntityLivingBase) {
            damage += EnchantmentHelper.func_152377_a((ItemStack)this.getArmorItemStack(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            knockback += EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_180313_o, (EntityLivingBase)((EntityLivingBase)this));
        }
        if (atkFlag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)((EntityLivingBase)this)), damage)) {
            int fireAspect;
            if (knockback > 0) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)knockback * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= (double)0.6f;
                this.field_70179_y *= (double)0.6f;
            }
            if ((fireAspect = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_77334_n, (EntityLivingBase)((EntityLivingBase)this))) > 0) {
                entityIn.func_70015_d(fireAspect * 4);
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        cir.setReturnValue(atkFlag);
        cir.cancel();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onConstructed(CallbackInfo ci) {
        this.inventoryInit();
    }

    @Inject(method={"entityInit"}, at={@At(value="RETURN")})
    private void onEntityInit(CallbackInfo ci) {
        this.field_70180_af.func_187214_a(DataHelper.HAS_CHEST, (Object)false);
        this.field_70180_af.func_187214_a(DataHelper.ARMOR_ITEM, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(DataHelper.CHEST_TYPE, (Object)ItemStack.field_190927_a);
    }

    @Inject(method={"writeEntityToNBT"}, at={@At(value="RETURN")})
    private void onWriteEntityToNBT(@Nonnull NBTTagCompound compound, CallbackInfo ci) {
        boolean hasChest = this.getHasChest();
        compound.func_74757_a("HasChest", hasChest);
        if (hasChest) {
            ItemStack chestInSlot = (ItemStack)this.field_70180_af.func_187225_a(DataHelper.CHEST_TYPE);
            NBTTagCompound chestItem = new NBTTagCompound();
            chestInSlot.func_77955_b(chestItem);
            compound.func_74782_a("ChestType", (NBTBase)chestItem);
            NBTTagList inventoryItems = new NBTTagList();
            InventoryBasic inventory = this.getInventory();
            for (byte slotIndex = 0; slotIndex < inventory.func_70302_i_(); slotIndex = (byte)((byte)(slotIndex + 1))) {
                ItemStack stackInSlot = inventory.func_70301_a((int)slotIndex);
                if (stackInSlot.func_190926_b()) continue;
                NBTTagCompound stackInSlotTags = new NBTTagCompound();
                stackInSlotTags.func_74774_a("Slot", slotIndex);
                stackInSlot.func_77955_b(stackInSlotTags);
                inventoryItems.func_74742_a((NBTBase)stackInSlotTags);
            }
            compound.func_74782_a("Inventory", (NBTBase)inventoryItems);
        }
        if (this.getHasArmor()) {
            ItemStack armorItemStack = this.getArmorItemStack();
            if (!armorItemStack.func_190926_b()) {
                NBTTagCompound armorItemTag = armorItemStack.func_77955_b(new NBTTagCompound());
                compound.func_74782_a("ArmorItem", (NBTBase)armorItemTag);
            } else {
                compound.func_82580_o("ArmorItem");
            }
        }
    }

    @Inject(method={"readEntityFromNBT"}, at={@At(value="RETURN")})
    private void onReadEntityFromNBT(@Nonnull NBTTagCompound compound, CallbackInfo ci) {
        NBTTagCompound armorTags;
        NBTTagCompound capabilities;
        if (compound.func_74764_b("ForgeCaps") && (capabilities = compound.func_74775_l("ForgeCaps")).func_74764_b("wolfarmor:wolf_armor")) {
            this.processLegacyDataTags(capabilities.func_74775_l("wolfarmor:wolf_armor"));
            return;
        }
        boolean hasChest = compound.func_74767_n("HasChest");
        this.setHasChest(hasChest);
        if (hasChest) {
            this.inventoryInit();
            ItemStack chestTypeStack = new ItemStack(compound.func_74775_l("ChestType"));
            this.field_70180_af.func_187227_b(DataHelper.CHEST_TYPE, (Object)chestTypeStack);
            NBTTagList inventoryTagList = compound.func_150295_c("Inventory", 10);
            for (int index = 0; index < inventoryTagList.func_74745_c(); ++index) {
                NBTTagCompound compoundTagAt = inventoryTagList.func_150305_b(index);
                byte slotIndex = compoundTagAt.func_74771_c("Slot");
                if (slotIndex >= 0 && slotIndex < this.inventory.func_70302_i_()) {
                    this.inventory.func_70299_a((int)slotIndex, new ItemStack(compoundTagAt));
                    continue;
                }
                WolfArmorMod.getLogger().log(Level.WARN, String.format("[NBT LOAD] Discarded invalid slot information at index %d", slotIndex));
            }
        }
        if (!(armorTags = compound.func_74775_l("ArmorItem")).func_82582_d()) {
            ItemStack armorItemStack = new ItemStack(armorTags);
            this.equipArmor(armorItemStack);
        }
    }

    @Inject(method={"processInteract"}, at={@At(value="HEAD")}, cancellable=true)
    private void onProcessInteract(EntityPlayer player, EnumHand hand, CallbackInfoReturnable<Boolean> cir) {
        if (this.func_70631_g_() || !this.func_70909_n() || !this.func_152114_e((EntityLivingBase)player)) {
            return;
        }
        if (player.func_70093_af()) {
            this.openWolfInventory(player);
            cir.setReturnValue(true);
            cir.cancel();
        } else {
            ItemStack itemInHand = player.func_184586_b(hand);
            if (!itemInHand.func_190926_b()) {
                boolean isWolfChestEnabled = WolfArmorMod.getConfiguration().getIsWolfChestEnabled();
                if (isWolfChestEnabled && !this.getHasChest() && OreDictHelper.isOre(false, "chestWood", itemInHand)) {
                    if (!this.func_130014_f_().field_72995_K) {
                        this.playEquipSound(itemInHand);
                        this.setHasChest(true);
                        this.setChestType(itemInHand);
                        if (!player.field_71075_bZ.field_75098_d) {
                            itemInHand.func_190918_g(1);
                        }
                        if (player instanceof EntityPlayerMP) {
                            ((WolfArmorTrigger)Criteria.EQUIP_WOLF_CHEST).trigger((EntityPlayerMP)player, (Entity)((EntityWolf)this));
                        }
                    }
                    cir.setReturnValue(true);
                    cir.cancel();
                } else if (Items.isValidWolfArmor(itemInHand)) {
                    this.openWolfInventory(player);
                    cir.setReturnValue(true);
                    cir.cancel();
                }
            }
        }
    }

    private void applyArmorModifiers(@Nullable IAttributeInstance instance, @Nonnull ItemStack stack) {
        if (instance == null) {
            return;
        }
        instance.func_188479_b(IItemWolfArmor.ARMOR_UUID);
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemWolfArmor)) {
            return;
        }
        ItemWolfArmor armorItem = (ItemWolfArmor)stack.func_77973_b();
        Multimap<String, AttributeModifier> map = armorItem.getAttributeModifiers(EntityEquipmentSlot.CHEST, stack);
        if (map.containsKey((Object)instance.func_111123_a().func_111108_a())) {
            map.get((Object)instance.func_111123_a().func_111108_a()).forEach(arg_0 -> ((IAttributeInstance)instance).func_111121_a(arg_0));
        }
    }

    private void inventoryInit() {
        ContainerHorseChest inventoryExisting = this.inventory;
        this.inventory = new ContainerHorseChest("inventory.wolfarmor.wolf", this.getMaxSizeInventory());
        String customWolfName = this.func_95999_t();
        if (!customWolfName.isEmpty()) {
            this.inventory.func_110133_a(customWolfName);
        }
        if (inventoryExisting != null) {
            inventoryExisting.func_110132_b((IInventoryChangedListener)this);
            int slotCount = Math.min(this.inventory.func_70302_i_(), inventoryExisting.func_70302_i_());
            for (int slotIndex = 0; slotIndex < slotCount; ++slotIndex) {
                ItemStack stackInSlot = inventoryExisting.func_70301_a(slotIndex);
                if (stackInSlot.func_190926_b()) continue;
                this.inventory.func_70299_a(slotIndex, stackInSlot.func_77946_l());
            }
        }
        this.inventory.func_110134_a((IInventoryChangedListener)this);
        this.inventory.func_70296_d();
    }

    private void playEquipSound(@Nonnull ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return;
        }
        SoundEvent sound = null;
        if (OreDictHelper.isOre(false, "chestWood", itemStack)) {
            sound = SoundEvents.field_187665_Y;
        }
        if (sound != null) {
            this.func_184185_a(sound, 1.0f, (this.func_70681_au().nextFloat() - this.func_70681_au().nextFloat()) * 0.2f + 1.0f);
        }
    }

    private void openWolfInventory(@Nonnull EntityPlayer player) {
        if (!this.func_130014_f_().field_72995_K) {
            this.func_70907_r().func_75270_a(true);
            player.openGui((Object)WolfArmorMod.getInstance(), this.func_145782_y(), this.func_130014_f_(), MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v));
        }
    }

    private void processLegacyDataTags(@Nonnull NBTTagCompound compound) {
        NBTTagCompound armorTags;
        WolfArmorMod.getLogger().log(Level.INFO, "[NBT LOAD] Updating capable wolf to mixin wolf...");
        boolean hasChest = compound.func_74767_n("hasChest");
        this.setHasChest(hasChest);
        if (hasChest) {
            this.inventoryInit();
            this.field_70180_af.func_187227_b(DataHelper.CHEST_TYPE, (Object)new ItemStack((Block)Blocks.field_150486_ae, 1));
            NBTTagList inventoryTagList = compound.func_150295_c("inventory", 10);
            for (int index = 0; index < inventoryTagList.func_74745_c(); ++index) {
                NBTTagCompound compoundTagAt = inventoryTagList.func_150305_b(index);
                byte slotIndex = compoundTagAt.func_74771_c("slot");
                if (slotIndex >= 0 && slotIndex < this.inventory.func_70302_i_()) {
                    this.inventory.func_70299_a((int)slotIndex, new ItemStack(compoundTagAt));
                    continue;
                }
                WolfArmorMod.getLogger().log(Level.WARN, String.format("[NBT LOAD] Discarded invalid slot information at index %d", slotIndex));
            }
        }
        if (!(armorTags = compound.func_74775_l("armorItem")).func_82582_d()) {
            ItemStack armorItemStack = new ItemStack(armorTags);
            this.equipArmor(armorItemStack);
        }
    }

    static {
        DataHelper.HAS_CHEST = EntityDataManager.func_187226_a(EntityWolf.class, (DataSerializer)DataSerializers.field_187198_h);
        DataHelper.ARMOR_ITEM = EntityDataManager.func_187226_a(EntityWolf.class, (DataSerializer)DataSerializers.field_187196_f);
        DataHelper.CHEST_TYPE = EntityDataManager.func_187226_a(EntityWolf.class, (DataSerializer)DataSerializers.field_187196_f);
    }
}

