/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.commands;

import net.minecraft.command.CommandException;
import net.minecraft.command.WrongUsageException;

public interface ICommandTask {
    public static final String DELIMITER = " ";

    public static String enclosedArg(String arg) {
        return "<" + arg + ">";
    }

    public static String[] enclosedArgs(String ... args) {
        String[] enclosedArgs = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            enclosedArgs[i] = ICommandTask.enclosedArg(args[i]);
        }
        return enclosedArgs;
    }

    public String getName();

    default public String getUsage() {
        return this.getName() + DELIMITER + String.join((CharSequence)DELIMITER, ICommandTask.enclosedArgs(this.getUsageArgs()));
    }

    public String[] getUsageArgs();

    default public boolean complyWith(String taskName) {
        return this.getName().equals(taskName);
    }

    default public boolean complyWith(String taskName, String[] args) throws CommandException {
        boolean result = this.complyWith(taskName);
        if (result && this.getUsageArgs().length != args.length) {
            throw new WrongUsageException(this.getUsage(), new Object[0]);
        }
        return result;
    }
}

