/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.items;

import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.materials.RepairMatcher;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public abstract class DamageableItem
extends ForgeItem {
    protected final UnitId repair;
    private final boolean repairCostGrow;

    public DamageableItem(ForgeMod mod, UnitConfig config, String name, CreativeTabs tab, int durability, UnitId repair) {
        super(mod, config, name, tab);
        durability = ForgeConfig.getInt(this.getConfig(), this.getUnitCategory(), "durability", durability, ForgeBounds.DURABILITY.getIntBounds(), "Defines durability of the item.");
        this.repair = ForgeConfig.getUnitId(this.getConfig(), this.getUnitCategory(), "repair", repair, "Defines the material for repair on an anvil.");
        this.repairCostGrow = ForgeConfig.getBool(this.getConfig(), this.getUnitCategory(), "repairCostGrow", false, "If true, repair cost will grow for this item after each repair on an anvil.");
        this.func_77656_e(durability);
        this.func_77625_d(1);
    }

    @SubscribeEvent
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        for (ItemStack stack : new ItemStack[]{event.getLeft(), event.getRight()}) {
            Item item = stack.func_77973_b();
            if (!(item instanceof DamageableItem) || ((DamageableItem)item).isRepairCostGrow()) continue;
            DamageableItem.removeRepairPenaltyFor(stack);
        }
    }

    public static void removeRepairPenaltyFor(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o("RepairCost");
        }
    }

    public boolean func_82789_a(ItemStack stack, ItemStack material) {
        return RepairMatcher.from(material).matches(this.repair);
    }

    public boolean isRepairCostGrow() {
        return this.repairCostGrow;
    }

    public Percentage getWearoutPercentage(ItemStack stack) {
        return Percentage.from(stack.func_77952_i(), stack.func_77958_k());
    }
}

