/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.gui.beastiary.lists;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.AssetManager;
import com.lycanitesmobs.client.gui.beastiary.BeastiaryScreen;
import com.lycanitesmobs.client.gui.beastiary.lists.CreatureFilterList;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.Subspecies;
import com.lycanitesmobs.core.info.Variant;
import com.lycanitesmobs.core.network.MessageSummonSetSelection;
import com.lycanitesmobs.core.pets.PetEntry;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraftforge.fml.client.GuiScrollingList;

public class CreatureList
extends GuiScrollingList {
    private Type listType;
    private BeastiaryScreen parentGui;
    private CreatureFilterList filterList;
    private Map<Integer, CreatureInfo> creatureList = new HashMap<Integer, CreatureInfo>();
    private Map<Integer, PetEntry> petList = new HashMap<Integer, PetEntry>();
    private boolean releaseRefresh;

    public CreatureList(Type listType, BeastiaryScreen parentGui, CreatureFilterList filterList, int width, int height, int top, int bottom, int x) {
        super(Minecraft.func_71410_x(), width, height, top, bottom, x, 24, width, height);
        this.listType = listType;
        this.parentGui = parentGui;
        this.filterList = filterList;
        if (this.filterList != null) {
            this.filterList.addFilteredList(this);
        }
        this.refreshList();
    }

    public void refreshList() {
        block6: {
            int creatureIndex;
            block5: {
                this.creatureList.clear();
                this.petList.clear();
                creatureIndex = 0;
                if (this.listType != Type.KNOWLEDGE && this.listType != Type.SUMMONABLE) break block5;
                ArrayList<String> creatures = new ArrayList<String>(this.parentGui.playerExt.getBeastiary().creatureKnowledgeList.keySet());
                creatures.sort(Collator.getInstance(new Locale("US")));
                for (String creatureName : creatures) {
                    CreatureInfo creatureInfo = CreatureManager.getInstance().getCreature(creatureName.toLowerCase());
                    if (this.listType == Type.SUMMONABLE && !creatureInfo.isSummonable() || creatureInfo == null || this.filterList != null && !this.filterList.canListCreature(creatureInfo, this.listType)) continue;
                    this.creatureList.put(creatureIndex++, creatureInfo);
                }
                break block6;
            }
            if (this.listType != Type.PET && this.listType != Type.MOUNT && this.listType != Type.FAMILIAR) break block6;
            String petType = "pet";
            if (this.listType == Type.MOUNT) {
                petType = "mount";
            } else if (this.listType == Type.FAMILIAR) {
                petType = "familiar";
            }
            List<PetEntry> pets = this.parentGui.playerExt.petManager.createEntryListByType(petType);
            pets.sort(Comparator.comparing(PetEntry::getDisplayName));
            for (PetEntry petEntry : pets) {
                CreatureInfo creatureInfo = petEntry.getCreatureInfo();
                if (creatureInfo == null || this.filterList != null && !this.filterList.canListCreature(creatureInfo, this.listType)) continue;
                this.petList.put(creatureIndex++, petEntry);
            }
        }
    }

    protected int getSize() {
        if (this.listType == Type.KNOWLEDGE || this.listType == Type.SUMMONABLE) {
            return this.creatureList.size();
        }
        if (this.listType == Type.PET || this.listType == Type.MOUNT || this.listType == Type.FAMILIAR) {
            return this.petList.size();
        }
        return 0;
    }

    protected void elementClicked(int index, boolean doubleClick) {
        this.selectedIndex = index;
        if (this.listType == Type.KNOWLEDGE) {
            this.parentGui.playerExt.selectedCreature = this.creatureList.get(index);
            this.parentGui.playerExt.selectedSubspecies = 0;
            this.parentGui.playerExt.selectedVariant = 0;
        } else if (this.listType == Type.SUMMONABLE) {
            int variantId;
            this.parentGui.playerExt.getSelectedSummonSet().setSummonType(this.creatureList.get(index).getName());
            Subspecies subspecies = this.creatureList.get(index).getSubspecies(this.parentGui.playerExt.getSelectedSummonSet().getSubspecies());
            this.parentGui.playerExt.getSelectedSummonSet().setSubspecies(subspecies.index);
            Variant variant = subspecies.getVariant(this.parentGui.playerExt.getSelectedSummonSet().getVariant());
            int n = variantId = variant != null ? variant.index : 0;
            if (!this.parentGui.playerExt.getBeastiary().hasKnowledgeRank(this.creatureList.get(index).getName(), 2)) {
                variantId = 0;
            }
            this.parentGui.playerExt.getSelectedSummonSet().setVariant(variantId);
            this.parentGui.playerExt.sendSummonSetToServer((byte)this.parentGui.playerExt.selectedSummonSet);
            MessageSummonSetSelection message = new MessageSummonSetSelection(this.parentGui.playerExt);
            LycanitesMobs.packetHandler.sendToServer(message);
        } else if (this.listType == Type.PET || this.listType == Type.MOUNT || this.listType == Type.FAMILIAR) {
            this.parentGui.playerExt.selectedPet = this.petList.get(index);
        }
    }

    protected boolean isSelected(int index) {
        if (this.listType == Type.KNOWLEDGE) {
            return this.parentGui.playerExt.selectedCreature != null && this.parentGui.playerExt.selectedCreature.equals(this.creatureList.get(index));
        }
        if (this.listType == Type.SUMMONABLE) {
            return this.parentGui.playerExt.getSelectedSummonSet().getCreatureInfo() != null && this.parentGui.playerExt.getSelectedSummonSet().getCreatureInfo().equals(this.creatureList.get(index));
        }
        if (this.listType == Type.PET || this.listType == Type.MOUNT || this.listType == Type.FAMILIAR) {
            return this.parentGui.playerExt.selectedPet != null && this.parentGui.playerExt.selectedPet.equals(this.petList.get(index));
        }
        return false;
    }

    protected void drawBackground() {
        if ((this.listType == Type.PET || this.listType == Type.MOUNT || this.listType == Type.FAMILIAR) && this.parentGui.playerExt.selectedPet != null && this.releaseRefresh != this.parentGui.playerExt.selectedPet.releaseEntity) {
            this.releaseRefresh = this.parentGui.playerExt.selectedPet.releaseEntity;
            this.refreshList();
        }
    }

    protected int getContentHeight() {
        return this.getSize() * this.slotHeight;
    }

    protected void drawSlot(int index, int boxRight, int boxTop, int boxBottom, Tessellator tessellator) {
        if (this.listType == Type.KNOWLEDGE || this.listType == Type.SUMMONABLE) {
            CreatureInfo creatureInfo = this.creatureList.get(index);
            if (creatureInfo == null) {
                return;
            }
            int nameY = boxTop + 6;
            if (this.listType == Type.SUMMONABLE) {
                nameY = boxTop + 2;
            }
            this.parentGui.getFontRenderer().func_78276_b(creatureInfo.getTitle(), this.left + 20, nameY, 0xFFFFFF);
            if (this.listType == Type.SUMMONABLE) {
                this.parentGui.drawLevel(creatureInfo, AssetManager.getTexture("GUIPetLevel"), this.left + 18, boxTop + 10);
            }
            if (creatureInfo.getIcon() != null) {
                this.parentGui.drawTexture(creatureInfo.getIcon(), this.left + 2, boxTop + 2, 0.0f, 1.0f, 1.0f, 16.0f, 16.0f);
            }
        } else {
            PetEntry petEntry = this.petList.get(index);
            if (petEntry == null) {
                return;
            }
            int nameY = boxTop + 6;
            if (this.listType == Type.PET || this.listType == Type.MOUNT) {
                nameY = boxTop + 2;
            }
            this.parentGui.getFontRenderer().func_78276_b(petEntry.getDisplayName(), this.left + 20, nameY, 0xFFFFFF);
            if (this.listType == Type.PET || this.listType == Type.MOUNT) {
                this.parentGui.drawLevel(petEntry.getCreatureInfo(), AssetManager.getTexture("GUIPetLevel"), this.left + 18, boxTop + 10);
            }
            if (petEntry.getCreatureInfo().getIcon() != null) {
                this.parentGui.drawTexture(petEntry.getCreatureInfo().getIcon(), this.left + 2, boxTop + 2, 0.0f, 1.0f, 1.0f, 16.0f, 16.0f);
            }
        }
    }

    public void changeType(Type listType) {
        this.listType = listType;
        this.refreshList();
    }

    public static enum Type {
        KNOWLEDGE(0),
        SUMMONABLE(1),
        PET(2),
        MOUNT(3),
        FAMILIAR(4);

        public byte id;

        private Type(byte i) {
            this.id = i;
        }
    }
}

