/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.block;

import com.lycanitesmobs.GuiHandler;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.block.BlockBase;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.tileentity.TileEntityBase;
import com.lycanitesmobs.core.tileentity.TileEntityEquipmentForge;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockEquipmentForge
extends BlockBase
implements ITileEntityProvider {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public int level;

    public BlockEquipmentForge(ModInfo group, int level) {
        super(level <= 1 ? Material.field_151575_d : (level == 2 ? Material.field_151576_e : Material.field_151573_f));
        this.group = group;
        this.level = level;
        if (level <= 1) {
            this.blockName = "equipmentforge_lesser";
            this.setHarvestLevel("axe", 1);
            this.func_149672_a(SoundType.field_185848_a);
            this.func_149752_b(10.0f);
        } else if (level == 2) {
            this.blockName = "equipmentforge_greater";
            this.setHarvestLevel("pickaxe", 1);
            this.func_149672_a(SoundType.field_185851_d);
            this.func_149752_b(20.0f);
        } else {
            this.blockName = "equipmentforge_master";
            this.setHarvestLevel("pickaxe", 2);
            this.func_149672_a(SoundType.field_185852_e);
            this.func_149752_b(1000.0f);
        }
        this.setup();
        this.func_149711_c(5.0f);
        this.field_149758_A = true;
        this.func_149647_a(LycanitesMobs.blocksTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    @Override
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @Override
    public String func_149732_F() {
        return LanguageManager.translate(this.func_149739_a() + ".name");
    }

    @Override
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(this.getDescription(stack, world));
    }

    @Override
    public String getDescription(ItemStack itemStack, @Nullable World world) {
        return LanguageManager.translate(this.func_149739_a() + ".description");
    }

    @Override
    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.setDefaultFacing(world, pos, state);
        super.func_176213_c(world, pos, state);
    }

    protected void setDefaultFacing(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            IBlockState iblockstate = world.func_180495_p(pos.func_177978_c());
            IBlockState iblockstate1 = world.func_180495_p(pos.func_177968_d());
            IBlockState iblockstate2 = world.func_180495_p(pos.func_177976_e());
            IBlockState iblockstate3 = world.func_180495_p(pos.func_177974_f());
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && iblockstate.func_185913_b() && !iblockstate1.func_185913_b()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && iblockstate1.func_185913_b() && !iblockstate.func_185913_b()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && iblockstate2.func_185913_b() && !iblockstate3.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && iblockstate3.func_185913_b() && !iblockstate2.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
            world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity != null && tileEntity instanceof TileEntityBase) {
            ((TileEntityBase)tileEntity).onRemove();
        }
        super.func_180663_b(worldIn, pos, state);
        worldIn.func_175713_t(pos);
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int eventID, int eventParam) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        return tileEntity != null && tileEntity.func_145842_c(eventID, eventParam);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && playerIn != null) {
            playerIn.openGui((Object)LycanitesMobs.instance, (int)GuiHandler.GuiType.TILEENTITY.id, playerIn.func_130014_f_(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        TileEntityEquipmentForge tileEntityEquipmentForge = new TileEntityEquipmentForge();
        tileEntityEquipmentForge.setLevel(this.level);
        return tileEntityEquipmentForge;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }
}

