/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.dungeon.definition;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.dungeon.DungeonManager;
import com.lycanitesmobs.core.dungeon.definition.DungeonSector;
import com.lycanitesmobs.core.dungeon.definition.DungeonTheme;
import com.lycanitesmobs.core.helpers.JSONHelper;
import com.lycanitesmobs.core.info.ItemDrop;
import com.lycanitesmobs.core.spawner.MobSpawn;
import com.lycanitesmobs.core.spawner.condition.SpawnCondition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class DungeonSchematic {
    public String name = "";
    public boolean enabled = true;
    public int sectorCountMin = 30;
    public int sectorCountMax = 50;
    public double corridorToCorridorChance = 0.1;
    public double roomToRoomChance = 0.1;
    public List<SpawnCondition> conditions = new ArrayList<SpawnCondition>();
    public List<Biome> biomes = new ArrayList<Biome>();
    public List<String> themes = new ArrayList<String>();
    public List<String> entrances = new ArrayList<String>();
    public List<String> rooms = new ArrayList<String>();
    public List<String> corridors = new ArrayList<String>();
    public List<String> stairs = new ArrayList<String>();
    public List<String> towers = new ArrayList<String>();
    public List<String> bossRooms = new ArrayList<String>();
    public List<String> finishes = new ArrayList<String>();
    public List<MobSpawn> mobSpawns = new ArrayList<MobSpawn>();
    public Map<Integer, List<String>> lootTables = new HashMap<Integer, List<String>>();
    public List<ItemDrop> loot = new ArrayList<ItemDrop>();

    public void loadFromJSON(JsonObject json) {
        String jsonString;
        Iterator jsonIterator;
        Object jsonArray;
        this.name = json.get("name").getAsString().toLowerCase();
        if (json.has("enabled")) {
            this.enabled = json.get("enabled").getAsBoolean();
        }
        if (json.has("sectorCountMin")) {
            this.sectorCountMin = json.get("sectorCountMin").getAsInt();
        }
        if (json.has("sectorCountMax")) {
            this.sectorCountMax = json.get("sectorCountMax").getAsInt();
        }
        if (json.has("corridorToCorridorChance")) {
            this.corridorToCorridorChance = json.get("corridorToCorridorChance").getAsDouble();
        }
        if (json.has("roomToRoomChance")) {
            this.roomToRoomChance = json.get("roomToRoomChance").getAsDouble();
        }
        if (json.has("lootTables")) {
            jsonArray = json.get("lootTables").getAsJsonArray();
            jsonIterator = jsonArray.iterator();
            while (jsonIterator.hasNext()) {
                JsonObject lootTableJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                int level = -1;
                if (lootTableJson.has("level")) {
                    level = lootTableJson.get("level").getAsInt();
                }
                if (!this.lootTables.containsKey(level)) {
                    this.lootTables.put(level, new ArrayList());
                }
                this.lootTables.get(level).add(lootTableJson.get("id").getAsString());
            }
        }
        if (json.has("conditions")) {
            jsonArray = json.get("conditions").getAsJsonArray();
            jsonIterator = jsonArray.iterator();
            while (jsonIterator.hasNext()) {
                JsonObject conditionJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                SpawnCondition spawnCondition = SpawnCondition.createFromJSON(conditionJson);
                this.conditions.add(spawnCondition);
            }
        }
        if (json.has("biomes")) {
            this.biomes = JSONHelper.getBiomesFromTags(JSONHelper.getJsonStrings(json.get("biomes").getAsJsonArray()));
        }
        if (json.has("themes")) {
            for (JsonElement jsonElement : json.get("themes").getAsJsonArray()) {
                jsonString = jsonElement.getAsString().toLowerCase();
                if (this.themes.contains(jsonString)) continue;
                this.themes.add(jsonString);
            }
        }
        if (json.has("entrances")) {
            for (JsonElement jsonElement : json.get("entrances").getAsJsonArray()) {
                jsonString = jsonElement.getAsString().toLowerCase();
                if (this.entrances.contains(jsonString)) continue;
                this.entrances.add(jsonString);
            }
        }
        if (json.has("rooms")) {
            for (JsonElement jsonElement : json.get("rooms").getAsJsonArray()) {
                jsonString = jsonElement.getAsString().toLowerCase();
                if (this.rooms.contains(jsonString)) continue;
                this.rooms.add(jsonString);
            }
        }
        if (json.has("corridors")) {
            for (JsonElement jsonElement : json.get("corridors").getAsJsonArray()) {
                jsonString = jsonElement.getAsString().toLowerCase();
                if (this.corridors.contains(jsonString)) continue;
                this.corridors.add(jsonString);
            }
        }
        if (json.has("stairs")) {
            for (JsonElement jsonElement : json.get("stairs").getAsJsonArray()) {
                jsonString = jsonElement.getAsString().toLowerCase();
                if (this.stairs.contains(jsonString)) continue;
                this.stairs.add(jsonString);
            }
        }
        if (json.has("towers")) {
            for (JsonElement jsonElement : json.get("towers").getAsJsonArray()) {
                jsonString = jsonElement.getAsString().toLowerCase();
                if (this.towers.contains(jsonString)) continue;
                this.towers.add(jsonString);
            }
        }
        if (json.has("bossRooms")) {
            for (JsonElement jsonElement : json.get("bossRooms").getAsJsonArray()) {
                jsonString = jsonElement.getAsString().toLowerCase();
                if (this.bossRooms.contains(jsonString)) continue;
                this.bossRooms.add(jsonString);
            }
        } else {
            this.bossRooms.addAll(this.rooms);
        }
        if (json.has("finishes")) {
            for (JsonElement jsonElement : json.get("finishes").getAsJsonArray()) {
                jsonString = jsonElement.getAsString().toLowerCase();
                if (this.finishes.contains(jsonString)) continue;
                this.finishes.add(jsonString);
            }
        }
        if (json.has("mobSpawns")) {
            jsonArray = json.get("mobSpawns").getAsJsonArray();
            jsonIterator = jsonArray.iterator();
            while (jsonIterator.hasNext()) {
                JsonObject mobSpawnJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                MobSpawn mobSpawn = MobSpawn.createFromJSON(mobSpawnJson);
                if (mobSpawn == null) continue;
                this.mobSpawns.add(mobSpawn);
            }
        }
        if (json.has("loot")) {
            JsonArray lootEntries = json.getAsJsonArray("loot");
            for (JsonElement mobDropJson : lootEntries) {
                ItemDrop itemDrop = ItemDrop.createFromJSON(mobDropJson.getAsJsonObject());
                if (itemDrop == null) continue;
                this.loot.add(itemDrop);
            }
        }
    }

    public boolean canBuild(World world, BlockPos pos) {
        if (!this.enabled) {
            return false;
        }
        for (SpawnCondition condition : this.conditions) {
            if (condition.isMet(world, null, pos)) continue;
            return false;
        }
        return this.isValidBiome(world.func_180494_b(pos));
    }

    public boolean isValidBiome(Biome biome) {
        if (this.biomes.isEmpty()) {
            return true;
        }
        return this.biomes.contains(biome);
    }

    public int getRandomSectorCount(Random random) {
        if (this.sectorCountMax <= this.sectorCountMin) {
            return this.sectorCountMin;
        }
        return this.sectorCountMin + random.nextInt(this.sectorCountMax - this.sectorCountMin + 1);
    }

    public DungeonSector getRandomSector(String type, Random random) {
        List<String> sectorList = "entrance".equalsIgnoreCase(type) ? this.entrances : ("corridor".equalsIgnoreCase(type) ? this.corridors : ("stairs".equalsIgnoreCase(type) ? this.stairs : ("tower".equalsIgnoreCase(type) ? this.towers : ("bossRoom".equalsIgnoreCase(type) ? this.bossRooms : ("finish".equalsIgnoreCase(type) ? this.finishes : this.rooms)))));
        ArrayList<DungeonSector> sectors = new ArrayList<DungeonSector>();
        int totalWeights = 0;
        for (String sectorName : sectorList) {
            DungeonSector sector = DungeonManager.getInstance().getSector(sectorName);
            if (sector == null || sector.weight <= 0) continue;
            sectors.add(sector);
            totalWeights += sector.weight;
        }
        if (sectors.isEmpty()) {
            LycanitesMobs.logWarning("Dungeon", "Unable to find any " + type + " sectors for the dungeon: " + this.name);
            return null;
        }
        if (sectors.size() == 1) {
            return (DungeonSector)sectors.get(0);
        }
        int randomWeight = random.nextInt(totalWeights) + 1;
        int searchedWeight = 0;
        for (DungeonSector sector : sectors) {
            if (randomWeight <= sector.weight + searchedWeight) {
                return sector;
            }
            searchedWeight += sector.weight;
        }
        return (DungeonSector)sectors.get(sectors.size() - 1);
    }

    public String getNextConnectingSector(String parentType, Random random) {
        if ("room".equalsIgnoreCase(parentType)) {
            return random.nextDouble() <= this.roomToRoomChance ? "room" : "corridor";
        }
        if ("corridor".equalsIgnoreCase(parentType)) {
            return random.nextDouble() <= this.corridorToCorridorChance ? "corridor" : "room";
        }
        if ("entrance".equalsIgnoreCase(parentType)) {
            return random.nextBoolean() ? "corridor" : "room";
        }
        return "room";
    }

    public DungeonTheme getRandomTheme(Random random) {
        ArrayList<DungeonTheme> themes = new ArrayList<DungeonTheme>();
        for (String themeName : this.themes) {
            DungeonTheme dungeonTheme = DungeonManager.getInstance().getTheme(themeName);
            if (dungeonTheme == null) continue;
            themes.add(dungeonTheme);
        }
        if (themes.isEmpty()) {
            LycanitesMobs.logWarning("Dungeon", "No Dungeon Themes Found For " + this.name);
            return null;
        }
        if (themes.size() == 1) {
            return (DungeonTheme)themes.get(0);
        }
        return (DungeonTheme)themes.get(random.nextInt(themes.size()));
    }

    public MobSpawn getRandomMobSpawn(int level, boolean boss, Random random) {
        int levelMin = level;
        int levelMax = level;
        if (level < 0) {
            levelMax = -level * 2;
            levelMin = levelMax - 1;
        }
        int totalWeights = 0;
        ArrayList<MobSpawn> mobSpawns = new ArrayList<MobSpawn>();
        for (MobSpawn mobSpawn : this.mobSpawns) {
            if (mobSpawn.dungeonBoss != boss || mobSpawn.dungeonLevelMin >= 0 && mobSpawn.dungeonLevelMin > levelMax || mobSpawn.dungeonLevelMax >= 0 && mobSpawn.dungeonLevelMax < levelMin || mobSpawn.getWeight() <= 0) continue;
            mobSpawns.add(mobSpawn);
            totalWeights += mobSpawn.getWeight();
        }
        if (totalWeights <= 0) {
            return null;
        }
        int randomWeight = 1;
        if (totalWeights > 1) {
            randomWeight = random.nextInt(totalWeights);
        }
        int searchWeight = 0;
        MobSpawn chosenMobSpawn = null;
        Iterator iterator = mobSpawns.iterator();
        while (iterator.hasNext()) {
            MobSpawn mobSpawn;
            chosenMobSpawn = mobSpawn = (MobSpawn)iterator.next();
            if (mobSpawn.getWeight() + searchWeight > randomWeight) break;
            searchWeight += mobSpawn.getWeight();
        }
        return chosenMobSpawn;
    }

    public ResourceLocation getRandomLootTable(int level, Random random) {
        if (level < 0) {
            level = -level * 2;
        }
        ArrayList possibleLootTables = new ArrayList();
        if (this.lootTables.containsKey(-1)) {
            possibleLootTables.addAll(this.lootTables.get(-1));
        }
        for (int i = 0; i <= level; ++i) {
            if (!this.lootTables.containsKey(i)) continue;
            possibleLootTables.addAll(this.lootTables.get(i));
        }
        if (possibleLootTables.isEmpty()) {
            return null;
        }
        if (possibleLootTables.size() == 1) {
            return new ResourceLocation((String)possibleLootTables.get(0));
        }
        return new ResourceLocation((String)possibleLootTables.get(random.nextInt(possibleLootTables.size())));
    }

    public List<ItemStack> getRandomLoot(Random random) {
        ArrayList<ItemStack> loot = new ArrayList<ItemStack>();
        for (ItemDrop itemDrop : this.loot) {
            int quantity;
            boolean addLoot;
            if (itemDrop.chance <= 0.0f) continue;
            boolean bl = addLoot = itemDrop.chance >= 1.0f;
            if (!addLoot) {
                boolean bl2 = addLoot = (double)itemDrop.chance <= random.nextDouble();
            }
            if (!addLoot || (quantity = itemDrop.getQuantity(random, 0, 1)) <= 0) continue;
            loot.add(new ItemStack(itemDrop.getItemStack().func_77973_b(), itemDrop.getItemStack().func_77960_j(), quantity));
        }
        return loot;
    }
}

