/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.creature.EntityAsmodeus;
import com.lycanitesmobs.core.entity.creature.EntityCacodemon;
import com.lycanitesmobs.core.entity.creature.EntityTrite;
import com.lycanitesmobs.core.entity.goals.actions.AttackRangedGoal;
import com.lycanitesmobs.core.entity.projectile.EntityHellShield;
import com.lycanitesmobs.core.info.CreatureManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityAstaroth
extends TameableCreatureEntity
implements IMob {
    public EntityAstaroth(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.hasAttackSound = false;
        this.solidCollision = false;
        this.setupMob();
        this.hitAreaWidthScale = 1.5f;
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackRangedGoal(this).setSpeed(1.0).setRange(40.0f).setMinChaseDistance(16.0f).setChaseTime(-1));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.updateTick % 20L == 0L && this.getMasterTarget() != null && this.getMasterTarget() instanceof EntityAsmodeus && ((BaseCreatureEntity)this.getMasterTarget()).getBattlePhase() > 0) {
            EntityHellShield projectile = new EntityHellShield(this.func_130014_f_(), (EntityLivingBase)this);
            projectile.setProjectileScale(3.0f);
            projectile.field_70163_u -= (double)this.field_70131_O * 0.35;
            double dX = this.getMasterTarget().field_70165_t - this.field_70165_t;
            double dY = this.getMasterTarget().field_70163_u + (double)this.getMasterTarget().field_70131_O * 0.75 - projectile.field_70163_u;
            double dZ = this.getMasterTarget().field_70161_v - this.field_70161_v;
            double distance = MathHelper.func_76133_a((double)(dX * dX + dZ * dZ)) * 0.1f;
            float velocity = 0.8f;
            projectile.func_70186_c(dX, dY + distance, dZ, velocity, 0.0f);
            this.func_130014_f_().func_72838_d((Entity)projectile);
        }
    }

    @Override
    public boolean canAttackEntity(EntityLivingBase target) {
        if (target instanceof EntityTrite || target instanceof EntityCacodemon || target instanceof EntityAsmodeus) {
            return false;
        }
        return super.canAttackEntity(target);
    }

    @Override
    public void attackRanged(Entity target, float range) {
        this.fireProjectile("devilstar", target, range, 0.0f, new Vec3d(0.0, (double)-2.8f, 0.0), 1.2f, 1.0f, 1.0f);
        super.attackRanged(target, range);
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        if (!this.func_130014_f_().field_72995_K && CreatureManager.getInstance().getCreature((String)"trite").enabled) {
            int j = 2 + this.field_70146_Z.nextInt(5) + this.func_130014_f_().func_175659_aa().func_151525_a() - 1;
            if (this.isTamed()) {
                j = 3;
            }
            for (int k = 0; k < j; ++k) {
                EntityTrite trite = (EntityTrite)CreatureManager.getInstance().getCreature("trite").createEntity(this.func_130014_f_());
                this.summonMinion((EntityLivingBase)trite, this.field_70146_Z.nextFloat() * 360.0f, 0.5);
                if (!this.isTamed()) continue;
                trite.setTemporary(100);
            }
        }
        super.func_70645_a(damageSource);
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 5;
    }
}

