/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupBoss;
import com.lycanitesmobs.api.IGroupHeavy;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.entity.goals.actions.abilities.StealthGoal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntitySpectre
extends TameableCreatureEntity
implements IMob,
IGroupHeavy {
    protected int pullRange = 6;
    protected int pullEnergy = 0;
    protected int pullEnergyMax = 40;
    protected int pullEnergyRecharge = 0;
    protected int pullEnergyRechargeMax = 80;
    protected boolean pullRecharging = true;

    public EntitySpectre(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.hasAttackSound = true;
        this.spawnsInWater = true;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextPriorityGoalIndex++, (EntityAIBase)new StealthGoal(this).setStealthTime(20).setStealthAttack(true).setStealthMove(true));
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackMeleeGoal(this).setLongMemory(true));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.pullRecharging && ++this.pullEnergyRecharge >= this.pullEnergyRechargeMax) {
                this.pullRecharging = false;
                this.pullEnergy = this.pullEnergyMax;
                this.pullEnergyRecharge = 0;
            }
            this.pullEnergy = Math.min(this.pullEnergy, this.pullEnergyMax);
            if (this.canPull()) {
                for (EntityLivingBase entity : this.getNearbyEntities(EntityLivingBase.class, null, this.pullRange)) {
                    if (entity == this || entity == this.func_184179_bs() || entity instanceof IGroupBoss || entity instanceof IGroupHeavy || entity.func_70644_a((Potion)ObjectManager.getEffect("weight")) || !this.canAttackEntity(entity)) continue;
                    EntityPlayerMP player = null;
                    if (entity instanceof EntityPlayerMP) {
                        player = (EntityPlayerMP)entity;
                        if (player.field_71075_bZ.field_75098_d) continue;
                    }
                    double xDist = this.field_70165_t - entity.field_70165_t;
                    double zDist = this.field_70161_v - entity.field_70161_v;
                    double xzDist = MathHelper.func_76133_a((double)(xDist * xDist + zDist * zDist));
                    double factor = 0.1;
                    double motionCap = 10.0;
                    if (entity.field_70159_w < motionCap && entity.field_70159_w > -motionCap && entity.field_70179_y < motionCap && entity.field_70179_y > -motionCap) {
                        entity.func_70024_g(xDist / xzDist * factor + entity.field_70159_w * factor, 0.0, zDist / xzDist * factor + entity.field_70179_y * factor);
                    }
                    if (player == null) continue;
                    player.field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity((Entity)entity));
                }
                if (--this.pullEnergy <= 0) {
                    this.pullRecharging = true;
                    this.pullEnergyRecharge = 0;
                }
            }
        }
        if (this.func_130014_f_().field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.func_130014_f_().func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    public boolean extraAnimation01() {
        if (this.func_130014_f_().field_72995_K) {
            return super.extraAnimation01();
        }
        return this.canPull();
    }

    public boolean canPull() {
        if (this.func_130014_f_().field_72995_K) {
            return this.extraAnimation01();
        }
        return !this.pullRecharging && this.hasAttackTarget() && this.func_70032_d((Entity)this.func_70638_az()) <= (float)(this.pullRange * 3);
    }

    @Override
    public boolean isFlying() {
        return true;
    }

    @Override
    public boolean isStrongSwimmer() {
        return true;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public boolean isDamageTypeApplicable(String type, DamageSource source, float damage) {
        if (type.equals("inWall")) {
            return false;
        }
        return super.isDamageTypeApplicable(type, source, damage);
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }
}

