/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity.creature;

import com.lycanitesmobs.core.entity.RideableCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.AttackMeleeGoal;
import com.lycanitesmobs.core.info.ElementInfo;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityWarg
extends RideableCreatureEntity {
    protected boolean leapedAbilityQueued = false;
    protected boolean leapedAbilityReady = false;

    public EntityWarg(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.hasAttackSound = true;
        this.spreadFire = false;
        this.canGrow = true;
        this.babySpawnChance = 0.1;
        this.setupMob();
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackMeleeGoal(this).setTargetClass(EntityPlayer.class).setLongMemory(false));
        this.field_70714_bg.func_75776_a(this.nextCombatGoalIndex++, (EntityAIBase)new AttackMeleeGoal(this));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.isTamed() && this.field_70122_E && !this.func_130014_f_().field_72995_K && this.hasAttackTarget() && this.field_70146_Z.nextInt(10) == 0) {
            this.leap(4.0f, 0.5, (Entity)this.func_70638_az());
        }
        if (this.leapedAbilityQueued && !this.field_70122_E && !this.func_130014_f_().field_72995_K) {
            this.leapedAbilityQueued = false;
            this.leapedAbilityReady = true;
        }
        if (this.leapedAbilityReady && this.field_70122_E && !this.func_130014_f_().field_72995_K) {
            this.leapedAbilityReady = false;
            double distance = 4.0;
            List possibleTargets = this.func_130014_f_().func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(distance, distance, distance), possibleTarget -> possibleTarget.func_70089_S() && possibleTarget != this && !this.func_184215_y((Entity)possibleTarget) && !this.func_184191_r((Entity)possibleTarget) && this.func_70686_a(possibleTarget.getClass()) && this.canAttackEntity((EntityLivingBase)possibleTarget));
            if (!possibleTargets.isEmpty()) {
                for (EntityLivingBase possibleTarget2 : possibleTargets) {
                    boolean doDamage = true;
                    if (this.getRider() instanceof EntityPlayer && MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent((EntityPlayer)this.getRider(), (Entity)possibleTarget2))) {
                        doDamage = false;
                    }
                    if (!doDamage) continue;
                    for (ElementInfo element : this.creatureInfo.elements) {
                        element.debuffEntity(possibleTarget2, this.getEffectDuration(1), this.getEffectAmplifier(1.0f));
                    }
                }
            }
            this.playAttackSound();
        }
    }

    @Override
    public float getAISpeedModifier() {
        if (!this.field_70122_E) {
            return 2.0f;
        }
        return 1.0f;
    }

    @Override
    public double func_70042_X() {
        return (double)this.field_70131_O * 0.85;
    }

    @Override
    public void leap(double distance, double leapHeight) {
        super.leap(distance, leapHeight);
        if (!this.func_130014_f_().field_72995_K) {
            this.leapedAbilityQueued = true;
        }
    }

    @Override
    public void leap(float range, double leapHeight, Entity target) {
        super.leap(range, leapHeight, target);
        if (!this.func_130014_f_().field_72995_K) {
            this.leapedAbilityQueued = true;
        }
    }

    @Override
    public void mountAbility(Entity rider) {
        if (!this.field_70122_E) {
            return;
        }
        if (this.abilityToggled) {
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        this.playJumpSound();
        this.leap(4.0, 0.5);
        this.applyStaminaCost();
    }

    @Override
    public float getStaminaCost() {
        return 15.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 100;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 1.0f;
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 10;
    }

    @Override
    public float getFallResistance() {
        return 20.0f;
    }
}

