/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.info.projectile.behaviours;

import com.google.gson.JsonObject;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.helpers.JSONHelper;
import com.lycanitesmobs.core.info.projectile.behaviours.ProjectileBehaviour;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class ProjectileBehaviourCatch
extends ProjectileBehaviour {
    public List<String> catchEntityIds = new ArrayList<String>();
    public boolean resetAttackCooldown = true;
    public boolean preventDamage = true;

    @Override
    public void loadFromJSON(JsonObject json) {
        if (json.has("catchEntityIds")) {
            this.catchEntityIds = JSONHelper.getJsonStrings(json.get("catchEntityIds").getAsJsonArray());
        }
        if (json.has("resetAttackCooldown")) {
            this.resetAttackCooldown = json.get("resetAttackCooldown").getAsBoolean();
        }
        if (json.has("preventDamage")) {
            this.preventDamage = json.get("preventDamage").getAsBoolean();
        }
    }

    @Override
    public boolean canDamage(BaseProjectileEntity projectile, World world, EntityLivingBase target, boolean canDamage) {
        if (projectile.func_130014_f_().field_72995_K || target == projectile.func_85052_h()) {
            return canDamage;
        }
        ResourceLocation entityResourceLocation = EntityList.func_191301_a((Entity)target);
        if (entityResourceLocation == null) {
            return canDamage;
        }
        String entityId = entityResourceLocation.toString();
        if (!this.catchEntityIds.contains(entityId)) {
            return canDamage;
        }
        if (this.resetAttackCooldown && target instanceof BaseCreatureEntity) {
            ((BaseCreatureEntity)target).resetAttackCooldown();
        }
        projectile.func_70106_y();
        return !this.preventDamage;
    }
}

