/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.pets;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.Variant;
import com.lycanitesmobs.core.pets.PetEntry;
import com.lycanitesmobs.core.pets.PetEntryFamiliar;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import org.apache.commons.io.IOUtils;

public class DonationFamiliars {
    public static DonationFamiliars instance = new DonationFamiliars();
    public Map<UUID, Map<UUID, PetEntry>> playerFamiliars = new HashMap<UUID, Map<UUID, PetEntry>>();
    public long jsonLoadedTime = -1L;
    public List<String> familiarBlacklist = new ArrayList<String>();

    public boolean parseFamiliarJSON(String jsonString) {
        try {
            JsonParser jsonParser = new JsonParser();
            JsonElement jsonElement = jsonParser.parse(jsonString);
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            Iterator jsonIterator = jsonArray.iterator();
            while (jsonIterator.hasNext()) {
                try {
                    JsonObject familiarJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                    UUID minecraft_uuid = UUID.fromString(familiarJson.get("minecraft_uuid").getAsString());
                    String minecraft_username = familiarJson.get("minecraft_username").getAsString();
                    if (this.familiarBlacklist.contains(minecraft_username)) continue;
                    UUID familiar_uuid = UUID.fromString(familiarJson.get("familiar_uuid").getAsString());
                    String familiar_species = familiarJson.get("familiar_species").getAsString();
                    CreatureInfo creatureInfo = CreatureManager.getInstance().getCreature(familiar_species);
                    int familiar_subspecies = familiarJson.get("familiar_subspecies_index").getAsInt();
                    int familiar_variant = familiarJson.get("familiar_variant_index").getAsInt();
                    Variant creatureVariant = creatureInfo != null ? creatureInfo.getSubspecies(familiar_subspecies).getVariant(familiar_variant) : null;
                    String familiar_name = familiarJson.get("familiar_name").getAsString();
                    String familiar_color = familiarJson.get("familiar_color").getAsString();
                    double familiar_size = familiarJson.get("familiar_size").getAsDouble();
                    if (familiar_size <= 0.0) {
                        familiar_size = 0.5;
                        if (creatureVariant != null && creatureVariant.scale != 1.0) {
                            familiar_size *= 1.0 / creatureVariant.scale;
                        }
                    }
                    PetEntryFamiliar familiarEntry = new PetEntryFamiliar(familiar_uuid, null, familiar_species.toLowerCase());
                    familiarEntry.setEntitySubspecies(familiar_subspecies);
                    familiarEntry.setEntityVariant(familiar_variant);
                    familiarEntry.setEntitySize(familiar_size);
                    if (!"".equals(familiar_name)) {
                        familiarEntry.setEntityName(familiar_name);
                    }
                    familiarEntry.setColor(familiar_color);
                    if (!this.playerFamiliars.containsKey(minecraft_uuid)) {
                        this.playerFamiliars.put(minecraft_uuid, new HashMap());
                    }
                    if (!this.playerFamiliars.get(minecraft_uuid).containsKey(familiar_uuid)) {
                        this.playerFamiliars.get(minecraft_uuid).put(familiar_uuid, familiarEntry);
                        continue;
                    }
                    PetEntry existingEntry = this.playerFamiliars.get(minecraft_uuid).get(familiar_uuid);
                    existingEntry.copy(familiarEntry);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Map<UUID, PetEntry> getFamiliarsForPlayer(EntityPlayer player) {
        long currentTime = System.currentTimeMillis() / 1000L;
        if (this.jsonLoadedTime < 0L || currentTime - this.jsonLoadedTime > 3600L) {
            this.jsonLoadedTime = System.currentTimeMillis() / 1000L;
            DonationLoader donationLoader = new DonationLoader(player);
            Thread thread = new Thread(donationLoader);
            thread.start();
        }
        Map<UUID, PetEntry> playerFamiliarEntries = new HashMap<UUID, PetEntry>();
        if (this.playerFamiliars.containsKey(player.func_110124_au())) {
            playerFamiliarEntries = this.playerFamiliars.get(player.func_110124_au());
            for (PetEntry familiarEntry : playerFamiliarEntries.values()) {
                if (familiarEntry.host != null) continue;
                familiarEntry.host = player;
            }
        }
        return playerFamiliarEntries;
    }

    public class DonationLoader
    implements Runnable {
        EntityPlayer player;

        public DonationLoader(EntityPlayer player) {
            this.player = player;
        }

        @Override
        public void run() {
            ExtendedPlayer extendedPlayer;
            this.readFromJSON();
            if (this.player != null && (extendedPlayer = ExtendedPlayer.getForPlayer(this.player)) != null) {
                extendedPlayer.loadFamiliars();
            }
        }

        private void readFromJSON() {
            String jsonString = null;
            try {
                URL familiarURL = new URL("https://api.lycanitesmobs.com/familiar");
                URLConnection urlConnection = familiarURL.openConnection();
                urlConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2272.89 Safari/537.36");
                try (InputStream inputStream = urlConnection.getInputStream();){
                    jsonString = IOUtils.toString((InputStream)inputStream, (Charset)null);
                }
                LycanitesMobs.logInfo("", "Online donations file read successfully.");
            }
            catch (Throwable e) {
                LycanitesMobs.logInfo("", "Unable to access the online donations file.");
                e.printStackTrace();
                return;
            }
            instance.parseFamiliarJSON(jsonString);
        }
    }
}

