/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.pets;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.entity.AgeableCreatureEntity;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.CreatureStats;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.Subspecies;
import com.lycanitesmobs.core.info.Variant;
import com.lycanitesmobs.core.pets.PetManager;
import com.lycanitesmobs.core.pets.SummonSet;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PetEntry {
    public PetManager petManager;
    public UUID petEntryID;
    private String type;
    public boolean active = true;
    public int respawnTime = 0;
    public int respawnTimeMax;
    public boolean isRespawning = false;
    public int spawnCount = 0;
    public boolean temporary = false;
    public int temporaryDuration = 100;
    public boolean spawningActive = true;
    public EntityLivingBase host;
    public SummonSet summonSet;
    public Entity entity;
    public NBTTagCompound entityNBT;
    public int entityTick = 0;
    public float entityHealth = 1.0f;
    public float entityMaxHealth = 1.0f;
    public int entityLevel = 1;
    public int entityExperience = 0;
    public int entityMaxExperience = CreatureStats.BASE_LEVELUP_EXPERIENCE;
    public String entityName = "";
    public int subspeciesIndex = 0;
    public int variantIndex = 0;
    public double entitySize = 1.0;
    public String color = "000000";
    public boolean teleportEntity = false;
    public boolean releaseEntity = false;

    public static PetEntry createFromEntity(EntityPlayer player, BaseCreatureEntity entity, String petType) {
        CreatureInfo creatureInfo = entity.creatureInfo;
        PetEntry petEntry = new PetEntry(UUID.randomUUID(), petType, (EntityLivingBase)player, creatureInfo.getName());
        if (entity.func_145818_k_()) {
            petEntry.setEntityName(entity.func_95999_t());
        }
        petEntry.setEntitySubspecies(entity.getSubspeciesIndex());
        petEntry.setEntityVariant(entity.getVariantIndex());
        petEntry.setEntitySize(entity.sizeScale);
        petEntry.setColor("000000");
        return petEntry;
    }

    public PetEntry(UUID petEntryID, String type, EntityLivingBase host, String summonType) {
        this.petEntryID = petEntryID;
        this.type = type;
        this.host = host;
        ExtendedPlayer playerExt = null;
        if (host instanceof EntityPlayer) {
            playerExt = ExtendedPlayer.getForPlayer((EntityPlayer)host);
        }
        this.summonSet = new SummonSet(playerExt);
        this.summonSet.summonableOnly = false;
        this.summonSet.setSummonType(summonType);
        this.respawnTimeMax = CreatureManager.getInstance().config.petRespawnTime;
        if ("minion".equalsIgnoreCase(this.type)) {
            this.temporary = true;
        }
    }

    public PetEntry setEntityName(String name) {
        this.entityName = name;
        return this;
    }

    public PetEntry setEntitySubspecies(int index) {
        this.subspeciesIndex = index;
        return this;
    }

    public PetEntry setEntityVariant(int index) {
        this.variantIndex = index;
        return this;
    }

    public PetEntry setEntitySize(double size) {
        this.entitySize = size;
        return this;
    }

    public PetEntry setColor(String color) {
        this.color = color;
        return this;
    }

    public PetEntry setOwner(EntityLivingBase owner) {
        this.host = owner;
        if (this.host != null && this.host instanceof EntityPlayer) {
            ExtendedPlayer playerExt;
            this.summonSet.playerExt = playerExt = ExtendedPlayer.getForPlayer((EntityPlayer)this.host);
        }
        return this;
    }

    public PetEntry setSpawningActive(boolean spawningActive) {
        if (this.spawningActive == spawningActive) {
            return this;
        }
        if (!this.host.func_130014_f_().field_72995_K) {
            if (!spawningActive) {
                this.despawnEntity();
            } else if (this.usesSpirit() && this.summonSet.playerExt != null) {
                if (this.summonSet.playerExt.spirit < this.getSpiritCost()) {
                    this.spawningActive = false;
                    return this;
                }
                this.summonSet.playerExt.spirit -= this.getSpiritCost();
                this.summonSet.playerExt.spiritReserved += this.getSpiritCost();
            }
        }
        this.spawningActive = spawningActive;
        return this;
    }

    public void setLevel(int level) {
        if (this.entity != null && this.entity instanceof BaseCreatureEntity) {
            ((BaseCreatureEntity)this.entity).setLevel(level);
        }
        this.entityLevel = level;
    }

    public int getLevel() {
        if (this.entity != null && this.entity instanceof BaseCreatureEntity) {
            this.entityLevel = ((BaseCreatureEntity)this.entity).getLevel();
        }
        return this.entityLevel;
    }

    public int getExperience() {
        if (this.entity != null && this.entity instanceof BaseCreatureEntity) {
            this.entityExperience = ((BaseCreatureEntity)this.entity).getExperience();
        }
        return this.entityExperience;
    }

    public void setExperience(int experience) {
        if (this.entity != null && this.entity instanceof BaseCreatureEntity) {
            ((BaseCreatureEntity)this.entity).setExperience(experience);
        }
        this.entityExperience = experience;
    }

    public int getMaxExperience() {
        return CreatureStats.BASE_LEVELUP_EXPERIENCE + Math.round((float)(CreatureStats.BASE_LEVELUP_EXPERIENCE * this.getLevel()) * 0.25f);
    }

    public CreatureInfo getCreatureInfo() {
        if (this.summonSet == null || "".equals(this.summonSet.summonType)) {
            return null;
        }
        return CreatureManager.getInstance().getCreature(this.summonSet.summonType);
    }

    public float getHealth() {
        if (this.entity != null && this.entity instanceof EntityLivingBase) {
            this.entityHealth = ((EntityLivingBase)this.entity).func_110143_aJ();
        }
        return this.entityHealth;
    }

    public float getMaxHealth() {
        if (this.entity != null && this.entity instanceof EntityLivingBase) {
            this.entityMaxHealth = ((EntityLivingBase)this.entity).func_110138_aP();
        }
        return this.entityMaxHealth;
    }

    public void copy(PetEntry copyEntry) {
        this.setEntityName(copyEntry.entityName);
        this.setEntitySubspecies(copyEntry.subspeciesIndex);
        this.setEntityVariant(copyEntry.variantIndex);
        this.setEntitySize(copyEntry.entitySize);
        this.setColor(copyEntry.color);
        if (copyEntry.summonSet != null) {
            this.summonSet.setSummonType(copyEntry.summonSet.summonType);
        }
    }

    public String getDisplayName() {
        String displayName = this.summonSet.getCreatureInfo().getTitle();
        if (this.entityName != null && !"".equals(this.entityName)) {
            displayName = this.entityName + " (" + displayName + ")";
        }
        return displayName;
    }

    public void onAdd(PetManager petManager) {
        this.petManager = petManager;
    }

    public void remove() {
        this.setSpawningActive(false);
        this.active = false;
    }

    public void onUpdate(World world) {
        if (world.field_72995_K) {
            if (this.isRespawning && this.respawnTime > 0) {
                --this.respawnTime;
            }
            return;
        }
        if (!this.active) {
            return;
        }
        if (!this.isActive()) {
            this.remove();
            return;
        }
        if (this.spawningActive) {
            if (this.entity != null && !this.entity.func_70089_S()) {
                this.saveEntityNBT();
                this.entity = null;
                this.isRespawning = true;
                this.respawnTime = this.respawnTimeMax;
                if (this.summonSet.playerExt != null) {
                    this.summonSet.playerExt.sendPetEntryToPlayer(this);
                }
            }
            if (this.entity == null) {
                if (!this.isRespawning) {
                    this.respawnTime = 0;
                }
                if (this.respawnTime > this.respawnTimeMax) {
                    this.respawnTime = this.respawnTimeMax;
                }
                if (this.respawnTime-- <= 0) {
                    this.spawnEntity();
                    this.isRespawning = false;
                }
            }
            if (this.entity != null) {
                ++this.entityTick;
                try {
                    if (this.teleportEntity) {
                        if (this.entity.func_130014_f_() != this.host.func_130014_f_()) {
                            this.entity.func_184204_a(this.host.func_130014_f_().field_73011_w.getDimension());
                        }
                        this.entity.func_70107_b(this.host.field_70165_t, this.host.field_70163_u, this.host.field_70161_v);
                    }
                }
                catch (Exception e) {
                    LycanitesMobs.logDebug("Pet", "Unable to teleport a pet.");
                }
                if (this.entity instanceof EntityLivingBase) {
                    EntityLivingBase entityLiving = (EntityLivingBase)this.entity;
                    if (this.entityTick % 60 == 0 && entityLiving.func_110143_aJ() < entityLiving.func_110138_aP()) {
                        entityLiving.func_70606_j(Math.min(entityLiving.func_110143_aJ() + 1.0f, entityLiving.func_110138_aP()));
                    }
                    this.entityHealth = entityLiving.func_110143_aJ();
                    this.entityMaxHealth = entityLiving.func_110138_aP();
                }
                if (this.entity.func_145818_k_()) {
                    this.entityName = this.entity.func_95999_t();
                }
            }
        } else {
            if (this.entity != null) {
                this.saveEntityNBT();
                this.entity.func_70106_y();
                this.entity = null;
            }
            if (this.respawnTime > 0) {
                --this.respawnTime;
            }
        }
        this.teleportEntity = false;
    }

    public void onBehaviourUpdate() {
        if (this.entity != null && this.entity instanceof TameableCreatureEntity) {
            this.summonSet.applyBehaviour((TameableCreatureEntity)this.entity);
        }
    }

    public boolean isActive() {
        return this.entity != null || !this.temporary || this.spawnCount <= 0;
    }

    public void spawnEntity() {
        if (this.entity != null || this.host == null) {
            return;
        }
        try {
            this.entity = (Entity)this.summonSet.getCreatureClass().getConstructor(World.class).newInstance(this.host.func_130014_f_());
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("Pets", "[Pet Entry] Unable to find an entity class for pet entry.  Type: " + this.summonSet.summonType + " Class: " + this.summonSet.getCreatureClass() + " ID: " + this.petEntryID);
        }
        if (this.entity == null) {
            return;
        }
        this.loadEntityNBT();
        this.entity.func_70012_b(this.host.field_70165_t, this.host.field_70163_u, this.host.field_70161_v, this.host.field_70177_z, 0.0f);
        if (this.entity instanceof BaseCreatureEntity) {
            BaseCreatureEntity entityCreature = (BaseCreatureEntity)this.entity;
            entityCreature.applyLevel(this.entityLevel);
            entityCreature.setExperience(this.entityExperience);
            entityCreature.setMinion(true);
            entityCreature.setPetEntry(this);
            if (entityCreature instanceof TameableCreatureEntity) {
                TameableCreatureEntity entityTameable = (TameableCreatureEntity)entityCreature;
                this.summonSet.applyBehaviour(entityTameable);
            }
            float randomAngle = 45.0f + 45.0f * this.host.func_70681_au().nextFloat();
            if (this.host.func_70681_au().nextBoolean()) {
                randomAngle = -randomAngle;
            }
            BlockPos spawnPos = entityCreature.getFacingPosition((Entity)this.host, -1.0, randomAngle);
            if (!this.entity.func_130014_f_().isSideSolid(spawnPos, EnumFacing.UP)) {
                this.entity.func_70012_b((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p(), this.host.field_70177_z, 0.0f);
            } else {
                spawnPos = entityCreature.getFacingPosition((Entity)this.host, -1.0, -randomAngle);
                if (this.entity.func_130014_f_().isSideSolid(spawnPos, EnumFacing.UP)) {
                    this.entity.func_70012_b((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p(), this.host.field_70177_z, 0.0f);
                }
            }
            if (this.temporary) {
                entityCreature.setTemporary(this.temporaryDuration);
            }
            if (this.entityName != null && !"".equals(this.entityName)) {
                entityCreature.func_96094_a(this.entityName);
            }
            entityCreature.setSizeScale(this.entitySize);
            entityCreature.setSubspecies(this.subspeciesIndex);
            entityCreature.applyVariant(this.variantIndex);
            if (entityCreature instanceof TameableCreatureEntity && this.host instanceof EntityPlayer) {
                TameableCreatureEntity entityTameable = (TameableCreatureEntity)entityCreature;
                entityTameable.setPlayerOwner((EntityPlayer)this.host);
                this.summonSet.applyBehaviour(entityTameable);
            }
        }
        ++this.spawnCount;
        if (this.entity instanceof EntityLivingBase && this.isRespawning) {
            EntityLivingBase entityLiving = (EntityLivingBase)this.entity;
            entityLiving.func_70606_j(entityLiving.func_110138_aP() / 2.0f);
        }
        this.onSpawnEntity(this.entity);
        this.host.func_130014_f_().func_72838_d(this.entity);
        if (this.summonSet.playerExt != null) {
            this.summonSet.playerExt.sendPetEntryToPlayer(this);
        }
    }

    public void onSpawnEntity(Entity entity) {
    }

    public void despawnEntity() {
        if (this.entity == null) {
            return;
        }
        this.onDespawnEntity(this.entity);
        this.saveEntityNBT();
        this.entity.func_70106_y();
        this.entity = null;
    }

    public void onDespawnEntity(Entity entity) {
    }

    public void assignEntity(Entity entity) {
        if (this.entity != null) {
            this.despawnEntity();
        }
        this.setSpawningActive(true);
        this.entity = entity;
        if (this.entity instanceof BaseCreatureEntity) {
            BaseCreatureEntity entityCreature = (BaseCreatureEntity)this.entity;
            entityCreature.setMinion(true);
            entityCreature.setPetEntry(this);
            if (entityCreature instanceof TameableCreatureEntity) {
                TameableCreatureEntity entityTameable = (TameableCreatureEntity)entityCreature;
                this.summonSet.updateBehaviour(entityTameable);
            }
            if (this.temporary) {
                entityCreature.setTemporary(this.temporaryDuration);
            }
            if (this.entityName != null && !"".equals(this.entityName)) {
                entityCreature.func_96094_a(this.entityName);
            }
            entityCreature.setSizeScale(this.entitySize);
            entityCreature.setSubspecies(this.subspeciesIndex);
            entityCreature.applyVariant(this.variantIndex);
        }
        ++this.spawnCount;
        this.saveEntityNBT();
        this.onSpawnEntity(this.entity);
    }

    public String getType() {
        return this.type;
    }

    public boolean usesSpirit() {
        return "pet".equals(this.getType()) || "mount".equals(this.getType());
    }

    public int getSpiritCost() {
        if (this.summonSet.playerExt == null) {
            return 0;
        }
        return this.summonSet.playerExt.spiritCharge * this.getCreatureInfo().summonCost;
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound.func_186855_b("UUID")) {
            this.petEntryID = nbtTagCompound.func_186857_a("UUID");
        }
        if (nbtTagCompound.func_74764_b("Type")) {
            this.type = nbtTagCompound.func_74779_i("Type");
        }
        if (nbtTagCompound.func_74764_b("Active")) {
            this.active = nbtTagCompound.func_74767_n("Active");
        }
        if (nbtTagCompound.func_74764_b("RespawnTime")) {
            this.respawnTime = nbtTagCompound.func_74762_e("RespawnTime");
        }
        if (nbtTagCompound.func_74764_b("Respawning")) {
            this.isRespawning = nbtTagCompound.func_74767_n("Respawning");
        }
        if (nbtTagCompound.func_74764_b("SpawningActive")) {
            this.spawningActive = nbtTagCompound.func_74767_n("SpawningActive");
        }
        this.summonSet.readFromNBT(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("EntityName")) {
            this.setEntityName(nbtTagCompound.func_74779_i("EntityName"));
        }
        if (!"familiar".equals(this.getType())) {
            if (nbtTagCompound.func_74764_b("SubspeciesID")) {
                this.setEntitySubspecies(Subspecies.getIndexFromOld(nbtTagCompound.func_74762_e("SubspeciesID")));
                this.setEntityVariant(Variant.getIndexFromOld(nbtTagCompound.func_74762_e("SubspeciesID")));
            }
            if (nbtTagCompound.func_74764_b("Subspecies")) {
                this.setEntitySubspecies(nbtTagCompound.func_74762_e("Subspecies"));
            }
            if (nbtTagCompound.func_74764_b("Variant")) {
                this.setEntityVariant(nbtTagCompound.func_74762_e("Variant"));
            }
            if (nbtTagCompound.func_74764_b("EntitySize")) {
                this.setEntitySize(nbtTagCompound.func_74769_h("EntitySize"));
            }
            if (nbtTagCompound.func_74764_b("Color")) {
                this.setColor(nbtTagCompound.func_74779_i("Color"));
            }
        }
        if (nbtTagCompound.func_74764_b("EntityNBT")) {
            this.entityNBT = nbtTagCompound.func_74775_l("EntityNBT");
        }
        this.loadEntityNBT();
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_186854_a("UUID", this.petEntryID);
        nbtTagCompound.func_74778_a("Type", this.getType());
        nbtTagCompound.func_74757_a("Active", this.active);
        nbtTagCompound.func_74768_a("RespawnTime", this.respawnTime);
        nbtTagCompound.func_74757_a("Respawning", this.isRespawning);
        nbtTagCompound.func_74757_a("SpawningActive", this.spawningActive);
        this.summonSet.writeToNBT(nbtTagCompound);
        if (this.usesSpirit()) {
            nbtTagCompound.func_74778_a("EntityName", this.entityName);
            nbtTagCompound.func_74768_a("Subspecies", this.subspeciesIndex);
            nbtTagCompound.func_74768_a("Variant", this.variantIndex);
            nbtTagCompound.func_74780_a("EntitySize", this.entitySize);
            nbtTagCompound.func_74778_a("Color", this.color);
        }
        this.saveEntityNBT();
        nbtTagCompound.func_74782_a("EntityNBT", (NBTBase)this.entityNBT);
    }

    public void saveEntityNBT() {
        if (this.entityNBT == null) {
            this.entityNBT = new NBTTagCompound();
        }
        this.entityNBT.func_74768_a("MobLevel", this.getLevel());
        this.entityNBT.func_74768_a("Experience", this.getExperience());
        if (this.entity instanceof BaseCreatureEntity) {
            BaseCreatureEntity baseCreatureEntity = (BaseCreatureEntity)this.entity;
            baseCreatureEntity.inventory.writeToNBT(this.entityNBT);
            NBTTagCompound extTagCompound = new NBTTagCompound();
            baseCreatureEntity.extraMobBehaviour.writeToNBT(extTagCompound);
            this.entityNBT.func_74782_a("ExtraBehaviour", (NBTBase)extTagCompound);
            if (this.entity instanceof AgeableCreatureEntity) {
                AgeableCreatureEntity ageableCreatureEntity = (AgeableCreatureEntity)this.entity;
                this.entityNBT.func_74768_a("Age", ageableCreatureEntity.getGrowingAge());
            }
            if (this.entity.func_145818_k_()) {
                this.entityName = this.entity.func_95999_t();
            }
            this.entity.func_189511_e(this.entityNBT);
        }
    }

    public void loadEntityNBT() {
        if (this.entityNBT == null) {
            return;
        }
        if (this.entityNBT.func_74764_b("MobLevel")) {
            this.setLevel(this.entityNBT.func_74762_e("MobLevel"));
        }
        if (this.entityNBT.func_74764_b("Experience")) {
            this.setExperience(this.entityNBT.func_74762_e("Experience"));
        }
        if (this.entity instanceof BaseCreatureEntity) {
            BaseCreatureEntity baseCreatureEntity = (BaseCreatureEntity)this.entity;
            baseCreatureEntity.inventory.readFromNBT(this.entityNBT);
            if (this.entity instanceof AgeableCreatureEntity) {
                AgeableCreatureEntity ageableCreatureEntity = (AgeableCreatureEntity)this.entity;
                if (this.entityNBT.func_74764_b("Age")) {
                    ageableCreatureEntity.setGrowingAge(this.entityNBT.func_74762_e("Age"));
                } else {
                    ageableCreatureEntity.setGrowingAge(0);
                }
            }
        }
    }
}

