/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.spawner;

import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.core.spawner.trigger.BlockSpawnTrigger;
import com.lycanitesmobs.core.spawner.trigger.ChunkSpawnTrigger;
import com.lycanitesmobs.core.spawner.trigger.EntitySpawnedSpawnTrigger;
import com.lycanitesmobs.core.spawner.trigger.ExplosionSpawnTrigger;
import com.lycanitesmobs.core.spawner.trigger.FishingSpawnTrigger;
import com.lycanitesmobs.core.spawner.trigger.KillSpawnTrigger;
import com.lycanitesmobs.core.spawner.trigger.MixBlockSpawnTrigger;
import com.lycanitesmobs.core.spawner.trigger.MobEventSpawnTrigger;
import com.lycanitesmobs.core.spawner.trigger.PlayerSpawnTrigger;
import com.lycanitesmobs.core.spawner.trigger.SleepSpawnTrigger;
import com.lycanitesmobs.core.spawner.trigger.SpawnTrigger;
import com.lycanitesmobs.core.spawner.trigger.WorldSpawnTrigger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class SpawnerEventListener {
    protected static SpawnerEventListener INSTANCE;
    public static boolean testOnCreative;
    public List<WorldSpawnTrigger> worldSpawnTriggers = new ArrayList<WorldSpawnTrigger>();
    public List<PlayerSpawnTrigger> playerSpawnTriggers = new ArrayList<PlayerSpawnTrigger>();
    public List<KillSpawnTrigger> killSpawnTriggers = new ArrayList<KillSpawnTrigger>();
    public List<EntitySpawnedSpawnTrigger> entitySpawnedSpawnTriggers = new ArrayList<EntitySpawnedSpawnTrigger>();
    public List<ChunkSpawnTrigger> chunkSpawnTriggers = new ArrayList<ChunkSpawnTrigger>();
    public List<BlockSpawnTrigger> blockSpawnTriggers = new ArrayList<BlockSpawnTrigger>();
    public List<SleepSpawnTrigger> sleepSpawnTriggers = new ArrayList<SleepSpawnTrigger>();
    public List<FishingSpawnTrigger> fishingSpawnTriggers = new ArrayList<FishingSpawnTrigger>();
    public List<ExplosionSpawnTrigger> explosionSpawnTriggers = new ArrayList<ExplosionSpawnTrigger>();
    public List<MobEventSpawnTrigger> mobEventSpawnTriggers = new ArrayList<MobEventSpawnTrigger>();
    public List<MixBlockSpawnTrigger> mixBlockSpawnTriggers = new ArrayList<MixBlockSpawnTrigger>();
    public Map<EntityPlayer, Long> playerUpdateTicks = new HashMap<EntityPlayer, Long>();
    public boolean chunkSpawnTriggersActive = false;
    private BlockPos lastMixPos;

    public static SpawnerEventListener getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SpawnerEventListener();
        }
        return INSTANCE;
    }

    public boolean addTrigger(SpawnTrigger spawnTrigger) {
        if (spawnTrigger instanceof WorldSpawnTrigger && !this.worldSpawnTriggers.contains(spawnTrigger)) {
            this.worldSpawnTriggers.add((WorldSpawnTrigger)spawnTrigger);
            return true;
        }
        if (spawnTrigger instanceof PlayerSpawnTrigger && !this.playerSpawnTriggers.contains(spawnTrigger)) {
            this.playerSpawnTriggers.add((PlayerSpawnTrigger)spawnTrigger);
            return true;
        }
        if (spawnTrigger instanceof KillSpawnTrigger && !this.killSpawnTriggers.contains(spawnTrigger)) {
            this.killSpawnTriggers.add((KillSpawnTrigger)spawnTrigger);
            return true;
        }
        if (spawnTrigger instanceof EntitySpawnedSpawnTrigger && !this.entitySpawnedSpawnTriggers.contains(spawnTrigger)) {
            this.entitySpawnedSpawnTriggers.add((EntitySpawnedSpawnTrigger)spawnTrigger);
            return true;
        }
        if (spawnTrigger instanceof ChunkSpawnTrigger && !this.chunkSpawnTriggers.contains(spawnTrigger)) {
            this.chunkSpawnTriggers.add((ChunkSpawnTrigger)spawnTrigger);
            return true;
        }
        if (spawnTrigger instanceof MixBlockSpawnTrigger && !this.mixBlockSpawnTriggers.contains(spawnTrigger)) {
            this.mixBlockSpawnTriggers.add((MixBlockSpawnTrigger)spawnTrigger);
            return true;
        }
        if (spawnTrigger instanceof SleepSpawnTrigger && !this.sleepSpawnTriggers.contains(spawnTrigger)) {
            this.sleepSpawnTriggers.add((SleepSpawnTrigger)spawnTrigger);
            return true;
        }
        if (spawnTrigger instanceof BlockSpawnTrigger && !this.blockSpawnTriggers.contains(spawnTrigger)) {
            this.blockSpawnTriggers.add((BlockSpawnTrigger)spawnTrigger);
            return true;
        }
        if (spawnTrigger instanceof FishingSpawnTrigger && !this.fishingSpawnTriggers.contains(spawnTrigger)) {
            this.fishingSpawnTriggers.add((FishingSpawnTrigger)spawnTrigger);
            return true;
        }
        if (spawnTrigger instanceof ExplosionSpawnTrigger && !this.explosionSpawnTriggers.contains(spawnTrigger)) {
            this.explosionSpawnTriggers.add((ExplosionSpawnTrigger)spawnTrigger);
            return true;
        }
        if (spawnTrigger instanceof MobEventSpawnTrigger && !this.mobEventSpawnTriggers.contains(spawnTrigger)) {
            this.mobEventSpawnTriggers.add((MobEventSpawnTrigger)spawnTrigger);
            return true;
        }
        return false;
    }

    public void removeTrigger(SpawnTrigger spawnTrigger) {
        if (this.worldSpawnTriggers.contains(spawnTrigger)) {
            this.worldSpawnTriggers.remove(spawnTrigger);
        }
        if (this.playerSpawnTriggers.contains(spawnTrigger)) {
            this.playerSpawnTriggers.remove(spawnTrigger);
        }
        if (this.killSpawnTriggers.contains(spawnTrigger)) {
            this.killSpawnTriggers.remove(spawnTrigger);
        }
        if (this.entitySpawnedSpawnTriggers.contains(spawnTrigger)) {
            this.entitySpawnedSpawnTriggers.remove(spawnTrigger);
        }
        if (this.chunkSpawnTriggers.contains(spawnTrigger)) {
            this.chunkSpawnTriggers.remove(spawnTrigger);
        }
        if (this.blockSpawnTriggers.contains(spawnTrigger)) {
            this.blockSpawnTriggers.remove(spawnTrigger);
        }
        if (this.sleepSpawnTriggers.contains(spawnTrigger)) {
            this.sleepSpawnTriggers.remove(spawnTrigger);
        }
        if (this.fishingSpawnTriggers.contains(spawnTrigger)) {
            this.fishingSpawnTriggers.remove(spawnTrigger);
        }
        if (this.explosionSpawnTriggers.contains(spawnTrigger)) {
            this.explosionSpawnTriggers.remove(spawnTrigger);
        }
        if (this.mobEventSpawnTriggers.contains(spawnTrigger)) {
            this.mobEventSpawnTriggers.remove(spawnTrigger);
        }
        if (this.mixBlockSpawnTriggers.contains(spawnTrigger)) {
            this.mixBlockSpawnTriggers.remove(spawnTrigger);
        }
    }

    @SubscribeEvent
    public void onWorldUpdate(TickEvent.WorldTickEvent event) {
        World world = event.world;
        if (world.field_72995_K) {
            return;
        }
        ExtendedWorld worldExt = ExtendedWorld.getForWorld(world);
        if (worldExt == null) {
            return;
        }
        if (worldExt.lastSpawnerTime == world.func_82737_E()) {
            return;
        }
        worldExt.lastSpawnerTime = world.func_82737_E();
        ArrayList<BlockPos> triggerPositions = new ArrayList<BlockPos>();
        for (EntityPlayer player : world.field_73010_i) {
            if (triggerPositions.isEmpty()) {
                triggerPositions.add(player.func_180425_c());
                continue;
            }
            boolean nearOtherPlayers = false;
            for (BlockPos triggerPosition : triggerPositions) {
                if (!(player.func_174818_b(triggerPosition) <= 10000.0)) continue;
                nearOtherPlayers = true;
            }
            if (nearOtherPlayers) continue;
            triggerPositions.add(player.func_180425_c());
        }
        for (BlockPos triggerPosition : triggerPositions) {
            for (WorldSpawnTrigger spawnTrigger : this.worldSpawnTriggers) {
                spawnTrigger.onTick(world, triggerPosition, worldExt.lastSpawnerTime);
            }
        }
        if (worldExt.getWorldEvent() != null) {
            for (MobEventSpawnTrigger spawnTrigger : this.mobEventSpawnTriggers) {
                spawnTrigger.onTick(world, worldExt.serverWorldEventPlayer);
            }
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity == null || !(entity instanceof EntityPlayer) || entity.func_130014_f_() == null || entity.func_130014_f_().field_72995_K || event.isCanceled()) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (!this.playerUpdateTicks.containsKey(player)) {
            this.playerUpdateTicks.put(player, 0L);
        }
        long entityUpdateTick = this.playerUpdateTicks.get(player);
        int tickOffset = 0;
        for (PlayerSpawnTrigger spawnTrigger : this.playerSpawnTriggers) {
            spawnTrigger.onTick(player, entityUpdateTick - (long)tickOffset);
            tickOffset += 105;
        }
        this.playerUpdateTicks.put(player, entityUpdateTick + 1L);
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        EntityLivingBase killedEntity = event.getEntityLiving();
        if (killedEntity == null || killedEntity.func_130014_f_() == null || killedEntity.func_130014_f_().field_72995_K || event.isCanceled() || !(killedEntity instanceof EntityLiving)) {
            return;
        }
        Entity killerEntity = event.getSource().func_76346_g();
        if (!(killerEntity instanceof EntityPlayer)) {
            return;
        }
        for (KillSpawnTrigger spawnTrigger : this.killSpawnTriggers) {
            spawnTrigger.onKill((EntityPlayer)killerEntity, (EntityLiving)killedEntity);
        }
    }

    @SubscribeEvent
    public void onEntitySpawn(LivingSpawnEvent event) {
        EntityLivingBase spawnedEntity = event.getEntityLiving();
        if (spawnedEntity == null || spawnedEntity.func_130014_f_() == null || spawnedEntity.func_130014_f_().field_72995_K || event.isCanceled() || !(spawnedEntity instanceof EntityLiving)) {
            return;
        }
        for (EntitySpawnedSpawnTrigger spawnTrigger : this.entitySpawnedSpawnTriggers) {
            spawnTrigger.onEntitySpawned((EntityLiving)spawnedEntity);
        }
    }

    @SubscribeEvent
    public void onChunkPopulate(PopulateChunkEvent.Post event) {
        if (this.chunkSpawnTriggersActive) {
            return;
        }
        for (ChunkSpawnTrigger spawnTrigger : this.chunkSpawnTriggers) {
            if (!spawnTrigger.onChunkPopulate(event.getWorld(), new ChunkPos(event.getChunkX(), event.getChunkZ()))) continue;
            this.chunkSpawnTriggersActive = true;
        }
        this.chunkSpawnTriggersActive = false;
    }

    @SubscribeEvent
    public void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        EntityPlayer player = event.getHarvester();
        if (event.getState() == null || event.getWorld() == null || event.getWorld().field_72995_K || event.isCanceled()) {
            return;
        }
        if (player != null && !testOnCreative && player.field_71075_bZ.field_75098_d) {
            return;
        }
        World world = event.getWorld();
        BlockPos blockPos = event.getPos();
        IBlockState blockState = event.getState();
        for (BlockSpawnTrigger spawnTrigger : this.blockSpawnTriggers) {
            spawnTrigger.onBlockHarvest(world, player, blockPos, blockState, 0, event.getFortuneLevel(), event.isSilkTouching());
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getState() == null || event.getWorld() == null || event.getWorld().field_72995_K || event.isCanceled()) {
            return;
        }
        this.onBlockBreak(event.getWorld(), event.getPos(), event.getState(), event.getPlayer(), 0);
    }

    public void onBlockBreak(World world, BlockPos blockPos, IBlockState blockState, EntityPlayer player, int chain) {
        if (player != null && !testOnCreative && player.field_71075_bZ.field_75098_d) {
            return;
        }
        for (BlockSpawnTrigger spawnTrigger : this.blockSpawnTriggers) {
            spawnTrigger.onBlockBreak(world, player, blockPos, blockState, chain);
        }
    }

    @SubscribeEvent
    public void onBlockPlace(BlockEvent.PlaceEvent event) {
        if (event.getState() == null || event.getWorld() == null || event.getWorld().field_72995_K || event.isCanceled()) {
            return;
        }
        this.onBlockPlace(event.getWorld(), event.getPos(), event.getState(), event.getPlayer(), 0);
    }

    public void onBlockPlace(World world, BlockPos blockPos, IBlockState blockState, EntityPlayer player, int chain) {
        if (player != null && !testOnCreative && player.field_71075_bZ.field_75098_d) {
            return;
        }
        for (BlockSpawnTrigger spawnTrigger : this.blockSpawnTriggers) {
            spawnTrigger.onBlockPlace(world, player, blockPos, blockState, chain);
        }
    }

    @SubscribeEvent
    public void onSleep(PlayerSleepInBedEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player == null || player.func_130014_f_() == null || player.func_130014_f_().field_72995_K || event.isCanceled()) {
            return;
        }
        World world = player.func_130014_f_();
        BlockPos spawnPos = event.getPos().func_177982_a(0, 0, 1);
        if (world == null || world.field_72995_K || world.field_73011_w.isDaytime()) {
            return;
        }
        boolean interrupted = false;
        for (SleepSpawnTrigger spawnTrigger : this.sleepSpawnTriggers) {
            if (!spawnTrigger.onSleep(world, player, spawnPos, world.func_180495_p(event.getPos()))) continue;
            interrupted = true;
        }
        if (interrupted) {
            event.setResult(EntityPlayer.SleepResult.NOT_SAFE);
        }
    }

    @SubscribeEvent
    public void onFished(ItemFishedEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player == null || player.func_130014_f_() == null || player.func_130014_f_().field_72995_K || event.isCanceled()) {
            return;
        }
        if (player != null && !testOnCreative && player.field_71075_bZ.field_75098_d) {
            return;
        }
        World world = player.func_130014_f_();
        EntityFishHook hookEntity = event.getHookEntity();
        for (FishingSpawnTrigger spawnTrigger : this.fishingSpawnTriggers) {
            spawnTrigger.onFished(world, player, (Entity)hookEntity);
        }
    }

    @SubscribeEvent
    public void onExplosion(ExplosionEvent.Detonate event) {
        Explosion explosion = event.getExplosion();
        if (explosion == null) {
            return;
        }
        World world = event.getWorld();
        EntityPlayer player = null;
        if (explosion.func_94613_c() instanceof EntityPlayer) {
            player = (EntityPlayer)explosion.func_94613_c();
        }
        if (player != null && !testOnCreative && player.field_71075_bZ.field_75098_d) {
            return;
        }
        for (ExplosionSpawnTrigger spawnTrigger : this.explosionSpawnTriggers) {
            spawnTrigger.onExplosion(world, player, explosion);
        }
    }

    @SubscribeEvent
    public void onLavaMix(BlockEvent.NeighborNotifyEvent event) {
        IBlockState sideBlockState;
        boolean trigger = false;
        Vec3d posVec = new Vec3d((Vec3i)event.getPos());
        EntityPlayer closestPlayer = event.getWorld().func_184137_a(posVec.field_72450_a, posVec.field_72448_b, posVec.field_72449_c, 20.0, false);
        if (closestPlayer == null) {
            return;
        }
        if (event.getState().func_177230_c() == Blocks.field_150355_j || event.getState().func_177230_c() == Blocks.field_150358_i) {
            sideBlockState = event.getWorld().func_180495_p(event.getPos().func_177977_b());
            if (sideBlockState.func_177230_c() == Blocks.field_150353_l) {
                trigger = true;
            }
        } else if ((event.getState().func_177230_c() == Blocks.field_150353_l || event.getState().func_177230_c() == Blocks.field_150356_k) && (sideBlockState = event.getWorld().func_180495_p(event.getPos().func_177977_b())).func_177230_c() == Blocks.field_150355_j) {
            trigger = true;
        }
        if (trigger) {
            if (this.lastMixPos != null && this.lastMixPos.equals((Object)event.getPos())) {
                return;
            }
            this.lastMixPos = event.getPos();
            for (MixBlockSpawnTrigger spawnTrigger : this.mixBlockSpawnTriggers) {
                spawnTrigger.onMix(event.getWorld(), event.getState(), event.getPos());
            }
        }
    }

    static {
        testOnCreative = false;
    }
}

