/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.silentchaos512.lib.event.ClientTicks;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.config.Config;
import net.silentchaos512.scalinghealth.lib.EnumAreaDifficultyMode;
import net.silentchaos512.scalinghealth.utils.SHPlayerDataHandler;

public class DifficultyDisplayHandler
extends Gui {
    public static final DifficultyDisplayHandler INSTANCE = new DifficultyDisplayHandler();
    private static final ResourceLocation TEXTURE = new ResourceLocation("scalinghealth", "textures/gui/hud.png");
    private int lastDifficultyDisplayed = -100;
    private int lastAreaDifficultyDisplayed = -100;
    private int lastUpdateTime = Integer.MIN_VALUE;

    public void showBar() {
        this.lastUpdateTime = Integer.MIN_VALUE;
        this.lastDifficultyDisplayed = -100;
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        SHPlayerDataHandler.PlayerData data;
        if (event.getType() != RenderGameOverlayEvent.ElementType.TEXT || Config.Difficulty.maxValue <= 0.0f || !Config.Client.Difficulty.renderMeter) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        int width = event.getResolution().func_78326_a();
        int height = event.getResolution().func_78328_b();
        SHPlayerDataHandler.PlayerData playerData = data = player != null ? SHPlayerDataHandler.get((EntityPlayer)player) : null;
        if (data == null) {
            return;
        }
        int difficulty = (int)data.getDifficulty();
        int areaDifficultyUnclamped = (int)Config.Difficulty.AREA_DIFFICULTY_MODE.getAreaDifficulty(player.field_70170_p, player.func_180425_c());
        int areaDifficulty = MathHelper.func_76125_a((int)areaDifficultyUnclamped, (int)0, (int)((int)Config.Difficulty.maxValue));
        if (Config.Difficulty.AREA_DIFFICULTY_MODE == EnumAreaDifficultyMode.SERVER_WIDE) {
            difficulty = areaDifficulty;
        }
        int timeSinceLastUpdate = ClientTicks.ticksInGame - this.lastUpdateTime;
        if (difficulty != this.lastDifficultyDisplayed) {
            this.lastDifficultyDisplayed = difficulty;
            this.lastUpdateTime = ClientTicks.ticksInGame;
        }
        if (areaDifficulty < this.lastAreaDifficultyDisplayed - 10 || areaDifficulty > this.lastAreaDifficultyDisplayed + 10 && timeSinceLastUpdate > 1200) {
            this.lastAreaDifficultyDisplayed = areaDifficulty;
            this.lastUpdateTime = ClientTicks.ticksInGame;
        }
        int currentTime = ClientTicks.ticksInGame;
        if (Config.Client.Difficulty.renderMeterAlways || currentTime - this.lastUpdateTime < Config.Client.Difficulty.meterDisplayTime) {
            int posY;
            GlStateManager.func_179147_l();
            mc.field_71446_o.func_110577_a(TEXTURE);
            GlStateManager.func_179094_E();
            int posX = Config.Client.Difficulty.meterPosX;
            if (posX < 0) {
                posX = posX + width - 64;
            }
            if ((posY = Config.Client.Difficulty.meterPosY) < 0) {
                posY = posY + height - 12;
            }
            this.drawTexturedModalRect(posX, posY, 190, 0, 66, 14, 0xFFFFFF);
            int barLength = (int)((float)(60 * areaDifficulty) / Config.Difficulty.maxValue);
            this.drawTexturedModalRect(posX + 3, posY + 5, 193, 19, barLength, 6, 0xFFFFFF);
            barLength = (int)((float)(60 * difficulty) / Config.Difficulty.maxValue);
            this.drawTexturedModalRect(posX + 3, posY + 3, 193, 17, barLength, 2, 0xFFFFFF);
            GlStateManager.func_179094_E();
            float textScale = 0.6f;
            GlStateManager.func_179152_a((float)textScale, (float)textScale, (float)1.0f);
            String localizedString = ScalingHealth.i18n.miscText("difficultyMeterText", new Object[0]);
            mc.field_71466_p.func_175063_a(localizedString, (float)posX / textScale + 4.0f, (float)posY / textScale - 9.0f, 0xFFFFFF);
            String str = String.format("%d", areaDifficultyUnclamped);
            int strWidth = mc.field_71466_p.func_78256_a(str);
            mc.field_71466_p.func_175063_a(str, (float)posX / textScale + 104.0f - (float)strWidth, (float)posY / textScale - 9.0f, 0xAAAAAA);
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
            GlStateManager.func_179084_k();
        }
    }

    private void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height, int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179124_c((float)r, (float)g, (float)b);
        this.func_73729_b(x, y, textureX, textureY, width, height);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }
}

