/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.client;

import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.silentchaos512.lib.config.ConfigBase;
import net.silentchaos512.lib.event.ClientTicks;
import net.silentchaos512.scalinghealth.config.Config;

public final class HeartDisplayHandler
extends Gui {
    public static final HeartDisplayHandler INSTANCE = new HeartDisplayHandler();
    private static final float COLOR_CHANGE_PERIOD = 150.0f;
    private static final ResourceLocation TEXTURE = new ResourceLocation("scalinghealth", "textures/gui/hud.png");
    private long lastSystemTime = 0L;
    private int playerHealth = 0;
    private int lastPlayerHealth = 0;
    private Random rand = new Random();

    private HeartDisplayHandler() {
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onHealthBar(RenderGameOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT && mc.field_71442_b.func_78763_f()) {
            if (Config.Client.Hearts.textStyle != TextStyle.DISABLED) {
                this.renderHealthText((RenderGameOverlayEvent)event, player.func_110143_aJ(), player.func_110138_aP(), -91 + Config.Client.Hearts.textOffsetX, -38 + Config.Client.Hearts.textOffsetY, Config.Client.Hearts.textStyle, Config.Client.Hearts.textColor);
            }
            if (Config.Client.Hearts.absorbTextStyle != TextStyle.DISABLED && player.func_110139_bj() > 0.0f) {
                this.renderHealthText((RenderGameOverlayEvent)event, player.func_110139_bj(), 0.0f, -91 + Config.Client.Hearts.absorbTextOffsetX, -49 + Config.Client.Hearts.absorbTextOffsetY, Config.Client.Hearts.absorbTextStyle, Config.Client.Hearts.absorbTextColor);
            }
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.HEALTH && Config.Client.Hearts.customHeartRendering) {
            event.setCanceled(true);
            this.renderHearts((RenderGameOverlayEvent)event, mc, (EntityPlayer)player);
        }
    }

    private void renderHearts(RenderGameOverlayEvent event, Minecraft mc, EntityPlayer player) {
        boolean hardcoreMode = mc.field_71441_e.func_72912_H().func_76093_s();
        int width = event.getResolution().func_78326_a();
        int height = event.getResolution().func_78328_b();
        GlStateManager.func_179147_l();
        int health = MathHelper.func_76123_f((float)player.func_110143_aJ());
        boolean highlight = player.field_70172_ad / 3 % 2 == 1;
        int updateCounter = ClientTicks.ticksInGame;
        if (health < this.playerHealth && player.field_70172_ad > 0 || health > this.playerHealth && player.field_70172_ad > 0) {
            this.lastSystemTime = Minecraft.func_71386_F();
        }
        if (Minecraft.func_71386_F() - this.lastSystemTime > 1000L) {
            this.playerHealth = health;
            this.lastPlayerHealth = health;
            this.lastSystemTime = Minecraft.func_71386_F();
        }
        this.playerHealth = health;
        int healthLast = this.lastPlayerHealth;
        IAttributeInstance attrMaxHealth = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
        float healthMax = Math.min((float)attrMaxHealth.func_111126_e(), 20.0f);
        float absorb = MathHelper.func_76123_f((float)player.func_110139_bj());
        int healthRows = absorb > 0.0f ? 2 : 1;
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        this.rand.setSeed(updateCounter * 312871);
        int[] lowHealthBob = new int[10];
        for (int i = 0; i < lowHealthBob.length; ++i) {
            lowHealthBob[i] = this.rand.nextInt(2);
        }
        int left = width / 2 - 91;
        int top = height - GuiIngameForge.left_height;
        GuiIngameForge.left_height += healthRows * rowHeight;
        if (rowHeight != 10) {
            GuiIngameForge.left_height += 10 - rowHeight;
        }
        int regen = -1;
        if (player.func_70644_a(MobEffects.field_76428_l)) {
            regen = updateCounter % 25;
        }
        int TOP = 9 * (hardcoreMode ? 5 : 0);
        int BACKGROUND = highlight ? 25 : 16;
        int MARGIN = 16;
        this.drawVanillaHearts(health, highlight, healthLast, healthMax, rowHeight, left, top, regen, lowHealthBob, TOP, BACKGROUND, MARGIN);
        int potionOffset = hardcoreMode ? 27 : 0;
        mc.field_71446_o.func_110577_a(TEXTURE);
        health = MathHelper.func_76123_f((float)player.func_110143_aJ());
        int rowCount = HeartDisplayHandler.getCustomHeartRowCount(health);
        int maxHealthRows = HeartDisplayHandler.getCustomHeartRowCount((int)player.func_110138_aP());
        for (int row = Math.max(0, rowCount - 2); row < rowCount; ++row) {
            boolean anythingDrawn;
            int y;
            int j;
            int actualRow = row + (Config.Client.Hearts.replaceVanillaRow ? 0 : 1);
            int renderHearts = Math.min((health - 20 * actualRow) / 2, 10);
            int rowColor = this.getColorForRow(row, false);
            for (j = 0; j < renderHearts; ++j) {
                y = top + (j == regen ? -2 : 0);
                if (health <= 4) {
                    y += lowHealthBob[MathHelper.func_76125_a((int)j, (int)0, (int)(lowHealthBob.length - 1))];
                }
                this.drawTexturedModalRect(left + 8 * j, y, 0, potionOffset, 9, 9, rowColor);
            }
            boolean bl = anythingDrawn = j > 0;
            if (health % 2 == 1 && renderHearts < 10) {
                y = top + (j == regen ? -2 : 0);
                if (health <= 4) {
                    y += lowHealthBob[MathHelper.func_76125_a((int)j, (int)0, (int)(lowHealthBob.length - 1))];
                }
                this.drawTexturedModalRect(left + 8 * renderHearts, y, 9, potionOffset, 9, 9, rowColor);
                anythingDrawn = true;
            }
            if (!Config.Client.Hearts.lastHeartOutline || !anythingDrawn || row != maxHealthRows - 1) continue;
            j = (int)Math.ceil(player.func_110138_aP() % 20.0f / 2.0f) - 1;
            if (j < 0) {
                j += 10;
            }
            y = top + (j == regen ? -2 : 0);
            if (health <= 4) {
                y += lowHealthBob[MathHelper.func_76125_a((int)j, (int)0, (int)(lowHealthBob.length - 1))];
            }
            this.drawTexturedModalRect(left + 8 * j, y, 17, 9, 9, 9, Config.Client.Hearts.lastHeartOutlineColor);
        }
        for (int i = 0; i < 10 && (double)i < Math.ceil((float)health / 2.0f); ++i) {
            int y = top + (i == regen ? -2 : 0);
            if (health <= 4) {
                y += lowHealthBob[MathHelper.func_76125_a((int)i, (int)0, (int)(lowHealthBob.length - 1))];
            }
            if (this.showEffectHearts(player)) {
                int color = this.effectHeartColor(player);
                this.drawTexturedModalRect(left + 8 * i, y, 0, 54, 9, 9, color);
            }
            if (hardcoreMode) continue;
            this.drawTexturedModalRect(left + 8 * i, y, 17, 0, 9, 9, -855638017);
        }
        if (Config.Client.Hearts.absorptionStyle != AbsorptionHeartStyle.VANILLA) {
            int y;
            int i;
            int absorbCeil = (int)Math.ceil(absorb);
            rowCount = (int)Math.ceil(absorb / 20.0f);
            int texX = 17;
            int texY = Config.Client.Hearts.absorptionStyle == AbsorptionHeartStyle.SHIELD ? 45 : 54;
            for (i = 0; i < 10 && (float)i < absorb / 2.0f; ++i) {
                y = top - 10 + (i == regen - 10 ? -2 : 0);
                this.drawTexturedModalRect(left + 8 * i, y, texX, texY, 9, 9, 0xFFFFFF);
            }
            texX = Config.Client.Hearts.absorptionStyle == AbsorptionHeartStyle.SHIELD ? 26 : 0;
            texY = Config.Client.Hearts.absorptionStyle == AbsorptionHeartStyle.SHIELD ? 0 : potionOffset;
            for (i = Math.max(0, rowCount - 2); i < rowCount; ++i) {
                boolean anythingDrawn;
                int y2;
                int x;
                int renderHearts = Math.min((absorbCeil - 20 * i) / 2, 10);
                int rowColor = this.getColorForRow(i, true);
                for (x = 0; x < renderHearts; ++x) {
                    y2 = top - 10 + (x == regen - 10 ? -2 : 0);
                    this.drawTexturedModalRect(left + 8 * x, y2, texX, texY, 9, 9, rowColor);
                }
                boolean bl = anythingDrawn = x > 0;
                if (absorbCeil % 2 != 1 || renderHearts >= 10) continue;
                y2 = top - 10 + (x == regen - 10 ? -2 : 0);
                this.drawTexturedModalRect(left + 8 * renderHearts, y2, texX + 9, texY, 9, 9, rowColor);
                anythingDrawn = true;
            }
            for (i = 0; i < 10 && (float)i < absorb / 2.0f; ++i) {
                y = top - 10 + (i == regen - 10 ? -2 : 0);
                if (Config.Client.Hearts.absorptionStyle == AbsorptionHeartStyle.SHIELD) {
                    this.drawTexturedModalRect(left + 8 * i, y, 17, 36, 9, 9, 0xFFFFFF);
                } else if (Config.Client.Hearts.absorptionStyle == AbsorptionHeartStyle.GOLD_OUTLINE) {
                    this.drawTexturedModalRect(left + 8 * i, y, 17, 27, 9, 9, 0xFFFFFF);
                }
                if (hardcoreMode && Config.Client.Hearts.absorptionStyle != AbsorptionHeartStyle.SHIELD) continue;
                this.drawTexturedModalRect(left + 8 * i, y, 17, 0, 9, 9, -855638017);
            }
        }
        GlStateManager.func_179084_k();
        mc.field_71446_o.func_110577_a(Gui.field_110324_m);
    }

    private static int getCustomHeartRowCount(int health) {
        return Config.Client.Hearts.replaceVanillaRow ? MathHelper.func_76123_f((float)((float)health / 20.0f)) : health / 20;
    }

    private void drawVanillaHearts(int health, boolean highlight, int healthLast, float healthMax, int rowHeight, int left, int top, int regen, int[] lowHealthBob, int TOP, int BACKGROUND, int MARGIN) {
        int iStart;
        float absorb;
        float absorbRemaining = absorb = (float)MathHelper.func_76123_f((float)Minecraft.func_71410_x().field_71439_g.func_110139_bj());
        float healthTotal = (float)health + absorb;
        for (int i = iStart = MathHelper.func_76123_f((float)((healthMax + (Config.Client.Hearts.absorptionStyle == AbsorptionHeartStyle.VANILLA ? absorb : 0.0f)) / 2.0f)) - 1; i >= 0; --i) {
            int row = MathHelper.func_76123_f((float)((float)(i + 1) / 10.0f)) - 1;
            int x = left + i % 10 * 8;
            int y = top - row * rowHeight;
            if (health <= 4) {
                y += lowHealthBob[MathHelper.func_76125_a((int)i, (int)0, (int)(lowHealthBob.length - 1))];
            }
            if (i == regen) {
                y -= 2;
            }
            this.func_73729_b(x, y, BACKGROUND, TOP, 9, 9);
            if (highlight) {
                if (i * 2 + 1 < healthLast) {
                    this.func_73729_b(x, y, MARGIN + 54, TOP, 9, 9);
                } else if (i * 2 + 1 == healthLast) {
                    this.func_73729_b(x, y, MARGIN + 63, TOP, 9, 9);
                }
            }
            if (absorbRemaining > 0.0f && Config.Client.Hearts.absorptionStyle == AbsorptionHeartStyle.VANILLA) {
                if (absorbRemaining == absorb && absorb % 2.0f == 1.0f) {
                    this.func_73729_b(x, y, MARGIN + 153, TOP, 9, 9);
                    absorbRemaining -= 1.0f;
                    continue;
                }
                if ((float)(i * 2 + 1) < healthTotal) {
                    this.func_73729_b(x, y, MARGIN + 144, TOP, 9, 9);
                }
                absorbRemaining -= 2.0f;
                continue;
            }
            if (i * 2 + 1 < health) {
                this.func_73729_b(x, y, MARGIN + 36, TOP, 9, 9);
                continue;
            }
            if (i * 2 + 1 != health) continue;
            this.func_73729_b(x, y, MARGIN + 45, TOP, 9, 9);
        }
    }

    private void renderHealthText(RenderGameOverlayEvent event, float current, float max, int offsetX, int offsetY, TextStyle style, TextColor styleColor) {
        int color;
        float scale = style.scale;
        int width = event.getResolution().func_78326_a();
        int height = event.getResolution().func_78328_b();
        int left = (int)((float)(width / 2 + offsetX) / scale);
        int top = (int)(((float)(height + offsetY) + 1.0f / scale) / scale);
        String healthString = style.textFor(current, max);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int stringWidth = fontRenderer.func_78256_a(healthString);
        float divisor = max == 0.0f ? current : max;
        switch (styleColor) {
            case GREEN_TO_RED: {
                color = Color.HSBtoRGB(0.34f * current / divisor, 0.7f, 1.0f);
                break;
            }
            case PSYCHEDELIC: {
                color = Color.HSBtoRGB((float)ClientTicks.ticksInGame % 150.0f / 150.0f, 0.55f * current / divisor, 1.0f);
                break;
            }
            case SOLID: {
                color = Config.Client.Hearts.textSolidColor;
                break;
            }
            default: {
                color = 0xDDDDDD;
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        fontRenderer.func_175063_a(healthString, (float)(left - stringWidth - 2), (float)top, color);
        GlStateManager.func_179121_F();
    }

    private void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        if (a <= 0.0f) {
            a = 1.0f;
        }
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        this.func_73729_b(x, y, textureX, textureY, width, height);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private int getColorForRow(int row, boolean absorption) {
        int[] colors = absorption ? Config.Client.Hearts.absorptionHeartColors : Config.Client.Hearts.heartColors;
        int index = Config.Client.Hearts.heartColorLooping ? row % colors.length : MathHelper.func_76125_a((int)row, (int)0, (int)(colors.length - 1));
        return colors[index];
    }

    private boolean showEffectHearts(EntityPlayer player) {
        return player.func_70644_a(MobEffects.field_76436_u) || player.func_70644_a(MobEffects.field_82731_v);
    }

    private int effectHeartColor(EntityPlayer player) {
        if (player.func_70644_a(MobEffects.field_82731_v)) {
            return 6700615;
        }
        if (player.func_70644_a(MobEffects.field_76436_u)) {
            return 5149489;
        }
        return 0xFFFFFF;
    }

    public static enum AbsorptionHeartStyle {
        SHIELD,
        GOLD_OUTLINE,
        VANILLA;

        public static final String COMMENT = "Determines how absorption hearts should be rendered.";

        public static AbsorptionHeartStyle loadDromConfig(ConfigBase config) {
            return (AbsorptionHeartStyle)config.loadEnum("Absorption Heart Style", "main.client", AbsorptionHeartStyle.class, (Enum)SHIELD, COMMENT);
        }
    }

    public static enum TextColor {
        GREEN_TO_RED,
        WHITE,
        PSYCHEDELIC,
        SOLID;

        public static final String COMMENT = "Determines the color of the text next to your hearts. GREEN_TO_RED displays green at full health, and moves to red as you lose health (does not work with absorption). WHITE will just be good old fashioned white text. Set to PSYCHEDELIC if you want to taste the rainbow. SOLID is a fixed color";

        public static TextColor loadFromConfig(ConfigBase config, String name, TextColor defaultValue) {
            return (TextColor)config.loadEnum(name, "main.client", TextColor.class, (Enum)defaultValue, COMMENT);
        }
    }

    public static enum TextStyle {
        DISABLED(1.0f){

            @Override
            public String textFor(float current, float max) {
                return "";
            }
        }
        ,
        ROWS(0.65f){

            @Override
            public String textFor(float current, float max) {
                return (int)Math.ceil(current / 20.0f) + "x";
            }
        }
        ,
        HEALTH_AND_MAX(0.5f){

            @Override
            public String textFor(float current, float max) {
                if (max == 0.0f) {
                    return HEALTH_ONLY.textFor(current, max);
                }
                return Math.round(current) + "/" + Math.round(max);
            }
        }
        ,
        HEALTH_ONLY(0.5f){

            @Override
            public String textFor(float current, float max) {
                return String.valueOf(Math.round(current));
            }
        };

        private static final String COMMENT = "Determines what the text next to your hearts will display. DISABLED will display nothing, ROWS will display the number of remaining rows that have health left, and HEALTH_AND_MAX will display your actual health and max health values (for absorption, there is no max value). HEALTH_ONLY displays just the current amount.";
        private final float scale;

        private TextStyle(float scale) {
            this.scale = scale;
        }

        public static TextStyle loadFromConfig(ConfigBase config, String name, TextStyle defaultValue) {
            return (TextStyle)config.loadEnum(name, "main.client", TextStyle.class, (Enum)defaultValue, COMMENT);
        }

        public abstract String textFor(float var1, float var2);
    }
}

