/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.tanspit.blocks;

import com.github.wolfiewaffle.tanspit.TANSpit;
import com.github.wolfiewaffle.tanspit.tileentity.TileEntitySpit;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.IItemHandler;
import toughasnails.api.TANBlocks;

public class BlockSpit
extends BlockContainer {
    public BlockSpit(String name) {
        super(Material.field_151574_g);
        this.func_149647_a(CreativeTabs.field_78026_f);
        this.func_149675_a(true);
        this.setRegistryName(name);
        this.func_149663_c(name);
        this.func_149713_g(0);
        this.field_149787_q = false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntitySpit();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        boolean hasSoundPlayed = false;
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (!(tileEntity instanceof TileEntitySpit) || playerIn.func_70093_af()) {
            return false;
        }
        TileEntitySpit te = (TileEntitySpit)tileEntity;
        ItemStack item = playerIn.func_184586_b(hand);
        for (int i = 0; i < te.inventory().getSlots(); ++i) {
            if (!item.func_190926_b()) {
                for (int z = 0; z < TANSpit.CONFIG.itemList.length; ++z) {
                    if (!(Item.field_150901_e.func_82594_a((Object)new ResourceLocation(TANSpit.CONFIG.itemList[z])) == item.func_77973_b() ? TANSpit.CONFIG.isItemListBlacklist : !TANSpit.CONFIG.isItemListBlacklist && z == TANSpit.CONFIG.itemList.length - 1)) continue;
                    return true;
                }
                if (!te.inventory().getStackInSlot(i).func_190926_b()) continue;
                if (te.inventory().insertItem(i, new ItemStack(item.func_77973_b(), 1, item.func_77952_i()), false).func_190926_b()) {
                    playerIn.func_184586_b(hand).func_190918_g(1);
                    worldIn.func_184148_a((EntityPlayer)null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187626_cN, SoundCategory.BLOCKS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
                }
                return true;
            }
            if (te.inventory().getStackInSlot(i).func_190926_b()) continue;
            this.onCrafting(playerIn, te.inventory().getStackInSlot(i));
            playerIn.field_71071_by.func_70441_a(te.inventory().getStackInSlot(i));
            te.inventory().extractItem(i, 1, false);
            if (hasSoundPlayed) continue;
            worldIn.func_184148_a((EntityPlayer)null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187629_cO, SoundCategory.BLOCKS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
            hasSoundPlayed = true;
        }
        return true;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        if (side != EnumFacing.UP || worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() != TANBlocks.campfire) {
            return false;
        }
        return super.func_176198_a(worldIn, pos, side);
    }

    protected void onCrafting(EntityPlayer player, ItemStack stack) {
        stack.func_77980_a(player.field_70170_p, player, stack.func_190916_E());
        if (!player.field_70170_p.field_72995_K) {
            int itemCount = stack.func_190916_E();
            float xpFloat = FurnaceRecipes.func_77602_a().func_151398_b(stack);
            if (xpFloat == 0.0f) {
                itemCount = 0;
            } else if (xpFloat < 1.0f) {
                int j = MathHelper.func_76141_d((float)((float)itemCount * xpFloat));
                if (j < MathHelper.func_76123_f((float)((float)itemCount * xpFloat)) && Math.random() < (double)((float)itemCount * xpFloat - (float)j)) {
                    ++j;
                }
                itemCount = j;
            }
            while (itemCount > 0) {
                int k = EntityXPOrb.func_70527_a((int)itemCount);
                itemCount -= k;
                player.field_70170_p.func_72838_d((Entity)new EntityXPOrb(player.field_70170_p, player.field_70165_t, player.field_70163_u + 0.5, player.field_70161_v + 0.5, k));
            }
        }
        FMLCommonHandler.instance().firePlayerSmeltedEvent(player, stack);
    }

    public boolean canBlockStay(World worldIn, BlockPos pos, IBlockState state) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == TANBlocks.campfire;
    }

    public void observedNeighborChange(IBlockState observerState, World world, BlockPos observerPos, Block changedBlock, BlockPos changedBlockPos) {
        this.checkAndDropBlock(world, observerPos, observerState);
        super.observedNeighborChange(observerState, world, observerPos, changedBlock, changedBlockPos);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.checkAndDropBlock(worldIn, pos, state);
    }

    protected void checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(worldIn, pos, state)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntitySpit();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntitySpit) {
            BlockSpit.dropInventoryItems(worldIn, pos, ((TileEntitySpit)tileentity).inventory());
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
        worldIn.func_175713_t(pos);
    }

    private static void dropInventoryItems(World worldIn, BlockPos pos, IItemHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack itemstack = inventory.getStackInSlot(i);
            if (itemstack.func_190916_E() <= 0) continue;
            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemstack);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        super.func_176208_a(worldIn, pos, state, player);
        if (!player.field_71075_bZ.field_75098_d) {
            this.func_176226_b(worldIn, pos, state, 0);
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }
}

