/*
 * Decompiled with CFR 0.152.
 */
package com.github.wolfiewaffle.tanspit.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import toughasnails.api.TANBlocks;
import toughasnails.block.BlockTANCampfire;

public class TileEntitySpit
extends TileEntity
implements ITickable {
    public int cookTimeRemaining = 700;
    private static final int totalTime = 700;
    public ItemStackHandler items = new ItemStackHandler(3){

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack != null && stack.func_77973_b() instanceof ItemFood && FurnaceRecipes.func_77602_a().func_151395_a(stack) != null && FurnaceRecipes.func_77602_a().func_151395_a(stack).func_77973_b() instanceof ItemFood) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntitySpit.this.func_70296_d();
            IBlockState state = TileEntitySpit.this.field_145850_b.func_180495_p(TileEntitySpit.this.field_174879_c);
            TileEntitySpit.this.field_145850_b.func_184138_a(TileEntitySpit.this.field_174879_c, state, state, 3);
        }
    };

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, tag);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.func_145839_a(packet.func_148857_g());
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    private boolean isCooking() {
        IBlockState down = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
        return down.func_177230_c() == TANBlocks.campfire && (Boolean)down.func_177229_b((IProperty)BlockTANCampfire.BURNING) != false;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.isCooking() && this.canCookAnything()) {
                --this.cookTimeRemaining;
                if (this.cookTimeRemaining <= 0) {
                    for (int i = 0; i < this.inventory().getSlots(); ++i) {
                        ItemStack stack = this.items.getStackInSlot(i);
                        if (TileEntitySpit.getCookingResult(stack).func_190926_b() || stack.func_190926_b()) continue;
                        this.items.setStackInSlot(i, TileEntitySpit.getCookingResult(stack));
                    }
                    this.cookTimeRemaining = 700;
                }
                this.func_70296_d();
            } else if (this.cookTimeRemaining < 700) {
                ++this.cookTimeRemaining;
                this.func_70296_d();
            }
        }
    }

    public static ItemStack getCookingResult(ItemStack stack) {
        return FurnaceRecipes.func_77602_a().func_151395_a(stack).func_77946_l();
    }

    private boolean canCookAnything() {
        for (int i = 0; i < this.inventory().getSlots(); ++i) {
            if (FurnaceRecipes.func_77602_a().func_151395_a(this.items.getStackInSlot(i)).func_77946_l().func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.items;
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74782_a("Items", (NBTBase)this.items.serializeNBT());
        compound.func_74768_a("CookTime", (int)((short)this.cookTimeRemaining));
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.items.deserializeNBT(compound.func_74775_l("Items"));
        this.cookTimeRemaining = compound.func_74762_e("CookTime");
    }

    public IItemHandler inventory() {
        return this.items;
    }
}

