/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.spawnercontrol.config;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Arrays;
import java.util.List;
import ladysnake.spawnercontrol.SpawnerControl;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;

public class SpawnerConfig {
    @Config.Comment(value={"Regroups config options aiming to alter mob spawners spawning conditions"})
    public SpawnConditions spawnConditions = new SpawnConditions();
    @Config.Comment(value={"Groups config options related to custom drops from mobs spawned by this spawner type"})
    public MobLoot mobLoot = new MobLoot();
    @Config.Comment(value={"When a spawner has spawned this number of mobs over this lifetime, it will get broken automatically"})
    public int mobThreshold = 100;
    @Config.Comment(value={"If set to true, spawners will count mobs when they are killed rather than when they are spawned"})
    public boolean incrementOnMobDeath = false;
    @Config.Comment(value={"This multiplier is applied on the spawner's spawn delay each time a mob is spawned. \nCan be used to make mobs spawned exponentially faster or slower."})
    public float spawnRateModifier = 1.0f;
    @Config.Comment(value={"If set to false, spawners will only be disabled when expired, not broken"})
    public boolean breakSpawner = true;
    @Config.Comment(value={"The minimum amount of xp dropped by a spawner when broken"})
    public int xpDropped = 15;
    @Config.RangeInt(min=0)
    @Config.Comment(value={"The formula used to calculate xp dropped is 'xpDropped + rand(this number) + rand(this number)'"})
    public int randXpVariation = 15;
    @Config.Comment(value={"A list of item ids that a mob spawner drops when broken", "Format: 'modid:item(:count(:meta(:chance)))' (count, meta and chance are optional)"})
    public String[] itemsDropped = new String[0];

    public static class MobLoot {
        public MobLootEntry defaultValues = new MobLootEntry(1.0f, 0, false, new String[0], new String[0]);
        @Config.Comment(value={"Individual xp drop multiplier configuration for mobs spawned by this spawner type", "Format: 'modid:entity:xpMultiplier(:flatXp)' (flatXp is optional)"})
        public String[] xpMultipliers = new String[0];
        @Config.Comment(value={"Individual item drop removal configuration for mobs spawned by this spawner type", "Format: 'modid:entity(,modid:item(:meta))(,modid:item(:meta))...'", "Anything in parenthesis is optional, and you can enter as many items as you want", "If don't enter any items, all item drops are removed from the mob (itemDropAdditions are added afterwards)"})
        public String[] itemDropRemovals = new String[0];
        @Config.Comment(value={"Individual item drop addition configuration for mobs spawned by this spawner type", "Format: 'modid:entity,modid:item(:count(:meta(:chance)))(,modid:item(:count(:meta(:chance))))...'", "Anything in parenthesis is optional, and you can enter as many items as you want", "Eg: minecraft:skeleton,minecraft:dye:100:15:0.5,minecraft:bone:1:1:1"})
        public String[] itemDropAdditions = new String[0];
        @Config.Ignore
        public LoadingCache<ResourceLocation, MobLootEntry> lootEntries = CacheBuilder.newBuilder().build(CacheLoader.from(rl -> {
            String[] split;
            if (rl == null) {
                return this.defaultValues;
            }
            float xpMultiplier = this.defaultValues.xpMultiplier;
            int flatXpIncrease = this.defaultValues.flatXpIncrease;
            boolean removeAllItems = this.defaultValues.removeAllItems;
            List<String> removedItems = Arrays.asList(this.defaultValues.removedItems);
            List<String> addedItems = Arrays.asList(this.defaultValues.addedItems);
            for (String s : this.xpMultipliers) {
                split = s.split(":");
                if (!split[0].equals(rl.func_110623_a()) || !split[1].equals(rl.func_110624_b())) continue;
                try {
                    xpMultiplier = Float.parseFloat(split[2]);
                    flatXpIncrease = split.length > 3 ? Integer.parseInt(split[3]) : this.defaultValues.flatXpIncrease;
                }
                catch (NumberFormatException e) {
                    SpawnerControl.LOGGER.warn("Bad mob spawner loot config option : {}", (Object)s);
                }
                break;
            }
            for (String s : this.itemDropRemovals) {
                split = s.split(",");
                String[] mobSplit = split[0].split(":");
                if (!mobSplit[0].equals(rl.func_110623_a()) || !mobSplit[1].equals(rl.func_110624_b())) continue;
                try {
                    removedItems = Arrays.asList(split);
                    removedItems.remove(0);
                    removeAllItems = removedItems.size() == 0;
                }
                catch (Exception e) {
                    SpawnerControl.LOGGER.warn("Bad mob spawner loot config option : {}", (Object)s);
                }
                break;
            }
            for (String s : this.itemDropAdditions) {
                split = s.split(":");
                if (!split[0].equals(rl.func_110623_a()) || !split[1].equals(rl.func_110624_b())) continue;
                try {
                    addedItems = Arrays.asList(split);
                    addedItems.remove(0);
                }
                catch (Exception e) {
                    SpawnerControl.LOGGER.warn("Bad mob spawner loot config option : {}", (Object)s);
                }
                break;
            }
            return new MobLootEntry(xpMultiplier, flatXpIncrease, removeAllItems, removedItems.toArray(new String[0]), addedItems.toArray(new String[0]));
        }));

        public static class MobLootEntry {
            @Config.Comment(value={"xp drop multiplier for mobs spawned by this spawner type"})
            public float xpMultiplier;
            @Config.Comment(value={"Flat xp modifier that will be added to mobs spawned by this spawner type"})
            public int flatXpIncrease;
            @Config.Comment(value={"Remove all existing item drops from the mobs spawned by this spawner", "'Added Items' are added afterwards"})
            public boolean removeAllItems;
            @Config.Comment(value={"Which items to remove from the drops of the mobs spawned", "Format: 'modid:item(:meta)' (meta is optional)", "If 'Remove All Items' is true, this does nothing"})
            public String[] removedItems;
            @Config.Comment(value={"Which items to add to the drops of the mobs spawned", "Format: 'modid:item(:count(:meta(:chance)))' (count, meta and chance are optional)"})
            public String[] addedItems;

            public MobLootEntry(float defaultXpMultiplier, int flatXpIncrease, boolean removeAllItems, String[] removedItems, String[] addedItems) {
                this.xpMultiplier = defaultXpMultiplier;
                this.flatXpIncrease = flatXpIncrease;
                this.removeAllItems = removeAllItems;
                this.removedItems = removedItems;
                this.addedItems = addedItems;
            }
        }
    }

    public static class SpawnConditions {
        @Config.Comment(value={"If set to true, spawners will not run mob-specific checks on any entity"})
        public boolean forceSpawnerAllSpawns = false;
        @Config.Comment(value={"If set to true, spawners will not run mob-specific checks on hostile mob entities", "This most notably prevents players from disabling a spawner with torches or other light sources"})
        public boolean forceSpawnerMobSpawns = false;
        @Config.Comment(value={"If forceSpawnerMobSpawns is enabled, will prevent hostile mobs from spawning in daylight"})
        public boolean checkSunlight = true;
    }
}

