/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.notreepunching.common.items;

import com.alcatrazescapee.alcatrazcore.item.ItemCore;
import com.alcatrazescapee.alcatrazcore.util.CoreHelpers;
import com.alcatrazescapee.alcatrazcore.util.OreDictionaryHelper;
import com.alcatrazescapee.alcatrazcore.util.RegistryHelper;
import com.alcatrazescapee.alcatrazcore.util.collections.ImmutableEnumTable;
import com.alcatrazescapee.notreepunching.ModConfig;
import com.alcatrazescapee.notreepunching.client.ModTabs;
import com.alcatrazescapee.notreepunching.common.ModMaterials;
import com.alcatrazescapee.notreepunching.common.items.ItemCeramicBucket;
import com.alcatrazescapee.notreepunching.common.items.ItemClayTool;
import com.alcatrazescapee.notreepunching.common.items.ItemFireStarter;
import com.alcatrazescapee.notreepunching.common.items.ItemRock;
import com.alcatrazescapee.notreepunching.common.items.ItemSmallVessel;
import com.alcatrazescapee.notreepunching.util.types.Metal;
import com.alcatrazescapee.notreepunching.util.types.Stone;
import com.alcatrazescapee.notreepunching.util.types.ToolType;
import com.google.common.collect.ImmutableMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

@GameRegistry.ObjectHolder(value="notreepunching")
public final class ModItems {
    public static final Item FLINT_SHARD = (Item)CoreHelpers.getNull();
    public static final Item GRASS_FIBER = (Item)CoreHelpers.getNull();
    public static final Item GRASS_STRING = (Item)CoreHelpers.getNull();
    public static final Item CLAY_BRICK = (Item)CoreHelpers.getNull();
    public static final Item CERAMIC_SMALL_VESSEL = (Item)CoreHelpers.getNull();
    public static final Item CERAMIC_BUCKET = (Item)CoreHelpers.getNull();
    public static final Item CLAY_TOOL = (Item)CoreHelpers.getNull();
    public static final Item FIRE_STARTER = (Item)CoreHelpers.getNull();
    private static ImmutableMap<ToolType, Item> FLINT_TOOLS;
    private static ImmutableEnumTable<ToolType, Metal, Item> METAL_TOOLS;

    public static Item getFlintTool(ToolType type) {
        return (Item)FLINT_TOOLS.get((Object)type);
    }

    public static Item getTool(ToolType type, Metal metal) {
        return (Item)METAL_TOOLS.get((Object)type, (Object)metal);
    }

    public static void preInit() {
        RegistryHelper r = RegistryHelper.get((String)"notreepunching");
        r.registerItem((Item)new ItemCore(), "grass_fiber", ModTabs.TAB_ITEMS);
        r.registerItem((Item)new ItemClayTool(), "clay_tool", ModTabs.TAB_TOOLS);
        r.registerItem((Item)new ItemFireStarter(), "fire_starter", ModTabs.TAB_TOOLS);
        r.registerItem((Item)new ItemSmallVessel(), "ceramic_small_vessel", ModTabs.TAB_ITEMS);
        r.registerItem((Item)new ItemCeramicBucket(), "ceramic_bucket", ModTabs.TAB_ITEMS);
        ItemCore item = new ItemCore();
        r.registerItem((Item)item, "grass_string", ModTabs.TAB_ITEMS);
        OreDictionaryHelper.register((Item)item, (Object[])new Object[]{"kindling"});
        OreDictionaryHelper.register((Item)item, (Object[])new Object[]{"string"});
        item = new ItemCore();
        r.registerItem((Item)item, "flint_shard", ModTabs.TAB_ITEMS);
        OreDictionaryHelper.register((Item)item, (Object[])new Object[]{"shard", "flint"});
        item = new ItemCore();
        r.registerItem((Item)item, "clay_brick", ModTabs.TAB_ITEMS);
        OreDictionaryHelper.register((Item)item, (Object[])new Object[]{"brick", "clay"});
        for (Stone type : Stone.values()) {
            if (!type.isEnabled()) continue;
            r.registerItem((Item)new ItemRock(type), "rock/" + type.name(), ModTabs.TAB_ITEMS);
        }
        ImmutableMap.Builder flintTools = new ImmutableMap.Builder();
        ImmutableEnumTable.Builder metalTools = new ImmutableEnumTable.Builder(ToolType.class, Metal.class);
        for (ToolType type : ToolType.values()) {
            if (type.isFlintTool) {
                item = type.createFlint(ModMaterials.TOOL_FLINT);
                flintTools.put((Object)type, (Object)r.registerItem((Item)item, type.name() + "/flint", ModTabs.TAB_TOOLS));
                OreDictionaryHelper.register((Item)item, (Object[])new Object[]{"tool", "weak", type.name()});
            }
            if (!type.isNewTool) continue;
            for (Metal metal : Metal.values()) {
                if (!metal.isEnabled) continue;
                item = r.registerItem(type.createTool(metal.toolMaterial), type.name() + "/" + metal.name(), ModTabs.TAB_TOOLS);
                metalTools.put((Enum)type, (Enum)metal, (Object)item);
                OreDictionaryHelper.register((Item)item, (Object[])new Object[]{"tool", type.name()});
            }
        }
        FLINT_TOOLS = flintTools.build();
        METAL_TOOLS = metalTools.build();
    }

    public static void init() {
        OreDictionary.registerOre((String)"kindling", (Item)Items.field_151121_aF);
        OreDictionary.registerOre((String)"kindling", (Block)Blocks.field_150407_cf);
        OreDictionaryHelper.register((Item)CLAY_TOOL, (Object[])new Object[]{"tool", "clay"});
        if (ModConfig.GENERAL.replaceVanillaRecipes) {
            Items.field_151053_p.func_77637_a(null);
            Items.field_151017_I.func_77637_a(null);
            Items.field_151039_o.func_77637_a(null);
            Items.field_151038_n.func_77637_a(null);
            Items.field_151041_m.func_77637_a(null);
            Items.field_151049_t.func_77637_a(null);
            Items.field_151018_J.func_77637_a(null);
            Items.field_151050_s.func_77637_a(null);
            Items.field_151051_r.func_77637_a(null);
            Items.field_151052_q.func_77637_a(null);
        }
    }
}

