/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.entity.ai;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.init.ModItems;
import xzeroair.trinkets.util.Reference;

public class EnderAiEdit
extends EntityAINearestAttackableTarget<EntityPlayer> {
    private final EntityEnderman enderman;
    private EntityPlayer player;
    private int aggroTime;
    private int teleportTime;

    public EnderAiEdit(EntityEnderman enderman) {
        super((EntityCreature)enderman, EntityPlayer.class, false);
        this.enderman = enderman;
    }

    private boolean shouldAttackPlayer(EntityPlayer player) {
        ItemStack itemstack = (ItemStack)player.field_71071_by.field_70460_b.get(3);
        boolean eye = TrinketHelper.AccessoryCheck((EntityLivingBase)player, ModItems.trinkets.TrinketDragonsEye);
        boolean tiara = TrinketHelper.AccessoryCheck((EntityLivingBase)player, ModItems.trinkets.TrinketEnderTiara);
        if (tiara || eye || itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150423_aK)) {
            return false;
        }
        Vec3d vec3d = player.func_70676_i(1.0f).func_72432_b();
        Vec3d vec3d1 = new Vec3d(this.enderman.field_70165_t - player.field_70165_t, this.enderman.func_174813_aQ().field_72338_b + (double)this.enderman.func_70047_e() - (player.field_70163_u + (double)player.func_70047_e()), this.enderman.field_70161_v - player.field_70161_v);
        double d0 = vec3d1.func_72433_c();
        double d1 = vec3d.func_72430_b(vec3d1 = vec3d1.func_72432_b());
        return d1 > 1.0 - 0.025 / d0 ? player.func_70685_l((Entity)this.enderman) : false;
    }

    protected boolean teleportRandomly() {
        double d0 = this.enderman.field_70165_t + (Reference.random.nextDouble() - 0.5) * 64.0;
        double d1 = this.enderman.field_70163_u + (double)(Reference.random.nextInt(64) - 32);
        double d2 = this.enderman.field_70161_v + (Reference.random.nextDouble() - 0.5) * 64.0;
        return this.teleportTo(d0, d1, d2);
    }

    protected boolean teleportToEntity(Entity p_70816_1_) {
        Vec3d vec3d = new Vec3d(this.enderman.field_70165_t - p_70816_1_.field_70165_t, this.enderman.func_174813_aQ().field_72338_b + (double)(this.enderman.field_70131_O / 2.0f) - p_70816_1_.field_70163_u + (double)p_70816_1_.func_70047_e(), this.enderman.field_70161_v - p_70816_1_.field_70161_v);
        vec3d = vec3d.func_72432_b();
        double d0 = 16.0;
        double d1 = this.enderman.field_70165_t + (Reference.random.nextDouble() - 0.5) * 8.0 - vec3d.field_72450_a * 16.0;
        double d2 = this.enderman.field_70163_u + (double)(Reference.random.nextInt(16) - 8) - vec3d.field_72448_b * 16.0;
        double d3 = this.enderman.field_70161_v + (Reference.random.nextDouble() - 0.5) * 8.0 - vec3d.field_72449_c * 16.0;
        return this.teleportTo(d1, d2, d3);
    }

    private boolean teleportTo(double x, double y, double z) {
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this.enderman, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        boolean flag = this.enderman.func_184595_k(event.getTargetX(), event.getTargetY(), event.getTargetZ());
        if (flag) {
            this.enderman.field_70170_p.func_184148_a((EntityPlayer)null, this.enderman.field_70169_q, this.enderman.field_70167_r, this.enderman.field_70166_s, SoundEvents.field_187534_aX, this.enderman.func_184176_by(), 1.0f, 1.0f);
            this.enderman.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return flag;
    }

    public boolean func_75250_a() {
        double d0 = this.func_111175_f();
        this.player = this.enderman.field_70170_p.func_184150_a(this.enderman.field_70165_t, this.enderman.field_70163_u, this.enderman.field_70161_v, d0, d0, (Function)null, (Predicate)new Predicate<EntityPlayer>(){

            public boolean apply(@Nullable EntityPlayer p_apply_1_) {
                return p_apply_1_ != null && EnderAiEdit.this.shouldAttackPlayer(p_apply_1_);
            }
        });
        return this.player != null;
    }

    public void func_75249_e() {
        this.aggroTime = 5;
        this.teleportTime = 0;
    }

    public void func_75251_c() {
        this.player = null;
        super.func_75251_c();
    }

    public boolean func_75253_b() {
        if (this.player != null) {
            if (!this.shouldAttackPlayer(this.player)) {
                return false;
            }
            this.enderman.func_70625_a((Entity)this.player, 10.0f, 10.0f);
            return true;
        }
        return this.field_75309_a != null && ((EntityPlayer)this.field_75309_a).func_70089_S() ? true : super.func_75253_b();
    }

    public void func_75246_d() {
        if (this.player != null) {
            if (--this.aggroTime <= 0) {
                this.field_75309_a = this.player;
                this.player = null;
                super.func_75249_e();
            }
        } else {
            if (this.field_75309_a != null) {
                if (this.shouldAttackPlayer((EntityPlayer)this.field_75309_a)) {
                    if (((EntityPlayer)this.field_75309_a).func_70068_e((Entity)this.enderman) < 16.0) {
                        this.teleportRandomly();
                    }
                    this.teleportTime = 0;
                } else if (((EntityPlayer)this.field_75309_a).func_70068_e((Entity)this.enderman) > 256.0 && this.teleportTime++ >= 30 && this.teleportToEntity((Entity)this.field_75309_a)) {
                    this.teleportTime = 0;
                }
            }
            super.func_75246_d();
        }
    }
}

