/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.enums;

public enum TargetOreType {
    coal(0, "Coal", 0x464646),
    iron(1, "Iron", 0xFFCC99),
    gold(2, "Gold", 16766720),
    diamond(3, "Diamond", 59135),
    emerald(4, "Emerald", 65357),
    lapis(5, "Lapis", 2515356),
    redstone(6, "Redstone", 11546150),
    quarts(7, "Quartz", 0xEBEBEB),
    chest(8, "Chest", 16766720),
    tin(9, "Tin", 6913940),
    copper(10, "Copper", 9913358),
    aluminum(11, "Aluminum", 0x7D7D7F),
    silver(12, "Silver", 8096660),
    lead(13, "Lead", 4739441),
    nickel(14, "Nickel", 8223586),
    platinum(15, "Platinum", 2123927),
    iridium(16, "Iridium", 7565953),
    cobalt(17, "Cobalt", 18347),
    ardite(18, "Ardite", 7823905);

    private static final TargetOreType[] ID;
    private int type;
    private String name;
    private final float[] oreColor;

    private TargetOreType(int type, String name, int colorValueIn) {
        this.type = type;
        this.name = name;
        int i = (colorValueIn & 0xFF0000) >> 16;
        int j = (colorValueIn & 0xFF00) >> 8;
        int k = (colorValueIn & 0xFF) >> 0;
        this.oreColor = new float[]{(float)i / 255.0f, (float)j / 255.0f, (float)k / 255.0f};
    }

    public float getOreColor(int index) {
        return this.oreColor[index];
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public static TargetOreType Type(int value) {
        if (value < 0 || value >= ID.length) {
            value = 0;
        }
        return ID[value];
    }

    public static float Color(String name, int index) {
        for (TargetOreType ore : TargetOreType.values()) {
            if (ore.getName() != name) continue;
            return ore.getOreColor(index);
        }
        return 1.0f;
    }

    public int id() {
        switch (this) {
            case coal: {
                return 16;
            }
            case iron: {
                return 15;
            }
            case gold: {
                return 14;
            }
            case diamond: {
                return 56;
            }
            case emerald: {
                return 129;
            }
            case lapis: {
                return 21;
            }
            case redstone: {
                return 73;
            }
            case quarts: {
                return 153;
            }
            case chest: {
                return 54;
            }
        }
        return 92;
    }

    static {
        ID = new TargetOreType[TargetOreType.values().length];
    }
}

