/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.events;

import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.cap.IBaublesItemHandler;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.capabilities.InventoryContainerCapability.ITrinketContainerHandler;
import xzeroair.trinkets.capabilities.InventoryContainerCapability.TrinketContainerProvider;
import xzeroair.trinkets.util.interfaces.IAccessoryInterface;

public class BaubleEventHandler {
    @SubscribeEvent
    public void EntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            IBaublesItemHandler baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (int i = 0; i < baubles2.getSlots(); ++i) {
                ItemStack stack = baubles2.getStackInSlot(i);
                if (stack == null || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface bauble = (IAccessoryInterface)stack.func_77973_b();
                bauble.eventEntityJoinWorld(stack, (EntityLivingBase)player);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void clientTickEvent(TickEvent.ClientTickEvent event) {
    }

    @SubscribeEvent
    public void PlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
    }

    @SubscribeEvent
    public void PlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        EntityPlayer player = event.player;
        IBaublesItemHandler baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)player);
        for (int i = 0; i < baubles2.getSlots(); ++i) {
            ItemStack stack = baubles2.getStackInSlot(i);
            if (stack == null || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
            IAccessoryInterface bauble = (IAccessoryInterface)stack.func_77973_b();
            bauble.eventPlayerLogout(stack, (EntityLivingBase)player);
        }
    }

    @SubscribeEvent
    public void PlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
    }

    @SubscribeEvent
    public void playerUpdate(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (event.phase == TickEvent.Phase.END) {
            IBaublesItemHandler baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (int i = 0; i < baubles2.getSlots(); ++i) {
                ItemStack stack = baubles2.getStackInSlot(i);
                if (!(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface bauble = (IAccessoryInterface)stack.func_77973_b();
                bauble.eventPlayerTick(stack, player);
            }
            ITrinketContainerHandler Trinket = (ITrinketContainerHandler)player.getCapability(TrinketContainerProvider.containerCap, null);
            if (Trinket != null) {
                for (int i = 0; i < Trinket.getSlots(); ++i) {
                    ItemStack stack = Trinket.getStackInSlot(i);
                    if (!(stack.func_77973_b() instanceof IBauble)) continue;
                    IBauble trinket = (IBauble)stack.func_77973_b();
                    trinket.onWornTick(stack, (EntityLivingBase)player);
                }
            }
        }
    }

    @SubscribeEvent
    public void LivingUpdate(LivingEvent.LivingUpdateEvent event) {
    }

    @SubscribeEvent
    public void livingJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            IBaublesItemHandler baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (int i = 0; i < baubles2.getSlots(); ++i) {
                ItemStack stack = baubles2.getStackInSlot(i);
                if (stack == null || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface bauble = (IAccessoryInterface)stack.func_77973_b();
                bauble.eventLivingJump(stack, (EntityLivingBase)player);
            }
        }
    }

    @SubscribeEvent
    public void livingFall(LivingFallEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            IBaublesItemHandler baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (int i = 0; i < baubles2.getSlots(); ++i) {
                ItemStack stack = baubles2.getStackInSlot(i);
                if (stack == null || !(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface bauble = (IAccessoryInterface)stack.func_77973_b();
                bauble.eventLivingFall(event, stack, (EntityLivingBase)player);
            }
        }
    }

    @SubscribeEvent
    public void TargetEvent(LivingSetAttackTargetEvent event) {
        if (event.getTarget() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getTarget();
            IBaublesItemHandler baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (int i = 0; i < baubles2.getSlots(); ++i) {
                ItemStack stack = baubles2.getStackInSlot(i);
                if (!(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface trinket = (IAccessoryInterface)stack.func_77973_b();
                trinket.eventSetAttackTarget(event, stack, (EntityLivingBase)player);
            }
        }
    }

    @SubscribeEvent
    public void experienceDropEvent(LivingExperienceDropEvent event) {
        if (event.getAttackingPlayer() instanceof EntityPlayer) {
            EntityPlayer player = event.getAttackingPlayer();
            IBaublesItemHandler baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (int i = 0; i < baubles2.getSlots(); ++i) {
                ItemStack stack = baubles2.getStackInSlot(i);
                if (!(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface trinket = (IAccessoryInterface)stack.func_77973_b();
                trinket.eventLivingExperienceDrops(event, stack, (EntityLivingBase)player);
            }
        }
    }

    @SubscribeEvent
    public void ItemDropEvent(LivingDropsEvent event) {
        if (event.getSource().func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            IBaublesItemHandler baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (int i = 0; i < baubles2.getSlots(); ++i) {
                ItemStack stack = baubles2.getStackInSlot(i);
                if (!(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                IAccessoryInterface trinket = (IAccessoryInterface)stack.func_77973_b();
                trinket.eventLivingDrops(event, stack, (EntityLivingBase)player);
            }
        }
    }

    @SubscribeEvent
    public void deathEvent(LivingDamageEvent event) {
        IAccessoryInterface trinket;
        ItemStack stack;
        int i;
        IBaublesItemHandler baubles2;
        EntityPlayer player;
        if (event.getEntity() instanceof EntityPlayer) {
            player = (EntityPlayer)event.getEntity();
            baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (i = 0; i < baubles2.getSlots(); ++i) {
                stack = baubles2.getStackInSlot(i);
                if (!(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                trinket = (IAccessoryInterface)stack.func_77973_b();
                trinket.eventLivingDamageAttacked(event, stack, (EntityLivingBase)player);
            }
        }
        if (event.getSource().func_76346_g() instanceof EntityPlayer) {
            player = (EntityPlayer)event.getSource().func_76346_g();
            baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (i = 0; i < baubles2.getSlots(); ++i) {
                stack = baubles2.getStackInSlot(i);
                if (!(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                trinket = (IAccessoryInterface)stack.func_77973_b();
                trinket.eventLivingDamageAttacker(event, stack, (EntityLivingBase)player);
            }
        }
    }

    @SubscribeEvent
    public void HurtEvent(LivingHurtEvent event) {
        IAccessoryInterface trinket;
        ItemStack stack;
        int i;
        IBaublesItemHandler baubles2;
        EntityPlayer player;
        if (event.getEntity() instanceof EntityPlayer) {
            player = (EntityPlayer)event.getEntity();
            baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (i = 0; i < baubles2.getSlots(); ++i) {
                stack = baubles2.getStackInSlot(i);
                if (!(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                trinket = (IAccessoryInterface)stack.func_77973_b();
                trinket.eventPlayerHurt(event, stack, (EntityLivingBase)player);
            }
        }
        if (event.getEntityLiving() != null && event.getSource().func_76346_g() instanceof EntityPlayer) {
            player = (EntityPlayer)event.getSource().func_76346_g();
            baubles2 = BaublesApi.getBaublesHandler((EntityPlayer)player);
            for (i = 0; i < baubles2.getSlots(); ++i) {
                stack = baubles2.getStackInSlot(i);
                if (!(stack.func_77973_b() instanceof IAccessoryInterface)) continue;
                trinket = (IAccessoryInterface)stack.func_77973_b();
                trinket.eventLivingHurt(event, stack, (EntityLivingBase)player);
            }
        }
    }
}

