/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.items.trinkets;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.capabilities.TrinketCap.TrinketProvider;
import xzeroair.trinkets.init.ModItems;
import xzeroair.trinkets.items.base.AccessoryBase;
import xzeroair.trinkets.network.NetworkHandler;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.compat.toughasnails.TANCompat;
import xzeroair.trinkets.util.helpers.OreTrackingHelper;
import xzeroair.trinkets.util.interfaces.IAccessoryInterface;

public class TrinketDragonsEye
extends AccessoryBase {
    public TrinketDragonsEye(String name) {
        super(name);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        IAccessoryInterface iCap = (IAccessoryInterface)stack.getCapability(TrinketProvider.itemCapability, null);
        if (iCap != null) {
            String Type2 = iCap.oreTarget() < 0 ? "None" : TrinketsConfig.SERVER.DRAGON_EYE.BLOCKS.Blocks[iCap.oreTarget()];
            String getName = Type2.contains(";") ? OreTrackingHelper.translateOreName(Type2) : Type2.replace("ore", "");
            String value = iCap.ability() ? "Night Vision on" : "Night Vision Off";
            String value2 = iCap.oreTarget() < 0 ? "Current Target: None" : "Current Target: " + getName;
            tooltip.add(value);
            tooltip.add(value2);
        }
    }

    @Override
    public void eventPlayerTick(ItemStack stack, EntityPlayer player) {
        IAccessoryInterface itemNBT = (IAccessoryInterface)stack.getCapability(TrinketProvider.itemCapability, null);
        if (itemNBT != null) {
            if (itemNBT.ability()) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 210, 0, false, false));
            } else {
                player.func_184589_d(MobEffects.field_76439_r);
            }
        }
        player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 150, 0, false, false));
        if (player.func_70027_ad()) {
            player.func_70066_B();
        }
        if (TrinketsConfig.SERVER.DRAGON_EYE.prevent_blindness && player.func_70644_a(MobEffects.field_76440_q)) {
            player.func_184589_d(MobEffects.field_76440_q);
        }
        if (TrinketsConfig.SERVER.DRAGON_EYE.immuneToHeat) {
            TANCompat.immuneToHeat(player);
        }
    }

    @Override
    public void eventEntityJoinWorld(ItemStack stack, EntityLivingBase player) {
        IAccessoryInterface ICap = (IAccessoryInterface)stack.getCapability(TrinketProvider.itemCapability, null);
        if (ICap != null && !player.field_70170_p.field_72995_K) {
            ICap.setOreTarget(-1);
            NetworkHandler.sendItemDataTo(player, stack, ICap, true, (EntityPlayerMP)player);
        }
    }

    @Override
    public boolean playerCanEquip(ItemStack stack, EntityLivingBase player) {
        if (TrinketHelper.AccessoryCheck(player, ModItems.trinkets.TrinketEnderTiara) || TrinketHelper.AccessoryCheck(player, stack.func_77973_b())) {
            return false;
        }
        return super.playerCanEquip(stack, player);
    }

    @Override
    public void playerEquipped(ItemStack stack, EntityLivingBase player) {
        player.func_184185_a(SoundEvents.field_187716_o, 0.75f, 1.9f);
        super.playerEquipped(stack, player);
    }

    @Override
    public void playerUnequipped(ItemStack stack, EntityLivingBase player) {
        player.func_184185_a(SoundEvents.field_187716_o, 0.75f, 2.0f);
        super.playerUnequipped(stack, player);
    }

    @Override
    public boolean ItemEnabled() {
        return TrinketsConfig.SERVER.DRAGON_EYE.enabled;
    }

    @Override
    public boolean hasDiscription(ItemStack stack) {
        return true;
    }
}

