/*
 * Decompiled with CFR 0.152.
 */
package xzeroair.trinkets.items.trinkets;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xzeroair.trinkets.api.TrinketHelper;
import xzeroair.trinkets.init.ModItems;
import xzeroair.trinkets.items.base.AccessoryBase;
import xzeroair.trinkets.util.TrinketsConfig;
import xzeroair.trinkets.util.compat.toughasnails.TANCompat;
import xzeroair.trinkets.util.helpers.CallHelper;

public class TrinketEnderTiara
extends AccessoryBase {
    public TrinketEnderTiara(String name) {
        super(name);
    }

    @Override
    public void eventPlayerTick(ItemStack stack, EntityPlayer player) {
        if (TrinketsConfig.SERVER.ENDER_CROWN.water_hurts && (player.func_70090_H() || player.func_70026_G())) {
            player.func_70097_a(DamageSource.field_76377_j, 2.0f);
        }
        if (TrinketsConfig.SERVER.ENDER_CROWN.immuneToCold) {
            TANCompat.immuneToCold(player);
        }
    }

    @Override
    public boolean playerCanEquip(ItemStack stack, EntityLivingBase player) {
        if (TrinketHelper.AccessoryCheck(player, ModItems.trinkets.TrinketDragonsEye) || TrinketHelper.AccessoryCheck(player, stack.func_77973_b())) {
            return false;
        }
        return super.playerCanEquip(stack, player);
    }

    @Override
    public void playerEquipped(ItemStack stack, EntityLivingBase player) {
        player.func_184185_a(SoundEvents.field_187716_o, 0.75f, 1.9f);
        super.playerEquipped(stack, player);
    }

    @Override
    public void playerUnequipped(ItemStack stack, EntityLivingBase player) {
        player.func_184185_a(SoundEvents.field_187716_o, 0.75f, 2.0f);
        super.playerUnequipped(stack, player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void playerRender(ItemStack stack, EntityLivingBase player, float partialTicks, boolean isBauble) {
        if (!TrinketsConfig.CLIENT.ENDER_CROWN.doRender) {
            return;
        }
        ModelBase tiara = CallHelper.getModel("tiara");
        float scale = 0.07f;
        float yaw = player.field_70758_at + (player.field_70759_as - player.field_70758_at) * partialTicks;
        float yawOffset = player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * partialTicks;
        float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * partialTicks;
        GlStateManager.func_179114_b((float)yawOffset, (float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(yaw - 270.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)-0.05, (double)-0.63, (double)0.0);
        if (player.func_70093_af()) {
            GlStateManager.func_179109_b((float)(0.25f * MathHelper.func_76126_a((float)(player.field_70125_A * (float)Math.PI / 180.0f))), (float)(0.25f * MathHelper.func_76134_b((float)(player.field_70125_A * (float)Math.PI / 180.0f))), (float)0.0f);
        }
        if (player.func_190630_a(EntityEquipmentSlot.HEAD)) {
            GlStateManager.func_179109_b((float)0.04f, (float)-0.08f, (float)0.0f);
            GlStateManager.func_179152_a((float)1.1f, (float)1.1f, (float)1.1f);
        }
        GlStateManager.func_179152_a((float)0.07f, (float)0.07f, (float)0.07f);
        tiara.func_78088_a((Entity)player, player.field_184619_aG, player.field_70721_aZ, (float)player.field_70173_aa, player.field_70177_z, player.field_70125_A, 1.0f);
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return EnchantmentHelper.func_82781_a((ItemStack)book).containsKey(Enchantments.field_190941_k);
    }

    @Override
    public boolean ItemEnabled() {
        return TrinketsConfig.SERVER.ENDER_CROWN.enabled;
    }

    @Override
    public boolean hasDiscription(ItemStack stack) {
        return true;
    }
}

